/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.storm;

import CoroUtil.util.Vec3;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.behavior.ParticleBehaviorSandstorm;
import extendedrenderer.particle.entity.EntityRotFX;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weather2.CommonProxy;
import weather2.client.entity.particle.ParticleSandstorm;
import weather2.config.ConfigParticle;
import weather2.config.ConfigSand;
import weather2.util.CachedNBTTagCompound;
import weather2.util.WeatherUtil;
import weather2.util.WeatherUtilBlock;
import weather2.weathersystem.WeatherManagerBase;
import weather2.weathersystem.storm.EnumWeatherObjectType;
import weather2.weathersystem.storm.WeatherObject;
import weather2.weathersystem.wind.WindManager;

public class WeatherObjectSandstorm
extends WeatherObject {
    public int height = 0;
    public Vec3 posSpawn = new Vec3(0.0, 0.0, 0.0);
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesCloud;
    public ParticleBehaviorSandstorm particleBehavior;
    public int age = 0;
    public int sizePeak = 1;
    public int ageFadeout = 0;
    public int ageFadeoutMax = 6000;
    public boolean isFrontGrowing = true;
    public Random rand = new Random();

    public WeatherObjectSandstorm(WeatherManagerBase parManager) {
        super(parManager);
        this.weatherObjectType = EnumWeatherObjectType.SAND;
        if (parManager.getWorld().field_72995_K) {
            this.listParticlesCloud = new ArrayList<EntityRotFX>();
        }
    }

    public void initSandstormSpawn(Vec3 pos) {
        this.pos = new Vec3(pos);
        this.size = 1;
        this.sizePeak = 1;
        this.maxSize = 100;
        World world = this.manager.getWorld();
        int yy = WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(pos.xCoord, 0.0, pos.zCoord)).func_177956_o();
        pos.yCoord = yy;
        this.posGround = new Vec3(pos);
        this.posSpawn = new Vec3(this.pos);
    }

    public float getSandstormScale() {
        if (this.isFrontGrowing) {
            return (float)this.size / (float)this.maxSize;
        }
        return 1.0f - (float)this.ageFadeout / (float)this.ageFadeoutMax;
    }

    public static boolean isDesert(Biome biome) {
        return WeatherObjectSandstorm.isDesert(biome, false);
    }

    public static boolean isDesert(Biome biome, boolean forSpawn) {
        return biome == Biomes.field_76769_d || biome == Biomes.field_76786_s || !forSpawn && biome == Biomes.field_76781_i || biome.field_76791_y.toLowerCase().contains("desert");
    }

    public void tickProgressionAndMovement() {
        World world = this.manager.getWorld();
        WindManager windMan = this.manager.getWindManager();
        float angle = windMan.getWindAngleForClouds();
        float speedWind = windMan.getWindSpeedForClouds();
        if (!world.field_72995_K) {
            Biome biomeIn;
            ++this.age;
            BlockPos posBlock = this.pos.toBlockPos();
            this.isFrontGrowing = this.isFrontGrowing && world.func_175667_e(posBlock) ? WeatherObjectSandstorm.isDesert(biomeIn = world.getBiomeForCoordsBody(posBlock)) : false;
            int sizeAdjRate = 10;
            if (this.isFrontGrowing) {
                if (world.func_82737_E() % (long)sizeAdjRate == 0L && this.size < this.maxSize) {
                    ++this.size;
                }
            } else {
                if (world.func_82737_E() % (long)sizeAdjRate == 0L && this.size > 0) {
                    --this.size;
                }
                if (this.ageFadeout < this.ageFadeoutMax) {
                    ++this.ageFadeout;
                } else {
                    this.setDead();
                }
            }
            if (this.size > this.sizePeak) {
                this.sizePeak = this.size;
            }
            if (windMan.highWindTimer < 100) {
                windMan.highWindTimer = 100;
            }
        }
        double vecX = -Math.sin(Math.toRadians(angle));
        double vecZ = Math.cos(Math.toRadians(angle));
        double speed = (double)speedWind * 0.3;
        if (this.size > 0) {
            this.pos.xCoord += vecX * speed;
            this.pos.zCoord += vecZ * speed;
        }
        int yy = WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(this.pos.xCoord, 0.0, this.pos.zCoord)).func_177956_o();
        this.pos.yCoord = yy + 1;
    }

    public void tickBlockSandBuildup() {
        World world = this.manager.getWorld();
        WindManager windMan = this.manager.getWindManager();
        float angle = windMan.getWindAngleForClouds();
        int delay = ConfigSand.Sandstorm_Sand_Buildup_TickRate;
        int loop = (int)((float)ConfigSand.Sandstorm_Sand_Buildup_LoopAmountBase * this.getSandstormScale());
        int count = 0;
        if (!world.field_72995_K && world.func_82737_E() % (long)delay == 0L) {
            for (int i = 0; i < loop; ++i) {
                if (this.rand.nextDouble() >= (double)this.getSandstormScale()) continue;
                Vec3 vecPos = this.getRandomPosInSandstorm();
                int y = WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(vecPos.xCoord, 0.0, vecPos.zCoord)).func_177956_o();
                vecPos.yCoord = y;
                if (!world.func_175667_e(vecPos.toBlockPos())) continue;
                Biome biomeIn = world.getBiomeForCoordsBody(vecPos.toBlockPos());
                if (ConfigSand.Sandstorm_Sand_Buildup_AllowOutsideDesert || WeatherObjectSandstorm.isDesert(biomeIn)) {
                    WeatherUtilBlock.fillAgainstWallSmoothly(world, vecPos, angle, 15.0f, 2.0f, CommonProxy.blockSandLayer);
                }
                ++count;
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.manager == null) {
            System.out.println("WeatherManager is null for " + this + ", why!!!");
            return;
        }
        World world = this.manager.getWorld();
        WindManager windMan = this.manager.getWindManager();
        if (world == null) {
            System.out.println("world is null for " + this + ", why!!!");
            return;
        }
        if (WeatherUtil.isPausedSideSafe(world)) {
            return;
        }
        this.tickProgressionAndMovement();
        int yy = WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(this.pos.xCoord, 0.0, this.pos.zCoord)).func_177956_o();
        if (world.field_72995_K) {
            this.tickClient();
        }
        if ((double)this.getSandstormScale() > 0.2) {
            this.tickBlockSandBuildup();
        }
        this.posGround.xCoord = this.pos.xCoord;
        this.posGround.yCoord = yy;
        this.posGround.zCoord = this.pos.zCoord;
    }

    @SideOnly(value=Side.CLIENT)
    public void tickClient() {
        double distanceToCenter;
        double distanceToFront;
        Minecraft mc = Minecraft.func_71410_x();
        World world = this.manager.getWorld();
        WindManager windMan = this.manager.getWindManager();
        if (this.particleBehavior == null) {
            this.particleBehavior = new ParticleBehaviorSandstorm(this.pos);
        }
        boolean isInside = (distanceToFront = (distanceToCenter = this.pos.distanceTo(new Vec3(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v))) - (double)this.size) < 0.0;
        double circ = Math.PI * (double)this.size;
        double distBetweenParticles = 3.0;
        double degRate = 360.0 / (circ / distBetweenParticles);
        if (mc.field_71441_e.func_82737_E() % 40L == 0L) {
            // empty if block
        }
        Random rand = mc.field_71441_e.field_73012_v;
        this.height = this.size / 4;
        int heightLayers = Math.max(1, this.height / (int)distBetweenParticles);
        if (mc.field_71441_e.func_82737_E() % 10L == 0L) {
            // empty if block
        }
        double distFromSpawn = this.posSpawn.distanceTo(this.pos);
        double xVec = this.posSpawn.xCoord - this.pos.xCoord;
        double zVec = this.posSpawn.zCoord - this.pos.zCoord;
        double directionAngle = Math.atan2(zVec, xVec);
        double directionAngleDeg = Math.toDegrees(directionAngle);
        int spawnedThisTick = 0;
        float sandstormScale = this.getSandstormScale();
        double sandstormParticleRateDust = ConfigParticle.Sandstorm_Particle_Dust_effect_rate;
        if (this.size > 0) {
            for (int heightLayer = 0; heightLayer < heightLayers && spawnedThisTick < 500; ++heightLayer) {
                double i = directionAngleDeg + rand.nextDouble() * 180.0;
                if (mc.field_71441_e.func_82737_E() % 2L != 0L || rand.nextDouble() >= sandstormParticleRateDust) continue;
                double sizeSub = (double)heightLayer * 2.0;
                double sizeDyn = (double)this.size - sizeSub;
                double inwardsAdj = rand.nextDouble() * 5.0;
                double sizeRand = sizeDyn + -inwardsAdj;
                double x = this.pos.xCoord + -Math.sin(Math.toRadians(i)) * sizeRand;
                double z = this.pos.zCoord + Math.cos(Math.toRadians(i)) * sizeRand;
                double y = this.pos.yCoord + (double)heightLayer * distBetweenParticles * 2.0;
                TextureAtlasSprite sprite = ParticleRegistry.cloud256;
                if (WeatherUtil.isAprilFoolsDay()) {
                    sprite = ParticleRegistry.chicken;
                }
                ParticleSandstorm part = new ParticleSandstorm((World)mc.field_71441_e, x, y, z, 0.0, 0.0, 0.0, sprite);
                this.particleBehavior.initParticle((EntityRotFX)part);
                part.angleToStorm = i;
                part.distAdj = sizeRand;
                part.heightLayer = heightLayer;
                part.lockPosition = true;
                part.setFacePlayer(false);
                part.isTransparent = true;
                part.rotationYaw = (float)i + (float)rand.nextInt(20) - 10.0f;
                part.rotationPitch = 0.0f;
                part.func_187114_a(300);
                part.setGravity(0.09f);
                part.func_82338_g(1.0f);
                float brightnessMulti = 1.0f - rand.nextFloat() * 0.5f;
                part.func_70538_b(0.65f * brightnessMulti, 0.6f * brightnessMulti, 0.3f * brightnessMulti);
                part.setScale(100.0f);
                part.setKillOnCollide(true);
                this.particleBehavior.particles.add(part);
                part.spawnAsWeatherEffect();
                ++spawnedThisTick;
            }
        }
        if (spawnedThisTick > 0) {
            spawnedThisTick = 0;
        }
        if (mc.field_71441_e.func_82737_E() % 20L == 0L) {
            // empty if block
        }
        double spawnAngle = Math.atan2(this.sizePeak, distFromSpawn);
        spawnAngle *= 1.2;
        double spawnDistInc = 10.0;
        double extraDistSpawnIntoWall = (double)this.sizePeak / 2.0;
        if (mc.field_71441_e.func_82737_E() % 3L == 0L) {
            for (double spawnDistTick = 0.0; spawnDistTick < distFromSpawn + extraDistSpawnIntoWall && spawnedThisTick < 500; spawnDistTick += spawnDistInc) {
                if (rand.nextDouble() >= (double)sandstormScale || rand.nextDouble() >= sandstormParticleRateDust) continue;
                double randAngle = directionAngle + 1.5707963267948966 - spawnAngle + rand.nextDouble() * spawnAngle * 2.0;
                double randHeight = spawnDistTick / distFromSpawn * (double)this.height * 1.2 * rand.nextDouble();
                double x = this.posSpawn.xCoord + -Math.sin(randAngle) * spawnDistTick;
                double z = this.posSpawn.zCoord + Math.cos(randAngle) * spawnDistTick;
                int yy = WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(x += (rand.nextDouble() - rand.nextDouble()) * 30.0, 0.0, z += (rand.nextDouble() - rand.nextDouble()) * 30.0)).func_177956_o();
                double y = (double)(yy + 2) + randHeight;
                TextureAtlasSprite sprite = ParticleRegistry.cloud256;
                if (WeatherUtil.isAprilFoolsDay()) {
                    sprite = ParticleRegistry.chicken;
                }
                ParticleSandstorm part = new ParticleSandstorm((World)mc.field_71441_e, x, y, z, 0.0, 0.0, 0.0, sprite);
                this.particleBehavior.initParticle((EntityRotFX)part);
                part.setFacePlayer(false);
                part.isTransparent = true;
                part.rotationYaw = rand.nextInt(360);
                part.rotationPitch = rand.nextInt(360);
                part.func_187114_a(100);
                part.setGravity(0.09f);
                part.func_82338_g(1.0f);
                float brightnessMulti = 1.0f - rand.nextFloat() * 0.5f;
                part.func_70538_b(0.65f * brightnessMulti, 0.6f * brightnessMulti, 0.3f * brightnessMulti);
                part.setScale(100.0f);
                part.setKillOnCollide(true);
                part.windWeight = 1.0f;
                this.particleBehavior.particles.add(part);
                part.spawnAsWeatherEffect();
                ++spawnedThisTick;
            }
        }
        if (spawnedThisTick > 0) {
            // empty if block
        }
        float angle = windMan.getWindAngleForClouds();
        float speedWind = windMan.getWindSpeedForClouds();
        double vecX = -Math.sin(Math.toRadians(angle));
        double vecZ = Math.cos(Math.toRadians(angle));
        double speed = 0.8;
        this.particleBehavior.coordSource = this.pos;
        this.particleBehavior.tickUpdateList();
        for (int i = 0; i < this.particleBehavior.particles.size(); ++i) {
            ParticleSandstorm particle = (ParticleSandstorm)((Object)this.particleBehavior.particles.get(i));
            if (particle.lockPosition) {
                if (this.size > 0) {
                    double x = this.pos.xCoord + -Math.sin(Math.toRadians(particle.angleToStorm)) * particle.distAdj;
                    double z = this.pos.zCoord + Math.cos(Math.toRadians(particle.angleToStorm)) * particle.distAdj;
                    double y = this.pos.yCoord + (double)particle.heightLayer * distBetweenParticles;
                    this.moveToPosition(particle, x, y, z, 0.01);
                    continue;
                }
                particle.setMotionX(vecX * (double)speedWind * (double)0.3f);
                particle.setMotionZ(vecZ * (double)speedWind * (double)0.3f);
                continue;
            }
            particle.setMotionX(vecX * speed);
            particle.setMotionZ(vecZ * speed);
        }
    }

    public Vec3 getRandomPosInSandstorm() {
        double extraDistSpawnIntoWall = (double)this.sizePeak / 2.0;
        double distFromSpawn = this.posSpawn.distanceTo(this.pos);
        double randDist = this.rand.nextDouble() * (distFromSpawn + extraDistSpawnIntoWall);
        double xVec = this.posSpawn.xCoord - this.pos.xCoord;
        double zVec = this.posSpawn.zCoord - this.pos.zCoord;
        double spawnAngle = Math.atan2(this.sizePeak, distFromSpawn);
        double directionAngle = Math.atan2(zVec, xVec);
        double randAngle = directionAngle + 1.5707963267948966 - spawnAngle + this.rand.nextDouble() * spawnAngle * 2.0;
        double x = this.posSpawn.xCoord + -Math.sin(randAngle) * randDist;
        double z = this.posSpawn.zCoord + Math.cos(randAngle) * randDist;
        return new Vec3(x, 0.0, z);
    }

    public List<Vec3> getSandstormAsShape() {
        ArrayList<Vec3> listPoints = new ArrayList<Vec3>();
        double extraDistSpawnIntoWall = (double)this.sizePeak / 2.0;
        double distFromSpawn = this.posSpawn.distanceTo(this.pos);
        listPoints.add(new Vec3(this.posSpawn.xCoord, 0.0, this.posSpawn.zCoord));
        double xVec = this.posSpawn.xCoord - this.pos.xCoord;
        double zVec = this.posSpawn.zCoord - this.pos.zCoord;
        double spawnAngle = Math.atan2(this.sizePeak, distFromSpawn);
        double directionAngle = Math.atan2(zVec, xVec);
        double angleLeft = directionAngle + 1.5707963267948966 - spawnAngle;
        double angleRight = directionAngle + 1.5707963267948966 - spawnAngle + spawnAngle * 2.0;
        double angleLeft1 = directionAngle + 1.5707963267948966 - spawnAngle;
        double angleRight1 = directionAngle + 1.5707963267948966 - spawnAngle + spawnAngle * 2.0;
        double wat = extraDistSpawnIntoWall;
        double xLeft1 = this.posSpawn.xCoord + -Math.sin(angleLeft1) * wat;
        double zLeft1 = this.posSpawn.zCoord + Math.cos(angleLeft1) * wat;
        double xRight1 = this.posSpawn.xCoord + -Math.sin(angleRight1) * wat;
        double zRight1 = this.posSpawn.zCoord + Math.cos(angleRight1) * wat;
        double xLeft = this.posSpawn.xCoord + -Math.sin(angleLeft) * (distFromSpawn + extraDistSpawnIntoWall);
        double zLeft = this.posSpawn.zCoord + Math.cos(angleLeft) * (distFromSpawn + extraDistSpawnIntoWall);
        double xRight = this.posSpawn.xCoord + -Math.sin(angleRight) * (distFromSpawn + extraDistSpawnIntoWall);
        double zRight = this.posSpawn.zCoord + Math.cos(angleRight) * (distFromSpawn + extraDistSpawnIntoWall);
        listPoints.add(new Vec3(xLeft, 0.0, zLeft));
        listPoints.add(new Vec3(xRight, 0.0, zRight));
        return listPoints;
    }

    public void moveToPosition(ParticleSandstorm particle, double x, double y, double z, double maxSpeed) {
        if (particle.getPosX() > x) {
            particle.setMotionX(particle.getMotionX() + -maxSpeed);
        } else {
            particle.setMotionX(particle.getMotionX() + maxSpeed);
        }
        if (particle.getPosZ() > z) {
            particle.setMotionZ(particle.getMotionZ() + -maxSpeed);
        } else {
            particle.setMotionZ(particle.getMotionZ() + maxSpeed);
        }
        double distXZ = Math.sqrt((particle.getPosX() - x) * 2.0 + (particle.getPosZ() - z) * 2.0);
        if (distXZ < 5.0) {
            particle.setMotionX(particle.getMotionX() * 0.8);
            particle.setMotionZ(particle.getMotionZ() * 0.8);
        }
    }

    @Override
    public int getUpdateRateForNetwork() {
        return 1;
    }

    @Override
    public void nbtSyncForClient() {
        super.nbtSyncForClient();
        CachedNBTTagCompound data = this.getNbtCache();
        data.setDouble("posSpawnX", this.posSpawn.xCoord);
        data.setDouble("posSpawnY", this.posSpawn.yCoord);
        data.setDouble("posSpawnZ", this.posSpawn.zCoord);
        data.setInteger("ageFadeout", this.ageFadeout);
        data.setInteger("ageFadeoutMax", this.ageFadeoutMax);
        data.setInteger("sizePeak", this.sizePeak);
        data.setInteger("age", this.age);
        data.setBoolean("isFrontGrowing", this.isFrontGrowing);
    }

    @Override
    public void nbtSyncFromServer() {
        super.nbtSyncFromServer();
        CachedNBTTagCompound parNBT = this.getNbtCache();
        this.posSpawn = new Vec3(parNBT.getDouble("posSpawnX"), parNBT.getDouble("posSpawnY"), parNBT.getDouble("posSpawnZ"));
        this.ageFadeout = parNBT.getInteger("ageFadeout");
        this.ageFadeoutMax = parNBT.getInteger("ageFadeoutMax");
        this.sizePeak = parNBT.getInteger("sizePeak");
        this.age = parNBT.getInteger("age");
        this.isFrontGrowing = parNBT.getBoolean("isFrontGrowing");
    }

    @Override
    public void readFromNBT() {
        super.readFromNBT();
        this.nbtSyncFromServer();
        CachedNBTTagCompound var1 = this.getNbtCache();
        this.motion = new Vec3(var1.getDouble("vecX"), var1.getDouble("vecY"), var1.getDouble("vecZ"));
    }

    @Override
    public void writeToNBT() {
        super.writeToNBT();
        this.nbtSyncForClient();
        CachedNBTTagCompound nbt = this.getNbtCache();
        nbt.setDouble("vecX", this.motion.xCoord);
        nbt.setDouble("vecY", this.motion.yCoord);
        nbt.setDouble("vecZ", this.motion.zCoord);
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void cleanupClient() {
        super.cleanupClient();
        this.listParticlesCloud.clear();
        if (this.particleBehavior != null && this.particleBehavior.particles != null) {
            this.particleBehavior.particles.clear();
        }
        this.particleBehavior = null;
    }
}

