/*
 * Decompiled with CFR 0.152.
 */
package c4.cherishedworlds.core;

import c4.cherishedworlds.CherishedWorlds;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.FileUtils;

public class FavoriteWorldsList {
    private static final Set<String> favorites = Sets.newHashSet();

    public static void loadFavoritesList() {
        try {
            favorites.clear();
            File file = new File(Loader.instance().getConfigDir(), "cherishedworlds/favorites.dat");
            NBTTagCompound nbttagcompound = CompressedStreamTools.func_74797_a((File)file);
            if (nbttagcompound == null) {
                return;
            }
            NBTTagList nbttaglist = nbttagcompound.func_150295_c("favorites", 8);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                favorites.add(nbttaglist.func_150307_f(i));
            }
        }
        catch (Exception exception) {
            CherishedWorlds.logger.error("Couldn't load favorites list", (Throwable)exception);
        }
    }

    public static void saveFavoritesList() {
        try {
            NBTTagList nbttaglist = new NBTTagList();
            for (String s : favorites) {
                nbttaglist.func_74742_a((NBTBase)new NBTTagString(s));
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74782_a("favorites", (NBTBase)nbttaglist);
            File file = new File(Loader.instance().getConfigDir(), "cherishedworlds/favorites.dat");
            if (!file.exists()) {
                FileUtils.forceMkdirParent((File)file);
            }
            CompressedStreamTools.func_74793_a((NBTTagCompound)nbttagcompound, (File)file);
        }
        catch (Exception exception) {
            CherishedWorlds.logger.error("Couldn't save favorites list", (Throwable)exception);
        }
    }

    public static boolean hasFavorite() {
        return !favorites.isEmpty();
    }

    public static boolean isFavorite(String fileName) {
        return favorites.contains(fileName);
    }

    public static void addFavorite(String name) {
        favorites.add(name);
    }

    public static void removeFavorite(String name) {
        favorites.remove(name);
    }
}

