/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.crash.CrashReport;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.client.gui.GuiNumberTextField;
import team.cqr.cqrepoured.client.util.GuiHelper;
import team.cqr.cqrepoured.util.tool.DungeonMapTask;

public class GuiDungeonMapTool
extends GuiScreen {
    private static int lastRadius = 100;
    private static long lastSeed = 0L;
    private static int lastDistance = 20;
    private static int lastSpread = 0;
    private static double lastRarityDivisor = 0.0;
    private static boolean lastGenerateBiomes = false;
    private final GuiScreen parent;
    private final List<GuiTextField> textFieldList = new ArrayList<GuiTextField>();
    private GuiNumberTextField textFieldRadius;
    private GuiNumberTextField textFieldSeed;
    private GuiButton buttonRandSeed;
    private GuiButton buttonWorldSeed;
    private GuiNumberTextField textFieldDistance;
    private GuiNumberTextField textFieldSpread;
    private GuiNumberTextField textFieldRarityDivisor;
    private GuiCheckBox checkBoxGenerateBiomes;
    private GuiButton buttonExit;
    private GuiButton buttonCancel;
    private GuiButton buttonCreateMap;
    private boolean canExit = true;
    @Nullable
    private DungeonMapTask task;

    public GuiDungeonMapTool(GuiScreen parent) {
        this.parent = parent;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int id = 0;
        this.textFieldRadius = new GuiNumberTextField(id++, this.field_146289_q, this.field_146294_l / 2 - 20, 30, 150, 20, false, false){

            @Override
            public boolean func_146201_a(char typedChar, int keyCode) {
                if (!super.func_146201_a(typedChar, keyCode)) {
                    return false;
                }
                try {
                    lastRadius = Integer.parseInt(this.func_146179_b());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return true;
            }

            public void func_146180_a(String textIn) {
                super.func_146180_a(textIn);
                try {
                    lastRadius = Integer.parseInt(this.func_146179_b());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        this.textFieldRadius.func_146180_a(Integer.toString(lastRadius));
        this.textFieldSeed = new GuiNumberTextField(id++, this.field_146289_q, this.field_146294_l / 2 - 20, 60, 150, 20, true, false){

            @Override
            public boolean func_146201_a(char typedChar, int keyCode) {
                if (!super.func_146201_a(typedChar, keyCode)) {
                    return false;
                }
                try {
                    lastSeed = Long.parseLong(this.func_146179_b());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return true;
            }

            public void func_146180_a(String textIn) {
                super.func_146180_a(textIn);
                try {
                    lastSeed = Long.parseLong(this.func_146179_b());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        this.textFieldSeed.func_146180_a(Long.toString(lastSeed));
        this.textFieldDistance = new GuiNumberTextField(id++, this.field_146289_q, this.field_146294_l / 2 - 20, 90, 150, 20, false, false){

            @Override
            public boolean func_146201_a(char typedChar, int keyCode) {
                if (!super.func_146201_a(typedChar, keyCode)) {
                    return false;
                }
                try {
                    lastDistance = Integer.parseInt(this.func_146179_b());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return true;
            }

            public void func_146180_a(String textIn) {
                super.func_146180_a(textIn);
                try {
                    lastDistance = Integer.parseInt(this.func_146179_b());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        this.textFieldDistance.func_146180_a(Integer.toString(lastDistance));
        this.textFieldDistance.func_146184_c(false);
        this.textFieldSpread = new GuiNumberTextField(id++, this.field_146289_q, this.field_146294_l / 2 - 20, 120, 150, 20, false, false){

            @Override
            public boolean func_146201_a(char typedChar, int keyCode) {
                if (!super.func_146201_a(typedChar, keyCode)) {
                    return false;
                }
                try {
                    lastSpread = Integer.parseInt(this.func_146179_b());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return true;
            }

            public void func_146180_a(String textIn) {
                super.func_146180_a(textIn);
                try {
                    lastSpread = Integer.parseInt(this.func_146179_b());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        this.textFieldSpread.func_146180_a(Integer.toString(lastSpread));
        this.textFieldSpread.func_146184_c(false);
        this.textFieldRarityDivisor = new GuiNumberTextField(id++, this.field_146289_q, this.field_146294_l / 2 - 20, 150, 150, 20, false, true){

            @Override
            public boolean func_146201_a(char typedChar, int keyCode) {
                if (!super.func_146201_a(typedChar, keyCode)) {
                    return false;
                }
                try {
                    lastRarityDivisor = Double.parseDouble(this.func_146179_b());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return true;
            }

            public void func_146180_a(String textIn) {
                super.func_146180_a(textIn);
                try {
                    lastRarityDivisor = Double.parseDouble(this.func_146179_b());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        this.textFieldRarityDivisor.func_146180_a(Double.toString(lastRarityDivisor));
        this.textFieldRarityDivisor.func_146184_c(false);
        this.buttonRandSeed = new GuiButton(id++, this.field_146294_l / 2 + 140, 60, 20, 20, "R"){

            public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
                if (!super.func_146116_c(mc, mouseX, mouseY)) {
                    return false;
                }
                GuiDungeonMapTool.this.textFieldSeed.func_146180_a(Long.toString(ThreadLocalRandom.current().nextLong()));
                return true;
            }
        };
        this.buttonWorldSeed = new GuiButton(id++, this.field_146294_l / 2 + 170, 60, 20, 20, "W"){

            public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
                if (!super.func_146116_c(mc, mouseX, mouseY)) {
                    return false;
                }
                GuiDungeonMapTool.this.textFieldSeed.func_146180_a(Long.toString(GuiDungeonMapTool.this.field_146297_k.func_71401_C().func_71218_a(0).func_72905_C()));
                return true;
            }
        };
        this.buttonWorldSeed.field_146124_l = this.field_146297_k.func_71387_A();
        this.buttonExit = new GuiButton(id++, 5, 5, 20, 20, "X"){

            public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
                if (!super.func_146116_c(mc, mouseX, mouseY)) {
                    return false;
                }
                if (!GuiDungeonMapTool.this.canExit) {
                    return false;
                }
                GuiDungeonMapTool.this.field_146297_k.func_147108_a(GuiDungeonMapTool.this.parent);
                return true;
            }
        };
        this.buttonCancel = new GuiButton(id++, this.field_146294_l / 2 - 102, this.field_146295_m - 24, 100, 20, "Cancel"){

            public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
                if (!super.func_146116_c(mc, mouseX, mouseY)) {
                    return false;
                }
                DungeonMapTask task1 = GuiDungeonMapTool.this.task;
                if (task1 != null) {
                    task1.cancel();
                }
                return true;
            }
        };
        this.buttonCancel.field_146124_l = false;
        this.buttonCreateMap = new GuiButton(id++, this.field_146294_l / 2 + 2, this.field_146295_m - 24, 100, 20, "Create Map"){

            public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
                if (!super.func_146116_c(mc, mouseX, mouseY)) {
                    return false;
                }
                int radius = GuiDungeonMapTool.this.textFieldRadius.getInt();
                long seed = GuiDungeonMapTool.this.textFieldSeed.getLong();
                boolean generateBiomes = GuiDungeonMapTool.this.checkBoxGenerateBiomes.isChecked();
                GuiDungeonMapTool.this.task = new DungeonMapTask(radius, seed, generateBiomes);
                GuiDungeonMapTool.this.canExit = false;
                ((GuiDungeonMapTool)GuiDungeonMapTool.this).buttonExit.field_146124_l = false;
                ((GuiDungeonMapTool)GuiDungeonMapTool.this).buttonCancel.field_146124_l = true;
                ((GuiDungeonMapTool)GuiDungeonMapTool.this).buttonCreateMap.field_146124_l = false;
                GuiDungeonMapTool.this.task.run().handleAsync((v, t) -> {
                    GuiDungeonMapTool.this.canExit = true;
                    ((GuiDungeonMapTool)GuiDungeonMapTool.this).buttonExit.field_146124_l = true;
                    ((GuiDungeonMapTool)GuiDungeonMapTool.this).buttonCancel.field_146124_l = false;
                    ((GuiDungeonMapTool)GuiDungeonMapTool.this).buttonCreateMap.field_146124_l = true;
                    if (t != null) {
                        if (t instanceof Exception) {
                            CQRMain.logger.error("Failed creating dungeon map", t);
                        } else {
                            mc.func_71404_a(new CrashReport("Failed generating dungeon map", t));
                        }
                    }
                    return null;
                });
                return true;
            }
        };
        this.checkBoxGenerateBiomes = new GuiCheckBox(id++, this.field_146294_l / 2 - 20, 180, "Generate Biomes", lastGenerateBiomes){

            public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
                if (!super.func_146116_c(mc, mouseX, mouseY)) {
                    return false;
                }
                lastGenerateBiomes = this.isChecked();
                return true;
            }

            public void setIsChecked(boolean isChecked) {
                super.setIsChecked(isChecked);
                lastGenerateBiomes = this.isChecked();
            }
        };
        this.textFieldList.add(this.textFieldRadius);
        this.textFieldList.add(this.textFieldSeed);
        this.field_146292_n.add(this.buttonRandSeed);
        this.field_146292_n.add(this.buttonWorldSeed);
        this.textFieldList.add(this.textFieldDistance);
        this.textFieldList.add(this.textFieldSpread);
        this.textFieldList.add(this.textFieldRarityDivisor);
        this.field_146292_n.add(this.checkBoxGenerateBiomes);
        this.field_146292_n.add(this.buttonExit);
        this.field_146292_n.add(this.buttonCancel);
        this.field_146292_n.add(this.buttonCreateMap);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        Optional<GuiTextField> focusedTextField = this.textFieldList.stream().filter(GuiTextField::func_146206_l).findFirst();
        if (focusedTextField.isPresent()) {
            if (keyCode == 1) {
                focusedTextField.get().func_146195_b(false);
            } else {
                focusedTextField.get().func_146201_a(typedChar, keyCode);
            }
        } else if (keyCode == 1) {
            if (this.canExit) {
                this.field_146297_k.func_147108_a(this.parent);
            }
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.textFieldList.forEach(tf -> tf.func_146192_a(mouseX, mouseY, mouseButton));
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.textFieldList.forEach(GuiTextField::func_146178_a);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146278_c(0);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.textFieldList.forEach(GuiTextField::func_146194_f);
        int i = 0;
        GuiHelper.drawString(this.field_146289_q, "Radius", this.field_146294_l / 2 - 75, ++i * 30 + 6, 0xF0F0F0, true, false);
        GuiHelper.drawString(this.field_146289_q, "Seed", this.field_146294_l / 2 - 75, ++i * 30 + 6, 0xF0F0F0, true, false);
        GuiHelper.drawString(this.field_146289_q, "Distance (WIP)", this.field_146294_l / 2 - 70, ++i * 30 + 6, 0xF0F0F0, true, false);
        GuiHelper.drawString(this.field_146289_q, "Spread (WIP)", this.field_146294_l / 2 - 75, ++i * 30 + 6, 0xF0F0F0, true, false);
        GuiHelper.drawString(this.field_146289_q, "Rarity Divisor (WIP)", this.field_146294_l / 2 - 75, ++i * 30 + 6, 0xF0F0F0, true, false);
        DungeonMapTask task1 = this.task;
        if (task1 != null) {
            GuiHelper.drawString(this.field_146289_q, this.task.getProgress().toString(), this.field_146294_l / 2 + 120, this.field_146295_m - 18, 0xF0F0F0, false, false);
        }
    }
}

