/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.render.entity;

import java.nio.FloatBuffer;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.geckolib3.util.MatrixStack;
import team.cqr.cqrepoured.client.render.entity.layer.geo.LayerElectrocuteGeo;
import team.cqr.cqrepoured.client.render.entity.layer.geo.LayerMagicArmorGeo;
import team.cqr.cqrepoured.client.util.BlockRenderUtil;
import team.cqr.cqrepoured.client.util.MatrixUtil;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;

public abstract class RenderCQREntityGeo<T extends AbstractEntityCQR>
extends GeoEntityRenderer<T> {
    public static final ResourceLocation TEXTURES_ARMOR = new ResourceLocation("cqrepoured", "textures/entity/magic_armor/mages.png");
    protected double widthScale;
    protected double heightScale;
    public final Function<T, ResourceLocation> TEXTURE_GETTER;
    public final Function<T, ResourceLocation> MODEL_ID_GETTER = x$0 -> modelProvider.getModelLocation(x$0);
    private int currentModelRenderCycle = 0;
    private T currentEntityBeingRendered;
    private static Matrix4f matrix = new Matrix4f();

    protected RenderCQREntityGeo(RenderManager renderManager, AnimatedGeoModel<T> modelProvider) {
        this(renderManager, modelProvider, 1.0, 1.0, 0.0f);
    }

    protected RenderCQREntityGeo(RenderManager renderManager, AnimatedGeoModel<T> modelProvider, double widthScale, double heightScale, float shadowSize) {
        super(renderManager, modelProvider);
        this.TEXTURE_GETTER = x$0 -> modelProvider.getTextureLocation(x$0);
        this.field_76989_e = shadowSize;
        this.widthScale = widthScale;
        this.heightScale = heightScale;
        this.addLayer(new LayerElectrocuteGeo<T>(this, this.TEXTURE_GETTER, this.MODEL_ID_GETTER));
        this.addLayer(new LayerMagicArmorGeo<T>(this, this.TEXTURE_GETTER, this.MODEL_ID_GETTER));
    }

    public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.currentModelRenderCycle = 0;
        super.doRender(entity, x, y, z, entityYaw, partialTicks);
    }

    public void render(GeoModel model, T animatable, float partialTicks, float red, float green, float blue, float alpha) {
        super.render(model, animatable, partialTicks, red, green, blue, alpha);
        ++this.currentModelRenderCycle;
    }

    protected double getWidthScale(T entity) {
        return this.widthScale * (double)((AbstractEntityCQR)entity).getSizeVariation();
    }

    protected double getHeightScale(T entity) {
        return this.heightScale * (double)((AbstractEntityCQR)entity).getSizeVariation();
    }

    public void renderEarly(T animatable, float ticks, float red, float green, float blue, float partialTicks) {
        if (this.currentModelRenderCycle == 0) {
            double width = this.getWidthScale(animatable);
            double height = this.getHeightScale(animatable);
            GlStateManager.func_179139_a((double)width, (double)height, (double)width);
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.TEXTURE_GETTER.apply(entity);
    }

    public void renderLate(T animatable, float ticks, float red, float green, float blue, float partialTicks) {
        super.renderLate(animatable, ticks, red, green, blue, partialTicks);
        this.currentEntityBeingRendered = animatable;
    }

    public void renderRecursively(BufferBuilder builder, GeoBone bone, float red, float green, float blue, float alpha) {
        boolean customTextureMarker;
        boolean bl = customTextureMarker = this.currentModelRenderCycle == 0 && this.getTextureForBone(bone.getName(), this.currentEntityBeingRendered) != null;
        if (customTextureMarker) {
            this.func_110776_a(this.getTextureForBone(bone.getName(), this.currentEntityBeingRendered));
        }
        if (this.currentModelRenderCycle == 0) {
            ItemStack boneItem = this.getHeldItemForBone(bone.getName(), this.currentEntityBeingRendered);
            IBlockState boneBlock = this.getHeldBlockForBone(bone.getName(), this.currentEntityBeingRendered);
            if (boneItem != null || boneBlock != null) {
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.func_179094_E();
                RenderCQREntityGeo.multiplyMatrix(IGeoRenderer.MATRIX_STACK, bone);
                if (boneItem != null) {
                    this.preRenderItem(boneItem, bone.getName(), this.currentEntityBeingRendered);
                    Minecraft.func_71410_x().func_175597_ag().func_178099_a(this.currentEntityBeingRendered, boneItem, this.getCameraTransformForItemAtBone(boneItem, bone.getName()));
                    this.postRenderItem(boneItem, bone.getName(), this.currentEntityBeingRendered);
                }
                if (boneBlock != null) {
                    this.preRenderBlock(boneBlock, bone.getName(), this.currentEntityBeingRendered);
                    this.renderBlock(boneBlock, (Entity)this.currentEntityBeingRendered);
                    this.postRenderBlock(boneBlock, bone.getName(), this.currentEntityBeingRendered);
                }
                GlStateManager.func_179121_F();
                this.func_110776_a(this.getEntityTexture((EntityLivingBase)this.currentEntityBeingRendered));
                builder.func_181668_a(7, DefaultVertexFormats.field_181712_l);
            }
        }
        super.renderRecursively(builder, bone, red, green, blue, alpha);
        if (customTextureMarker) {
            this.func_110776_a(this.getEntityTexture((EntityLivingBase)this.currentEntityBeingRendered));
        }
    }

    private void renderBlock(IBlockState iBlockState, Entity currentEntity) {
        BlockRenderUtil.renderBlockAtEntity(iBlockState, currentEntity, (Render<? extends Entity>)this);
    }

    public static void multiplyMatrix(MatrixStack stack, GeoBone bone) {
        matrix.set(stack.getModelMatrix());
        matrix.transpose();
        MatrixUtil.matrixToFloat(MatrixUtil.floats, matrix);
        MatrixUtil.buffer.clear();
        MatrixUtil.buffer.put(MatrixUtil.floats);
        MatrixUtil.buffer.flip();
        GlStateManager.func_179110_a((FloatBuffer)MatrixUtil.buffer);
        GlStateManager.func_179109_b((float)(bone.rotationPointX / 16.0f), (float)(bone.rotationPointY / 16.0f), (float)(bone.rotationPointZ / 16.0f));
    }

    @Nullable
    protected abstract ItemStack getHeldItemForBone(String var1, T var2);

    protected abstract ItemCameraTransforms.TransformType getCameraTransformForItemAtBone(ItemStack var1, String var2);

    @Nullable
    protected abstract IBlockState getHeldBlockForBone(String var1, T var2);

    protected abstract void preRenderItem(ItemStack var1, String var2, T var3);

    protected abstract void preRenderBlock(IBlockState var1, String var2, T var3);

    protected abstract void postRenderItem(ItemStack var1, String var2, T var3);

    protected abstract void postRenderBlock(IBlockState var1, String var2, T var3);

    @Nullable
    protected abstract ResourceLocation getTextureForBone(String var1, T var2);
}

