/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.command;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.apache.commons.io.FileUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.tileentity.TileEntityExporter;
import team.cqr.cqrepoured.world.structure.generation.DungeonDataManager;
import team.cqr.cqrepoured.world.structure.generation.generation.DungeonGenerationManager;
import team.cqr.cqrepoured.world.structure.generation.generation.GeneratableDungeon;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.world.structure.generation.structurefile.CQStructure;
import team.cqr.cqrepoured.world.structure.generation.structurefile.Offset;

public class CommandImport
extends CommandBase {
    public String func_71517_b() {
        return "cqr_import_all";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/cqr_import_all";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        boolean importMode = CQRConfig.advanced.structureImportMode;
        CQRConfig.advanced.structureImportMode = true;
        try {
            ArrayList allFiles = new ArrayList();
            HashMap dir2file = new HashMap();
            try (Stream<Path> stream = Files.list(CQRMain.CQ_STRUCTURE_FILES_FOLDER.toPath());){
                stream.map(Path::toFile).filter(File::isDirectory).forEach(dir -> {
                    for (File f : FileUtils.listFiles((File)dir, (String[])new String[]{"nbt"}, (boolean)true)) {
                        if (allFiles.stream().anyMatch(f1 -> f1.getName().equals(f.getName()) && f1.length() == f.length())) {
                            CQRMain.logger.info("Duplicate: {}", (Object)f);
                            continue;
                        }
                        allFiles.add(f);
                        dir2file.computeIfAbsent(dir, k -> new ArrayList()).add(f);
                    }
                });
            }
            World world = sender.func_130014_f_();
            BlockPos pos = sender.func_180425_c();
            int z = 0;
            for (Map.Entry e : dir2file.entrySet()) {
                int maxSizeZ = 0;
                int x = 0;
                for (File f : (List)e.getValue()) {
                    if (x >= 1024) {
                        z += maxSizeZ + 10;
                        maxSizeZ = 0;
                        x = 0;
                    }
                    CQStructure structure = CQStructure.createFromFile(f);
                    BlockPos pos1 = pos.func_177982_a(x, 0, z);
                    GeneratableDungeon.Builder builder = new GeneratableDungeon.Builder(world, pos1.func_177982_a(2, 0, 2), "Import-" + f.getName(), DungeonInhabitantManager.DEFAULT_DUNGEON_INHABITANT.getName());
                    structure.addAll(builder, pos1.func_177982_a(2, 0, 2), Offset.NORTH_EAST);
                    GeneratableDungeon dungeon = builder.build(world);
                    DungeonGenerationManager.generateNow(world, dungeon, null, DungeonDataManager.DungeonSpawnType.DUNGEON_PLACER_ITEM);
                    world.func_175656_a(pos1, CQRBlocks.EXPORTER.func_176223_P());
                    TileEntityExporter exporter = (TileEntityExporter)world.func_175625_s(pos1);
                    String s1 = CQRMain.CQ_STRUCTURE_FILES_FOLDER.getAbsolutePath();
                    String s2 = f.getAbsolutePath();
                    String s3 = s2.substring(s1.length() + 1, s2.lastIndexOf(46));
                    BlockPos[] unprot = structure.getUnprotectedBlockList().toArray(new BlockPos[0]);
                    exporter.setValues(s3, new BlockPos(2, 0, 2), new BlockPos(1, -1, 1).func_177971_a((Vec3i)structure.getSize()), true, true, unprot);
                    maxSizeZ = Math.max(structure.getSize().func_177952_p(), maxSizeZ);
                    x += structure.getSize().func_177958_n() + 10;
                }
                z += maxSizeZ + 30;
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("Imported " + allFiles.size() + " structures successfully"));
        }
        catch (Exception e) {
            CQRMain.logger.error("Failed importing structures!", (Throwable)e);
            throw new CommandException("Failed importing structures: %s", new Object[]{e});
        }
        finally {
            CQRConfig.advanced.structureImportMode = importMode;
        }
    }
}

