/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.world.structure.generation.DungeonRegistry;
import team.cqr.cqrepoured.world.structure.generation.WorldDungeonGenerator;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonBase;

public class CommandLocateDungeon
extends CommandBase {
    public String func_71517_b() {
        return "cqr_locate_dungeon";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/cqr_locate_dungeon x z chunkRadius [generatedDungeon] [notGeneratedDungeon] [dungeonName]";
    }

    public int func_82362_a() {
        return 4;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String dungeonToSearchFor;
        if (args.length < 3) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        World world = sender.func_130014_f_();
        int x = MathHelper.func_76128_c((double)CommandLocateDungeon.func_175761_b((double)sender.func_174793_f().field_70165_t, (String)args[0], (boolean)false));
        int z = MathHelper.func_76128_c((double)CommandLocateDungeon.func_175761_b((double)sender.func_174793_f().field_70161_v, (String)args[1], (boolean)false));
        int chunkRadius = CommandLocateDungeon.func_175764_a((String)args[2], (int)0, (int)65536);
        boolean searchForGeneratedDungeon = args.length < 4 || CommandLocateDungeon.func_180527_d((String)args[3]);
        boolean searchForNotGeneratedDungeon = args.length < 5 || CommandLocateDungeon.func_180527_d((String)args[4]);
        String string = dungeonToSearchFor = args.length >= 6 ? args[5] : null;
        if (!world.func_72912_H().func_76089_r()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Structures are disabled."));
            return;
        }
        if (world.func_175624_G() == WorldType.field_77138_c && !CQRConfig.general.dungeonsInFlat) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Flat world and dungeonsInFlat is disabled."));
            return;
        }
        DungeonGenInfo dungeonGenInfo = CommandLocateDungeon.getNearestDungeon(world, x >> 4, z >> 4, chunkRadius, dungeonToSearchFor, searchForGeneratedDungeon, searchForNotGeneratedDungeon);
        if (dungeonGenInfo != null) {
            int dungeonX = (dungeonGenInfo.chunkX << 4) + 8;
            int dungeonZ = (dungeonGenInfo.chunkZ << 4) + 8;
            String s = String.format("Nearest dungeon: %s at x=%d z=%d", dungeonGenInfo.dungeonName, dungeonX, dungeonZ);
            sender.func_145747_a((ITextComponent)new TextComponentString(s));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("No dungeon found."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static DungeonGenInfo getNearestDungeon(World world, int chunkX, int chunkZ, int chunkRadius, @Nullable String dungeonToSearchFor, boolean searchForGeneratedDungeon, boolean searchForNotGeneratedDungeon) {
        if (!searchForGeneratedDungeon && !searchForNotGeneratedDungeon) {
            return null;
        }
        if (!world.func_72912_H().func_76089_r()) {
            return null;
        }
        if (world.func_175624_G() == WorldType.field_77138_c && !CQRConfig.general.dungeonsInFlat) {
            return null;
        }
        int dim = world.field_73011_w.getDimension();
        DungeonRegistry registry = DungeonRegistry.getInstance();
        if (registry.getDungeons().stream().noneMatch(dungeon -> dungeon.canSpawnInDim(dim) && dungeon.getDungeonName().equals(dungeonToSearchFor))) {
            return null;
        }
        boolean temp = CQRConfig.advanced.debugDungeonGen;
        CQRConfig.advanced.debugDungeonGen = false;
        try {
            for (int r = 0; r <= chunkRadius; ++r) {
                int startX = chunkX - r;
                int endX = chunkX + r;
                int startZ = chunkZ - r;
                int endZ = chunkZ + r;
                for (int x = startX; x <= endX; ++x) {
                    boolean flag = x != startX && x != endX;
                    for (int z = startZ; z <= endZ; ++z) {
                        DungeonBase dungeon2;
                        if (flag && z != startZ && z != endZ || (dungeon2 = WorldDungeonGenerator.getDungeonAt(world, x, z)) == null || dungeonToSearchFor != null && !dungeon2.getDungeonName().equalsIgnoreCase(dungeonToSearchFor)) continue;
                        DungeonGenInfo dungeonGenInfo = new DungeonGenInfo(dungeon2.getDungeonName(), x, z);
                        return dungeonGenInfo;
                    }
                }
            }
        }
        finally {
            CQRConfig.advanced.debugDungeonGen = temp;
        }
        return null;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length >= 1 && args.length <= 2) {
            return CommandLocateDungeon.func_181043_b((String[])args, (int)0, (BlockPos)targetPos);
        }
        if (args.length == 3) {
            return args[2].isEmpty() ? Arrays.asList("64") : Collections.emptyList();
        }
        if (args.length == 4) {
            return CommandLocateDungeon.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
        }
        if (args.length == 5) {
            return CommandLocateDungeon.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
        }
        if (args.length == 6) {
            DungeonRegistry dungeonRegistry = DungeonRegistry.getInstance();
            int dim = sender.func_130014_f_().field_73011_w.getDimension();
            return CommandLocateDungeon.func_71530_a((String[])args, (String[])((String[])dungeonRegistry.getDungeons().stream().filter(dungeon -> dungeon.canSpawnInDim(dim)).map(DungeonBase::getDungeonName).toArray(String[]::new)));
        }
        return Collections.emptyList();
    }

    public static class DungeonGenInfo {
        public final String dungeonName;
        public final int chunkX;
        public final int chunkZ;

        public DungeonGenInfo(String dungeonName, int chunkX, int chunkZ) {
            this.dungeonName = dungeonName;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
        }
    }
}

