/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Iterator;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.profiler.Profiler;
import net.minecraft.world.World;
import team.cqr.cqrepoured.CQRMain;

public class EntityAITasksProfiled
extends EntityAITasks {
    private final Profiler profiler;
    private int tickCount;
    private int tickRate = 3;
    private static final Object2LongMap<Class<? extends EntityAIBase>> AI_TIMES = new Object2LongOpenHashMap();
    private static long lastTimeLogged = 0L;
    private final World world;

    public EntityAITasksProfiled(Profiler profilerIn, World world) {
        super(profilerIn);
        this.profiler = profilerIn;
        this.world = world;
    }

    public void func_75774_a() {
        long t;
        this.profiler.func_76320_a("goalSetup");
        if (this.tickCount++ % this.tickRate == 0) {
            for (EntityAITasks.EntityAITaskEntry entityaitasks$entityaitaskentry : this.field_75782_a) {
                t = System.nanoTime();
                if (entityaitasks$entityaitaskentry.field_188524_c) {
                    if (!this.canUseCQR(entityaitasks$entityaitaskentry) || !this.canContinueCQR(entityaitasks$entityaitaskentry)) {
                        entityaitasks$entityaitaskentry.field_188524_c = false;
                        entityaitasks$entityaitaskentry.field_75733_a.func_75251_c();
                        this.field_75780_b.remove(entityaitasks$entityaitaskentry);
                    }
                } else if (this.canUseCQR(entityaitasks$entityaitaskentry) && entityaitasks$entityaitaskentry.field_75733_a.func_75250_a()) {
                    entityaitasks$entityaitaskentry.field_188524_c = true;
                    entityaitasks$entityaitaskentry.field_75733_a.func_75249_e();
                    this.field_75780_b.add(entityaitasks$entityaitaskentry);
                }
                t = System.nanoTime() - t;
                AI_TIMES.put(entityaitasks$entityaitaskentry.field_75733_a.getClass(), t += AI_TIMES.getLong(entityaitasks$entityaitaskentry.field_75733_a.getClass()));
            }
        } else {
            Iterator iterator = this.field_75780_b.iterator();
            while (iterator.hasNext()) {
                EntityAITasks.EntityAITaskEntry entityaitasks$entityaitaskentry1 = (EntityAITasks.EntityAITaskEntry)iterator.next();
                t = System.nanoTime();
                if (!this.canContinueCQR(entityaitasks$entityaitaskentry1)) {
                    entityaitasks$entityaitaskentry1.field_188524_c = false;
                    entityaitasks$entityaitaskentry1.field_75733_a.func_75251_c();
                    iterator.remove();
                }
                t = System.nanoTime() - t;
                AI_TIMES.put(entityaitasks$entityaitaskentry1.field_75733_a.getClass(), t += AI_TIMES.getLong(entityaitasks$entityaitaskentry1.field_75733_a.getClass()));
            }
        }
        this.profiler.func_76319_b();
        if (!this.field_75780_b.isEmpty()) {
            this.profiler.func_76320_a("goalTick");
            for (EntityAITasks.EntityAITaskEntry entityaitasks$entityaitaskentry2 : this.field_75780_b) {
                t = System.nanoTime();
                entityaitasks$entityaitaskentry2.field_75733_a.func_75246_d();
                t = System.nanoTime() - t;
                AI_TIMES.put(entityaitasks$entityaitaskentry2.field_75733_a.getClass(), t += AI_TIMES.getLong(entityaitasks$entityaitaskentry2.field_75733_a.getClass()));
            }
            this.profiler.func_76319_b();
        }
        if (this.world.func_82737_E() - lastTimeLogged > 200L) {
            lastTimeLogged = this.world.func_82737_E();
            StringBuilder sb = new StringBuilder("AI Times: \n");
            for (Object2LongMap.Entry entry : AI_TIMES.object2LongEntrySet()) {
                String s = ((Class)entry.getKey()).getSimpleName();
                sb.append(s);
                sb.append(':');
                sb.append(' ');
                for (int j = 40; s.length() < j; --j) {
                    sb.append(' ');
                }
                double d = (double)entry.getLongValue() / 1000000.0;
                for (int i = 10; i <= 10000; i *= 10) {
                    if (!(d < (double)i)) continue;
                    sb.append(' ');
                }
                sb.append(String.format("%.4f", d));
                sb.append('m');
                sb.append('s');
                sb.append('\n');
                entry.setValue(0L);
            }
            CQRMain.logger.info((CharSequence)sb);
        }
    }

    private boolean canContinueCQR(EntityAITasks.EntityAITaskEntry taskEntry) {
        return taskEntry.field_75733_a.func_75253_b();
    }

    private boolean canUseCQR(EntityAITasks.EntityAITaskEntry taskEntry) {
        if (this.field_75780_b.isEmpty()) {
            return true;
        }
        if (this.func_188528_b(taskEntry.field_75733_a.func_75247_h())) {
            return false;
        }
        for (EntityAITasks.EntityAITaskEntry entityaitasks$entityaitaskentry : this.field_75780_b) {
            if (entityaitasks$entityaitaskentry == taskEntry || !(taskEntry.field_75731_b >= entityaitasks$entityaitaskentry.field_75731_b ? !this.areTasksCompatibleCQR(taskEntry, entityaitasks$entityaitaskentry) : !entityaitasks$entityaitaskentry.field_75733_a.func_75252_g())) continue;
            return false;
        }
        return true;
    }

    private boolean areTasksCompatibleCQR(EntityAITasks.EntityAITaskEntry taskEntry1, EntityAITasks.EntityAITaskEntry taskEntry2) {
        return (taskEntry1.field_75733_a.func_75247_h() & taskEntry2.field_75733_a.func_75247_h()) == 0;
    }
}

