/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai;

import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import team.cqr.cqrepoured.block.BlockUnlitTorch;
import team.cqr.cqrepoured.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.util.BlockPosUtil;

public class EntityAITorchIgniter
extends AbstractCQREntityAI<AbstractEntityCQR> {
    private static final int SEARCH_RADIUS_HORIZONTAL = 16;
    private static final int SEARCH_RADIUS_VERTICAL = 2;
    private static final double REACH_DISTANCE_SQ = 9.0;
    private BlockPos nearestTorch = null;
    private int lastTickStarted = Integer.MIN_VALUE;

    public EntityAITorchIgniter(AbstractEntityCQR entity) {
        super(entity);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!this.entity.canIgniteTorch()) {
            return false;
        }
        if (!this.isFlintNSteel(this.entity.func_184614_ca()) && !this.isFlintNSteel(this.entity.func_184592_cb())) {
            return false;
        }
        if (this.random.nextInt(this.lastTickStarted + 60 >= this.entity.field_70173_aa ? 5 : 20) == 0) {
            BlockPos pos = new BlockPos((Entity)this.entity);
            Vec3d vec = this.entity.func_174824_e(1.0f);
            this.nearestTorch = BlockPosUtil.getNearest(this.world, pos.func_177958_n(), pos.func_177956_o() + (MathHelper.func_76123_f((float)this.entity.field_70131_O) >> 1), pos.func_177952_p(), 16, 2, true, true, (Block)CQRBlocks.UNLIT_TORCH, (mutablePos, state) -> {
                RayTraceResult result = this.world.func_147447_a(vec, new Vec3d((double)mutablePos.func_177958_n() + 0.5, (double)mutablePos.func_177956_o() + 0.5, (double)mutablePos.func_177952_p() + 0.5), false, true, false);
                return result == null || result.func_178782_a().equals((Object)mutablePos);
            });
        }
        return this.nearestTorch != null;
    }

    private boolean isFlintNSteel(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == Items.field_151033_d;
    }

    public boolean func_75253_b() {
        if (!this.isFlintNSteel(this.entity.func_184614_ca()) && !this.isFlintNSteel(this.entity.func_184592_cb())) {
            return false;
        }
        if (this.nearestTorch == null) {
            return false;
        }
        if (this.entity.field_70173_aa % 10 == 0 && this.entity.field_70170_p.func_180495_p(this.nearestTorch).func_177230_c() != CQRBlocks.UNLIT_TORCH) {
            return false;
        }
        return this.entity.func_70781_l();
    }

    public void func_75249_e() {
        if (this.entity.func_174831_c(this.nearestTorch) > 9.0) {
            this.entity.func_70661_as().func_75492_a((double)this.nearestTorch.func_177958_n(), (double)this.nearestTorch.func_177956_o(), (double)this.nearestTorch.func_177952_p(), 1.0);
        }
    }

    public void func_75251_c() {
        this.nearestTorch = null;
        this.entity.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        if (this.entity.func_174831_c(this.nearestTorch) <= 9.0) {
            IBlockState state = this.entity.field_70170_p.func_180495_p(this.nearestTorch);
            if (state.func_177230_c() == CQRBlocks.UNLIT_TORCH) {
                BlockUnlitTorch.lightUp(this.entity.field_70170_p, this.nearestTorch, (EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a));
            }
            this.nearestTorch = null;
        }
    }
}

