/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.attack.special;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.item.armor.ItemBackpack;
import team.cqr.cqrepoured.util.BlockPosUtil;

public class EntityAILooter
extends AbstractCQREntityAI<AbstractEntityCQR> {
    protected Set<BlockPos> visitedChests = new HashSet<BlockPos>();
    protected BlockPos currentTarget = null;
    protected int currentLootingTime = 0;
    protected final int LOOTING_DURATION = 100;
    protected int cooldown = 100;
    protected final int MAX_COOLDOWN = 100;
    protected final double REQUIRED_DISTANCE_TO_LOOT = 4.0;

    public EntityAILooter(AbstractEntityCQR entity) {
        super(entity);
        this.func_75248_a(2);
    }

    public boolean func_75250_a() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.cooldown > 0) {
            return false;
        }
        if (this.random.nextInt(20) == 0) {
            if (!this.hasBackpack((EntityLiving)this.entity)) {
                return false;
            }
            if (!this.hasBackpackSpace()) {
                return false;
            }
            BlockPos pos = new BlockPos((Entity)this.entity);
            Vec3d vec = this.entity.func_174824_e(1.0f);
            int horizontalRadius = CQRConfig.mobs.looterAIChestSearchRange;
            int verticalRadius = horizontalRadius >> 1;
            this.currentTarget = BlockPosUtil.getNearest(this.world, pos.func_177958_n(), pos.func_177956_o() + (MathHelper.func_76123_f((float)this.entity.field_70131_O) >> 1), pos.func_177952_p(), horizontalRadius, verticalRadius, true, true, (Block)Blocks.field_150486_ae, (mutablePos, state) -> {
                if (this.visitedChests.contains(mutablePos)) {
                    return false;
                }
                TileEntity te = this.world.func_175625_s((BlockPos)mutablePos);
                if (!(te instanceof TileEntityChest) || ((TileEntityChest)te).func_191420_l()) {
                    return false;
                }
                RayTraceResult result = this.world.func_147447_a(vec, new Vec3d((double)mutablePos.func_177958_n() + 0.5, (double)mutablePos.func_177956_o() + 0.5, (double)mutablePos.func_177952_p() + 0.5), false, true, false);
                return result == null || result.func_178782_a().equals((Object)mutablePos);
            });
        }
        return this.currentTarget != null;
    }

    private boolean hasBackpackSpace() {
        ItemStack backpack = this.entity.func_184582_a(EntityEquipmentSlot.CHEST);
        IItemHandler inventory = (IItemHandler)backpack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (inventory != null) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (!inventory.getStackInSlot(i).func_190926_b()) continue;
                return true;
            }
        }
        return false;
    }

    public void func_75249_e() {
        super.func_75249_e();
        ((Object)((Object)this)).getClass();
        this.currentLootingTime = 100;
        this.entity.func_70661_as().func_75492_a((double)this.currentTarget.func_177958_n(), (double)this.currentTarget.func_177956_o(), (double)this.currentTarget.func_177952_p(), 1.125);
    }

    public boolean func_75253_b() {
        return super.func_75253_b() && this.isChestStillThere() && this.hasBackpack((EntityLiving)this.entity) && this.hasBackpackSpace();
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.entity.func_70661_as().func_179680_a(this.currentTarget) == null) {
            this.visitedChests.add(this.currentTarget);
            this.currentTarget = null;
            return;
        }
        if (this.isInLootingRange()) {
            this.entity.func_70661_as().func_75499_g();
            TileEntityChest tile = (TileEntityChest)this.world.func_175625_s(this.currentTarget);
            if (this.currentLootingTime >= 0) {
                --this.currentLootingTime;
                ((Object)((Object)this)).getClass();
                if (this.currentLootingTime % (100 / CQRConfig.mobs.looterAIStealableItems) == 0) {
                    ItemStack stolenItem = null;
                    for (int i = 0; i < tile.func_70302_i_(); ++i) {
                        if (tile.func_70301_a(i).func_190926_b()) continue;
                        stolenItem = tile.func_70301_a(i).func_77946_l();
                        tile.func_70304_b(i);
                        break;
                    }
                    if (stolenItem != null) {
                        tile.func_70296_d();
                        this.entity.func_184609_a(EnumHand.MAIN_HAND);
                        this.entity.func_184609_a(EnumHand.OFF_HAND);
                        ItemStack backpack = this.entity.func_184582_a(EntityEquipmentSlot.CHEST);
                        IItemHandler inventory = (IItemHandler)backpack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                        if (inventory != null) {
                            for (int i = 0; i < inventory.getSlots(); ++i) {
                                if (!inventory.getStackInSlot(i).func_190926_b()) continue;
                                inventory.insertItem(i, stolenItem, false);
                                break;
                            }
                        }
                    }
                }
            } else {
                this.visitedChests.add(this.currentTarget);
            }
        } else {
            this.entity.func_70671_ap().func_75650_a((double)this.currentTarget.func_177958_n(), (double)this.currentTarget.func_177956_o(), (double)this.currentTarget.func_177952_p(), 30.0f, 30.0f);
            if (!this.entity.func_70781_l()) {
                this.entity.func_70661_as().func_75492_a((double)this.currentTarget.func_177958_n(), (double)this.currentTarget.func_177956_o(), (double)this.currentTarget.func_177952_p(), 1.125);
            }
        }
    }

    private boolean isInLootingRange() {
        return this.entity.func_174818_b(this.currentTarget) <= this.REQUIRED_DISTANCE_TO_LOOT;
    }

    protected boolean hasBackpack(EntityLiving living) {
        ItemStack chest = living.func_184582_a(EntityEquipmentSlot.CHEST);
        return chest != null && chest.func_77973_b() instanceof ItemBackpack;
    }

    protected boolean isChestStillThere() {
        if (this.currentTarget == null) {
            return false;
        }
        if (this.visitedChests.contains(this.currentTarget)) {
            return false;
        }
        TileEntity tile = this.world.func_175625_s(this.currentTarget);
        return tile != null && tile instanceof TileEntityChest && !((TileEntityChest)tile).func_191420_l();
    }
}

