/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.boss.spectrelord;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.entity.ai.spells.AbstractEntityAISpell;
import team.cqr.cqrepoured.entity.ai.spells.IEntityAISpellAnimatedVanilla;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.entity.boss.spectrelord.EntityCQRSpectreLord;
import team.cqr.cqrepoured.faction.Faction;
import team.cqr.cqrepoured.network.server.packet.SPacketUpdateEntityPrevPos;
import team.cqr.cqrepoured.util.math.BoundingBox;

public class EntityAISpectreLordDash
extends AbstractEntityAISpell<EntityCQRSpectreLord>
implements IEntityAISpellAnimatedVanilla {
    private final double dashSpeed;
    private final double dashWidth;
    private EntityLivingBase target;
    private Vec3d targetDirection;
    private double yawRadian;
    private float yawDegree;

    public EntityAISpectreLordDash(EntityCQRSpectreLord entity, int cooldown, int chargeUpTicks, int dashTicks, double dashSpeed, double dashWidth) {
        super(entity, cooldown, chargeUpTicks, 60 + dashTicks);
        this.setup(true, false, false, false);
        this.dashSpeed = dashSpeed;
        this.dashWidth = dashWidth;
    }

    @Override
    public void resetTask() {
        super.resetTask();
        this.target = null;
    }

    @Override
    public void startChargingSpell() {
        super.startChargingSpell();
        Faction faction = ((EntityCQRSpectreLord)this.entity).getFaction();
        if (faction == null) {
            this.target = ((EntityCQRSpectreLord)this.entity).func_70638_az();
        } else {
            AxisAlignedBB aabb = new AxisAlignedBB(((EntityCQRSpectreLord)this.entity).field_70165_t - 16.0, ((EntityCQRSpectreLord)this.entity).field_70163_u - 2.0, ((EntityCQRSpectreLord)this.entity).field_70161_v - 16.0, ((EntityCQRSpectreLord)this.entity).field_70165_t + 16.0, ((EntityCQRSpectreLord)this.entity).field_70163_u + (double)((EntityCQRSpectreLord)this.entity).field_70131_O + 2.0, ((EntityCQRSpectreLord)this.entity).field_70161_v + 16.0);
            List list = this.world.func_175647_a(EntityLivingBase.class, aabb, e -> TargetUtil.PREDICATE_ATTACK_TARGET.apply(e) && faction.isEnemy((Entity)e));
            if (list.isEmpty()) {
                this.target = ((EntityCQRSpectreLord)this.entity).func_70638_az();
            } else {
                this.target = (EntityLivingBase)list.get(this.random.nextInt(list.size()));
                ((EntityCQRSpectreLord)this.entity).func_70624_b(this.target);
            }
        }
    }

    @Override
    public void startCastingSpell() {
        super.startCastingSpell();
        ((EntityCQRSpectreLord)this.entity).setInvisibility(25);
    }

    @Override
    public void castSpell() {
        if (this.tick == this.chargingTicks + 20 - 1) {
            double oldX = ((EntityCQRSpectreLord)this.entity).field_70165_t;
            double oldY = ((EntityCQRSpectreLord)this.entity).field_70163_u;
            double oldZ = ((EntityCQRSpectreLord)this.entity).field_70161_v;
            this.teleportBehindTarget();
            double dx = this.target.field_70165_t - ((EntityCQRSpectreLord)this.entity).field_70165_t;
            double dz = this.target.field_70161_v - ((EntityCQRSpectreLord)this.entity).field_70161_v;
            double dist = Math.sqrt(dx * dx + dz * dz);
            this.targetDirection = new Vec3d(dx / dist * this.dashSpeed, 0.0, dz / dist * this.dashSpeed);
            this.yawRadian = Math.atan2(-dx, dz);
            ((EntityCQRSpectreLord)this.entity).field_70177_z = this.yawDegree = (float)Math.toDegrees(this.yawRadian);
            CQRMain.NETWORK.sendToAllTracking((IMessage)new SPacketUpdateEntityPrevPos((Entity)this.entity), (Entity)this.entity);
            ((EntityCQRSpectreLord)this.entity).func_184185_a(SoundEvents.field_191249_bs, 1.0f, 0.9f + this.random.nextFloat() * 0.2f);
            ((WorldServer)this.world).func_175739_a(EnumParticleTypes.PORTAL, oldX, oldY + (double)((EntityCQRSpectreLord)this.entity).field_70131_O * 0.5, oldZ, 4, 0.2, 0.2, 0.2, 0.0, new int[0]);
            ((WorldServer)this.world).func_175739_a(EnumParticleTypes.PORTAL, ((EntityCQRSpectreLord)this.entity).field_70165_t, ((EntityCQRSpectreLord)this.entity).field_70163_u + (double)((EntityCQRSpectreLord)this.entity).field_70131_O * 0.5, ((EntityCQRSpectreLord)this.entity).field_70161_v, 4, 0.2, 0.2, 0.2, 0.0, new int[0]);
        } else if (this.tick > this.chargingTicks + 20 - 1) {
            ((EntityCQRSpectreLord)this.entity).field_70177_z = this.yawDegree;
            if (this.tick > this.chargingTicks + 60 - 1) {
                this.dashToTarget();
            }
        }
    }

    private void teleportBehindTarget() {
        Vec3d end;
        double dx = this.target.field_70165_t - ((EntityCQRSpectreLord)this.entity).field_70165_t;
        double dz = this.target.field_70161_v - ((EntityCQRSpectreLord)this.entity).field_70161_v;
        double dist = Math.sqrt(dx * dx + dz * dz);
        Vec3d start = this.target.func_174791_d();
        RayTraceResult result = this.world.func_147447_a(start, end = start.func_72441_c(dx / dist * 3.0, 0.0, dz / dist * 3.0), false, true, false);
        Vec3d vec = TargetUtil.getPositionNearTarget(this.world, (EntityLiving)this.entity, result != null ? result.field_72307_f : end, start, 2.0, 4.0, 1.0);
        if (vec != null) {
            ((EntityCQRSpectreLord)this.entity).func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        }
    }

    private void dashToTarget() {
        Vec3d end;
        Vec3d start;
        Vec3d vec1 = ((EntityCQRSpectreLord)this.entity).func_174791_d();
        boolean noClip = ((EntityCQRSpectreLord)this.entity).field_70145_X;
        if (!noClip && this.world.func_147447_a(start = new Vec3d(((EntityCQRSpectreLord)this.entity).field_70165_t, ((EntityCQRSpectreLord)this.entity).field_70163_u + (double)((EntityCQRSpectreLord)this.entity).func_70047_e(), ((EntityCQRSpectreLord)this.entity).field_70161_v), end = start.func_178787_e(this.targetDirection), false, true, false) == null && !this.world.func_184143_b(((EntityCQRSpectreLord)this.entity).func_174813_aQ().func_191194_a(this.targetDirection))) {
            ((EntityCQRSpectreLord)this.entity).field_70145_X = true;
        }
        ((EntityCQRSpectreLord)this.entity).func_70091_d(MoverType.SELF, this.targetDirection.field_72450_a, this.targetDirection.field_72448_b, this.targetDirection.field_72449_c);
        ((EntityCQRSpectreLord)this.entity).field_70145_X = noClip;
        Vec3d vec2 = ((EntityCQRSpectreLord)this.entity).func_174791_d();
        Vec3d vec3 = new Vec3d(-this.dashWidth, 0.0, 0.0);
        Vec3d vec4 = new Vec3d(this.dashWidth, (double)((EntityCQRSpectreLord)this.entity).field_70131_O, vec2.func_178788_d(vec1).func_72433_c());
        BoundingBox bb = new BoundingBox(vec3, vec4, this.yawRadian, 0.0, vec1);
        List<EntityLivingBase> list = BoundingBox.getEntitiesInsideBB(this.world, this.entity, EntityLivingBase.class, bb);
        Faction faction = ((EntityCQRSpectreLord)this.entity).getFaction();
        for (EntityLivingBase entity : list) {
            if (!TargetUtil.PREDICATE_ATTACK_TARGET.apply((Object)entity) || faction != null && faction.isAlly((Entity)entity)) continue;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.entity).func_76348_h(), 10.0f);
        }
    }

    @Override
    protected SoundEvent getStartChargingSound() {
        return SoundEvents.field_191247_bq;
    }

    @Override
    public int getWeight() {
        return 10;
    }

    @Override
    public boolean ignoreWeight() {
        return false;
    }

    @Override
    public float getRed() {
        return 0.2f;
    }

    @Override
    public float getGreen() {
        return 0.1f;
    }

    @Override
    public float getBlue() {
        return 0.6f;
    }
}

