/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.item;

import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemLingeringPotion;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.ai.attack.EntityAIAttackRanged;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.item.ItemAlchemyBag;

public class EntityAIPotionThrower
extends EntityAIAttackRanged<AbstractEntityCQR> {
    public EntityAIPotionThrower(AbstractEntityCQR entity) {
        super(entity);
    }

    @Override
    protected ItemStack getEquippedWeapon() {
        return this.entity.func_184592_cb();
    }

    @Override
    protected boolean isRangedWeapon(Item item) {
        return item instanceof ItemAlchemyBag || item instanceof ItemSplashPotion || item instanceof ItemLingeringPotion;
    }

    @Override
    protected void checkAndPerformAttack(EntityLivingBase attackTarget) {
        if (this.entity.field_70173_aa > this.prevTimeAttacked + this.getAttackCooldown()) {
            ItemStack stack = this.getEquippedWeapon();
            Item item = stack.func_77973_b();
            if (item instanceof ItemSplashPotion || item instanceof ItemLingeringPotion) {
                EntityPotion proj = new EntityPotion(this.world, (EntityLivingBase)this.entity, stack.func_77946_l());
                double x = attackTarget.field_70165_t - this.entity.field_70165_t;
                double y = attackTarget.field_70163_u + (double)attackTarget.field_70131_O * 0.5 - proj.field_70163_u;
                double z = attackTarget.field_70161_v - this.entity.field_70161_v;
                double distance = Math.sqrt(x * x + z * z);
                proj.func_70186_c(x, y + distance * 0.06, z, 1.0f, this.entity.func_70681_au().nextFloat() * 0.25f);
                proj.field_70159_w += this.entity.field_70159_w;
                proj.field_70179_y += this.entity.field_70179_y;
                if (!this.entity.field_70122_E) {
                    proj.field_70181_x += this.entity.field_70181_x;
                }
                this.entity.field_70170_p.func_72838_d((Entity)proj);
                this.entity.func_184609_a(EnumHand.OFF_HAND);
                this.entity.func_184185_a(SoundEvents.field_187827_fP, 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
                if (CQRConfig.mobs.offhandPotionsAreSingleUse) {
                    stack.func_190918_g(1);
                }
                this.prevTimeAttacked = this.entity.field_70173_aa;
            } else if (item instanceof ItemAlchemyBag) {
                ItemStack potion;
                IItemHandler inventory = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                int indx = this.entity.func_70681_au().nextInt(inventory.getSlots());
                ItemStack st = inventory.getStackInSlot(indx);
                HashSet<Integer> usedIDs = new HashSet<Integer>();
                for (int counter = 0; st.func_190926_b() && !usedIDs.contains(indx) && counter > inventory.getSlots(); ++counter) {
                    indx = this.entity.func_70681_au().nextInt(inventory.getSlots());
                    usedIDs.add(indx);
                    st = inventory.getStackInSlot(indx);
                }
                if (!st.func_190926_b() && ((potion = st.func_77946_l()).func_77973_b() instanceof ItemSplashPotion || potion.func_77973_b() instanceof ItemLingeringPotion)) {
                    EntityPotion proj = new EntityPotion(this.world, (EntityLivingBase)this.entity, potion);
                    double x = attackTarget.field_70165_t - this.entity.field_70165_t;
                    double y = attackTarget.field_70163_u + (double)attackTarget.field_70131_O * 0.5 - proj.field_70163_u;
                    double z = attackTarget.field_70161_v - this.entity.field_70161_v;
                    double distance = Math.sqrt(x * x + z * z);
                    proj.func_70186_c(x, y + distance * 0.08, z, 1.0f, this.entity.func_70681_au().nextFloat() * 0.25f);
                    proj.field_70159_w += this.entity.field_70159_w;
                    proj.field_70179_y += this.entity.field_70179_y;
                    if (!this.entity.field_70122_E) {
                        proj.field_70181_x += this.entity.field_70181_x;
                    }
                    proj.field_70133_I = true;
                    this.entity.field_70170_p.func_72838_d((Entity)proj);
                    this.entity.func_184609_a(EnumHand.OFF_HAND);
                    this.entity.func_184185_a(SoundEvents.field_187827_fP, 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
                }
                this.prevTimeAttacked = this.entity.field_70173_aa;
            }
        }
    }

    @Override
    protected int getAttackCooldown() {
        switch (this.world.func_175659_aa()) {
            case HARD: {
                return 20;
            }
            case NORMAL: {
                return 30;
            }
        }
        return 40;
    }

    @Override
    protected int getAttackChargeTicks() {
        return 0;
    }

    @Override
    protected boolean canStrafe() {
        return true;
    }

    @Override
    protected double getAttackRange() {
        return 12.0;
    }
}

