/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.spells;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import team.cqr.cqrepoured.entity.ai.spells.AbstractEntityAISpell;
import team.cqr.cqrepoured.entity.ai.spells.IEntityAISpellAnimatedVanilla;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.entity.bases.ISummoner;
import team.cqr.cqrepoured.entity.misc.EntitySummoningCircle;
import team.cqr.cqrepoured.util.VectorUtil;

public class EntityAISummonMinionSpell
extends AbstractEntityAISpell<AbstractEntityCQR>
implements IEntityAISpellAnimatedVanilla {
    protected ISummoner summoner = null;
    protected int MAX_MINIONS = 10;
    protected int MAX_MINIONS_AT_A_TIME = 3;
    protected List<Entity> activeCircles = new ArrayList<Entity>();
    protected boolean summonViaCircle = true;
    protected Vec3d positionOffsetForSummons = new Vec3d(0.0, 0.0, 0.0);
    protected ResourceLocation minionOverride = null;
    protected EntitySummoningCircle.ECircleTexture circleTextureOverride = null;

    public EntityAISummonMinionSpell(AbstractEntityCQR entity, int cooldown, int chargingTicks) {
        super(entity, cooldown, chargingTicks, 1);
        this.setup(true, true, true, false);
        if (entity instanceof ISummoner) {
            this.summoner = (ISummoner)((Object)entity);
        }
    }

    public EntityAISummonMinionSpell(AbstractEntityCQR entity, int cooldown, int chargeUpTicks, ResourceLocation minion, EntitySummoningCircle.ECircleTexture texture, boolean useCircle, int maxMinions, int maxMinionsPerSpawn, Vec3d offsetV) {
        this(entity, cooldown, chargeUpTicks);
        this.summonViaCircle = useCircle;
        this.minionOverride = minion;
        this.circleTextureOverride = texture;
        this.MAX_MINIONS = maxMinions;
        this.MAX_MINIONS_AT_A_TIME = maxMinionsPerSpawn;
        this.positionOffsetForSummons = offsetV;
    }

    @Override
    public boolean shouldExecute() {
        if (!super.shouldExecute()) {
            return false;
        }
        if (this.summoner == null) {
            return false;
        }
        return this.getAliveMinionCount() < this.MAX_MINIONS;
    }

    protected int getAliveMinionCount() {
        if (this.activeCircles.isEmpty() && this.summoner.getSummonedEntities().isEmpty()) {
            return 0;
        }
        int aliveMinions = 0;
        ArrayList<Entity> toRemove = new ArrayList<Entity>();
        for (Entity minio : this.activeCircles) {
            if (minio != null && !minio.field_70128_L) {
                ++aliveMinions;
                continue;
            }
            toRemove.add(minio);
        }
        for (Entity minio : this.summoner.getSummonedEntities()) {
            if (minio == null || minio.field_70128_L) continue;
            ++aliveMinions;
        }
        this.activeCircles.removeAll(toRemove);
        return aliveMinions;
    }

    @Override
    public void startCastingSpell() {
        Vec3d vector = this.entity.func_70040_Z().func_72432_b();
        vector = vector.func_178787_e(vector).func_178787_e(vector).func_178787_e(vector).func_178787_e(vector);
        int minionCount = this.MAX_MINIONS - this.getAliveMinionCount();
        if (minionCount > this.MAX_MINIONS_AT_A_TIME) {
            minionCount = this.MAX_MINIONS_AT_A_TIME;
        }
        if (minionCount > 0) {
            double angle = 360.0 / (double)minionCount;
            BlockPos[] spawnPositions = new BlockPos[minionCount];
            for (int i = 0; i < minionCount; ++i) {
                spawnPositions[i] = this.entity.func_180425_c().func_177971_a((Vec3i)new BlockPos(VectorUtil.rotateVectorAroundY(vector, angle * (double)i)));
            }
            for (BlockPos p : spawnPositions) {
                if (this.entity.func_70661_as().func_179680_a(p) == null) continue;
                ResourceLocation summon = null;
                boolean rdmFlag = false;
                if (this.minionOverride != null) {
                    summon = this.minionOverride;
                } else {
                    summon = new ResourceLocation("cqrepoured", "zombie");
                    if (this.entity.func_70681_au().nextInt(4) == 3) {
                        summon = new ResourceLocation("cqrepoured", "skeleton");
                        rdmFlag = true;
                    }
                }
                EntitySummoningCircle.ECircleTexture texture = null;
                if (this.circleTextureOverride != null) {
                    texture = this.circleTextureOverride;
                } else {
                    texture = EntitySummoningCircle.ECircleTexture.ZOMBIE;
                    if (rdmFlag) {
                        texture = EntitySummoningCircle.ECircleTexture.SKELETON;
                    }
                }
                if (this.entity.field_70170_p.func_180495_p(p).func_185913_b()) {
                    p = p.func_177982_a(0, 1, 0);
                }
                if (this.summonViaCircle) {
                    EntitySummoningCircle circle = new EntitySummoningCircle(this.entity.field_70170_p, summon, 1.1f, texture, (ISummoner)((Object)this.entity));
                    circle.setSummon(summon);
                    circle.func_70107_b((double)p.func_177958_n() + this.positionOffsetForSummons.field_72450_a, (double)p.func_177956_o() + 0.1 + this.positionOffsetForSummons.field_72448_b, (double)p.func_177952_p() + this.positionOffsetForSummons.field_72449_c);
                    this.entity.field_70170_p.func_72838_d((Entity)circle);
                    this.summoner.addSummonedEntityToList(circle);
                    this.activeCircles.add(circle);
                    continue;
                }
                Entity summoned = EntityList.func_188429_b((ResourceLocation)summon, (World)this.entity.field_70170_p);
                summoned.func_184221_a(MathHelper.func_188210_a());
                summoned.func_70107_b((double)p.func_177958_n() + this.positionOffsetForSummons.field_72450_a, (double)p.func_177956_o() + 0.5 + this.positionOffsetForSummons.field_72448_b, (double)p.func_177952_p() + this.positionOffsetForSummons.field_72449_c);
                this.entity.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, (double)p.func_177958_n(), (double)p.func_177956_o() + 0.02, (double)p.func_177952_p(), 0.0, 0.5, 0.0, new int[]{2});
                this.entity.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, (double)p.func_177958_n(), (double)p.func_177956_o() + 0.02, (double)p.func_177952_p(), 0.5, 0.0, 0.5, new int[]{1});
                this.entity.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, (double)p.func_177958_n(), (double)p.func_177956_o() + 0.02, (double)p.func_177952_p(), 0.5, 0.0, -0.5, new int[]{1});
                this.entity.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, (double)p.func_177958_n(), (double)p.func_177956_o() + 0.02, (double)p.func_177952_p(), -0.5, 0.0, 0.5, new int[]{1});
                this.entity.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, (double)p.func_177958_n(), (double)p.func_177956_o() + 0.02, (double)p.func_177952_p(), -0.5, 0.0, -0.5, new int[]{1});
                this.entity.field_70170_p.func_72838_d(summoned);
                if (this.summoner == null || this.summoner.getSummoner().field_70128_L) continue;
                this.summoner.setSummonedEntityFaction(summoned);
                this.summoner.tryEquipSummon(summoned, this.world.field_73012_v);
                this.summoner.addSummonedEntityToList(summoned);
            }
        }
    }

    @Override
    protected SoundEvent getStartChargingSound() {
        return SoundEvents.field_191247_bq;
    }

    @Override
    protected SoundEvent getStartCastingSound() {
        return SoundEvents.field_193784_dd;
    }

    @Override
    public int getWeight() {
        return 10;
    }

    @Override
    public boolean ignoreWeight() {
        return false;
    }

    @Override
    public float getRed() {
        return 0.7f;
    }

    @Override
    public float getGreen() {
        return 0.7f;
    }

    @Override
    public float getBlue() {
        return 0.8f;
    }
}

