/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.bases;

import com.github.alexthe666.iceandfire.entity.IBlacklistedFromStatues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;

public abstract class AbstractEntityCQRBoss
extends AbstractEntityCQR
implements IBlacklistedFromStatues {
    public static final int MAX_DEATH_TICKS = 200;

    protected AbstractEntityCQRBoss(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 50;
        this.enableBossBar();
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float amount, boolean sentFromPart) {
        int nearbyPlayerCount = 0;
        for (EntityPlayer player : this.field_70170_p.field_73010_i) {
            if (!(this.func_70068_e((Entity)player) < 10000.0)) continue;
            ++nearbyPlayerCount;
        }
        for (int i = 0; i < nearbyPlayerCount - 1; ++i) {
            amount = (float)((double)amount * (1.0 - CQRConfig.mobs.bossDamageReductionPerPlayer));
        }
        return super.attackEntityFrom(source, amount, sentFromPart);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_() && this.bossInfoServer != null) {
            this.bossInfoServer.func_186739_a(this.func_145748_c_());
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public void func_70636_d() {
        if (this.canHealWhenIdling() && CQRConfig.bosses.enableHealthRegen && !this.hasAttackTarget() && this.lastTickWithAttackTarget + 100 < this.field_70173_aa && this.field_70173_aa % 5 == 0) {
            this.func_70691_i(this.func_110138_aP() * 0.005f);
        }
        super.func_70636_d();
    }

    protected boolean canHealWhenIdling() {
        return true;
    }

    protected void func_70609_aI() {
        if (this.usesEnderDragonDeath()) {
            if (this.isSitting()) {
                this.setSitting(false);
            }
            ++this.field_70725_aQ;
            if (this.field_70725_aQ >= 180 && this.field_70725_aQ <= 200) {
                float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
                float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
                float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
                this.field_70170_p.func_175688_a(this.getDeathAnimParticles(), this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
            }
            this.func_189654_d(true);
            this.func_70091_d(MoverType.SELF, 0.0, 0.05, 0.0);
            if (this.field_70725_aQ == 200 && !this.field_70170_p.field_72995_K) {
                this.func_184185_a(this.getFinalDeathSound(), 10.0f, 1.0f);
                this.func_70106_y();
                if (this.doesExplodeOnDeath()) {
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 8.0f, true);
                }
                this.onFinalDeath();
            }
        } else {
            super.func_70609_aI();
        }
    }

    protected void onFinalDeath() {
    }

    protected SoundEvent getFinalDeathSound() {
        return this.func_184615_bR();
    }

    protected boolean doesExplodeOnDeath() {
        return false;
    }

    protected boolean usesEnderDragonDeath() {
        return false;
    }

    protected EnumParticleTypes getDeathAnimParticles() {
        return EnumParticleTypes.EXPLOSION_HUGE;
    }

    @Override
    public boolean canTameEntity() {
        return false;
    }

    @Override
    public boolean canMountEntity() {
        return false;
    }

    @Override
    protected boolean damageCapEnabled() {
        return CQRConfig.bossDamageCaps.enableDamageCapForBosses;
    }

    @Override
    protected float maxDamageInPercentOfMaxHP() {
        return CQRConfig.bossDamageCaps.maxDamageInPercentOfMaxHP;
    }

    @Override
    protected float maxUncappedDamage() {
        return CQRConfig.bossDamageCaps.maxUncappedDamage;
    }

    @Override
    public boolean canBeTurnedToStone() {
        return !CQRConfig.bosses.blackListBossesFromIaFGorgonHead;
    }

    protected void spawnDeathPoofParticles() {
        if (!(this.field_70170_p instanceof WorldServer)) {
            return;
        }
        int hbVolume = (int)(this.field_70130_N * this.field_70131_O * this.field_70130_N);
        hbVolume *= 4;
        for (int k = 0; k < hbVolume; ++k) {
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 1, d2, d0, d1, 0.05, new int[0]);
        }
    }
}

