/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.boss.endercalamity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.EntityEquipmentExtraSlot;
import team.cqr.cqrepoured.entity.ai.EntityAITeleportToTargetWhenStuck;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQRBoss;
import team.cqr.cqrepoured.entity.boss.endercalamity.EntityCalamitySpawner;
import team.cqr.cqrepoured.faction.EDefaultFaction;
import team.cqr.cqrepoured.init.CQRCreatureAttributes;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.item.armor.ItemArmorDyable;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.EntityUtil;
import team.cqr.cqrepoured.world.structure.protection.IProtectedRegionManager;
import team.cqr.cqrepoured.world.structure.protection.ProtectedRegionManager;
import team.cqr.cqrepoured.world.structure.protection.ServerProtectedRegionManager;

public class EntityCQREnderKing
extends AbstractEntityCQRBoss {
    protected static final DataParameter<Boolean> WIDE = EntityDataManager.func_187226_a(EntityCQREnderKing.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityCQREnderKing(World worldIn) {
        super(worldIn);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_70619_bc() {
        if (this.func_70090_H() || this.func_70026_G() && this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        super.func_70619_bc();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(3, new EntityAITeleportToTargetWhenStuck<EntityCQREnderKing>(this));
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        amount /= 2.0f;
        if (source instanceof EntityDamageSourceIndirect || source.func_76363_c()) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                if (source.func_76363_c()) {
                    return super.func_70097_a(source, amount);
                }
                return false;
            }
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WIDE, (Object)DungeonGenUtils.percentageRandom(0.05));
    }

    public ITextComponent func_145748_c_() {
        if (this.isWide()) {
            return new TextComponentString("Wide Enderman");
        }
        return super.func_145748_c_();
    }

    public boolean isWide() {
        return (Boolean)this.field_70180_af.func_187225_a(WIDE);
    }

    @Override
    protected boolean doesExplodeOnDeath() {
        return true;
    }

    @Override
    protected boolean usesEnderDragonDeath() {
        return false;
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        IProtectedRegionManager manager = ProtectedRegionManager.getInstance(this.field_70170_p);
        if (manager instanceof ServerProtectedRegionManager) {
            EntityCalamitySpawner cs = new EntityCalamitySpawner(this.field_70170_p);
            BlockPos pos = this.hasHomePositionCQR() ? this.getHomePositionCQR() : this.func_180425_c();
            cs.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            cs.setFaction(this.getFaction().getName());
            this.field_70170_p.func_72838_d((Entity)cs);
            EntityUtil.addEntityToAllRegionsAt(pos, cs);
        }
        super.func_70645_a(cause);
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    private boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (flag) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public float getBaseHealth() {
        return 2.0f * CQRConfig.baseHealths.Enderman;
    }

    @Override
    public EDefaultFaction getDefaultFaction() {
        return EDefaultFaction.ENDERMEN;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187529_aS;
    }

    @Override
    protected SoundEvent getDefaultHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.field_187531_aU;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187530_aT;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
    }

    @Override
    public boolean isSitting() {
        return false;
    }

    @Override
    public boolean canMountEntity() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.875f;
    }

    @Override
    public float getDefaultWidth() {
        return 0.6f;
    }

    @Override
    public float getDefaultHeight() {
        return 2.9f;
    }

    @Override
    public void teleport(double x, double y, double z) {
        this.teleportTo(x, y, z);
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        super.func_70636_d();
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.func_180481_a(difficulty);
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(CQRItems.GREAT_SWORD_DIAMOND));
        this.setItemStackToExtraSlot(EntityEquipmentExtraSlot.POTION, new ItemStack(CQRItems.POTION_HEALING, 3));
        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(CQRItems.KING_CROWN, 1));
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
        if (!nbttagcompound.func_150297_b("display", 10)) {
            nbttagcompound.func_74782_a("display", (NBTBase)nbttagcompound1);
        }
        nbttagcompound1.func_74768_a("color", 0x9000FF);
        ItemStack chest = new ItemStack(CQRItems.CHESTPLATE_DIAMOND_DYABLE, 1, 0, nbttagcompound);
        ((ItemArmorDyable)CQRItems.CHESTPLATE_DIAMOND_DYABLE).func_82813_b(chest, 0x9000FF);
        this.func_184201_a(EntityEquipmentSlot.CHEST, chest);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return CQRLoottables.ENTITIES_ENDERMAN;
    }

    protected float func_70599_aP() {
        return 2.0f * super.func_70599_aP();
    }

    protected float func_70647_i() {
        return 0.75f * super.func_70647_i();
    }

    public int func_70627_aG() {
        return 60;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return CQRCreatureAttributes.VOID;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("wide_enderman", this.isWide());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(WIDE, (Object)compound.func_74767_n("wide_enderman"));
    }
}

