/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.boss.spectrelord;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import team.cqr.cqrepoured.entity.ai.boss.spectrelord.EntityAISpectreLordChannelHate;
import team.cqr.cqrepoured.entity.ai.boss.spectrelord.EntityAISpectreLordDash;
import team.cqr.cqrepoured.entity.ai.boss.spectrelord.EntityAISpectreLordLaser;
import team.cqr.cqrepoured.entity.ai.boss.spectrelord.EntityAISpectreLordSummonIllusions;
import team.cqr.cqrepoured.entity.ai.boss.spectrelord.EntityAISpectreLordSwordShield;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQRBoss;
import team.cqr.cqrepoured.entity.bases.ISummoner;
import team.cqr.cqrepoured.faction.EDefaultFaction;
import team.cqr.cqrepoured.faction.Faction;
import team.cqr.cqrepoured.init.CQRLoottables;

public class EntityCQRSpectreLord
extends AbstractEntityCQRBoss
implements ISummoner {
    private static final DataParameter<Integer> SWORD_SHIELD_ACTIVE = EntityDataManager.func_187226_a(EntityCQRSpectreLord.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CHANNELING_LASER = EntityDataManager.func_187226_a(EntityCQRSpectreLord.class, (DataSerializer)DataSerializers.field_187198_h);
    private final List<Entity> summonedEntities = new ArrayList<Entity>();

    public EntityCQRSpectreLord(World world) {
        super(world);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return CQRLoottables.ENTITIES_SPECTRE_LORD;
    }

    @Override
    public float getBaseHealth() {
        return 200.0f;
    }

    @Override
    public EDefaultFaction getDefaultFaction() {
        return EDefaultFaction.UNDEAD;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWORD_SHIELD_ACTIVE, (Object)0);
        this.field_70180_af.func_187214_a(CHANNELING_LASER, (Object)false);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.spellHandler.addSpell(0, new EntityAISpectreLordChannelHate(this, 600, 60, 480));
        this.spellHandler.addSpell(1, new EntityAISpectreLordDash(this, 200, 40, 3, 3.0, 1.5));
        this.spellHandler.addSpell(2, new EntityAISpectreLordLaser(this, 600, 60, 320));
        this.spellHandler.addSpell(3, new EntityAISpectreLordSummonIllusions(this, 400, 40, 4, 800));
        this.spellHandler.addSpell(4, new EntityAISpectreLordSwordShield(this, 600, 60));
    }

    public void func_70030_z() {
        if (!this.field_70170_p.field_72995_K && this.field_70143_R > 3.0f) {
            Vec3d vec;
            this.field_70143_R = 0.0f;
            if (this.hasAttackTarget()) {
                vec = TargetUtil.getPositionNearTarget(this.field_70170_p, (EntityLiving)this, (Entity)this.func_70638_az(), 2.0, 8.0, 2.0);
                if (vec != null) {
                    this.teleport(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                }
            } else if (this.hasHomePositionCQR()) {
                BlockPos pos = this.getHomePositionCQR();
                this.teleport((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            } else {
                vec = TargetUtil.getPositionNearTarget(this.field_70170_p, (EntityLiving)this, (Entity)this, 0.0, 16.0, 8.0);
                if (vec != null) {
                    this.teleport(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                }
            }
        }
        super.func_70030_z();
        Iterator<Entity> iterator = this.summonedEntities.iterator();
        while (iterator.hasNext()) {
            Entity e = iterator.next();
            if (e.func_70089_S()) continue;
            iterator.remove();
        }
        if (!this.field_70170_p.field_72995_K && (Integer)this.field_70180_af.func_187225_a(SWORD_SHIELD_ACTIVE) > 0) {
            this.field_70180_af.func_187227_b(SWORD_SHIELD_ACTIVE, (Object)((Integer)this.field_70180_af.func_187225_a(SWORD_SHIELD_ACTIVE) - 1));
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.getInvisibility() == 1.0f) {
            return false;
        }
        if (this.isChannelingLaser()) {
            amount *= 2.0f;
        }
        if (this.isSwordShieldActive()) {
            if (source.func_76352_a()) {
                return false;
            }
            if (source.func_76364_f() != null) {
                boolean flag = super.func_70097_a(source, amount);
                if (flag) {
                    source.func_76364_f().func_70097_a(new DamageSource("thorns").func_76348_h(), amount * 0.25f);
                }
                return flag;
            }
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public float getInvisibility() {
        return ((Float)this.field_70180_af.func_187225_a(INVISIBILITY)).floatValue();
    }

    public void setSwordShieldActive(int ticks) {
        this.field_70180_af.func_187227_b(SWORD_SHIELD_ACTIVE, (Object)ticks);
    }

    public boolean isSwordShieldActive() {
        return (Integer)this.field_70180_af.func_187225_a(SWORD_SHIELD_ACTIVE) > 0;
    }

    public void setChannelingLaser(boolean channelingLaser) {
        this.field_70180_af.func_187227_b(CHANNELING_LASER, (Object)channelingLaser);
    }

    public boolean isChannelingLaser() {
        return (Boolean)this.field_70180_af.func_187225_a(CHANNELING_LASER);
    }

    @Override
    public void teleport(double x, double y, double z) {
        double oldX = this.field_70165_t;
        double oldY = this.field_70163_u;
        double oldZ = this.field_70161_v;
        super.teleport(x, y, z);
        this.func_184185_a(SoundEvents.field_187791_eX, 1.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
        ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.PORTAL, oldX, oldY + (double)this.field_70131_O * 0.5, oldZ, 4, 0.2, 0.2, 0.2, 0.0, new int[0]);
        ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.PORTAL, x, y + (double)this.field_70131_O * 0.5, z, 4, 0.2, 0.2, 0.2, 0.0, new int[0]);
    }

    @Override
    public Faction getSummonerFaction() {
        return this.getFaction();
    }

    @Override
    public List<Entity> getSummonedEntities() {
        return this.summonedEntities;
    }

    @Override
    public EntityLivingBase getSummoner() {
        return this;
    }

    @Override
    public void addSummonedEntityToList(Entity summoned) {
        this.summonedEntities.add(summoned);
    }
}

