/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.event.world.structure.generation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.Triple;
import team.cqr.cqrepoured.CQRMain;

@Mod.EventBusSubscriber(modid="cqrepoured")
public class DungeonGenerationHelper {
    private static final Map<Integer, Set<EntityPlayer>> TRAVELING_PLAYERS = new HashMap<Integer, Set<EntityPlayer>>();
    private static final Map<World, Set<ChunkPos>> DELAYED_CHUNKS = new HashMap<World, Set<ChunkPos>>();
    private static boolean isGeneratingDelayedChunks = false;

    public static void onWorldUnloadEvent(World world) {
        DungeonGenerationHelper.generateDelayedChunks(world);
        TRAVELING_PLAYERS.remove(world.field_73011_w.getDimension());
        DELAYED_CHUNKS.remove(world);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onWorldTickEvent(TickEvent.WorldTickEvent event) {
        DungeonGenerationHelper.generateDelayedChunks(event.world);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            TRAVELING_PLAYERS.computeIfAbsent(event.getDimension(), k -> new HashSet()).add((EntityPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onChunkLoadEvent(ChunkEvent.Load event) {
        TRAVELING_PLAYERS.computeIfPresent(event.getWorld().field_73011_w.getDimension(), (dimension, playersInDimension) -> {
            Iterator iterator = playersInDimension.iterator();
            HashSet<Triple> chunksToProcess = new HashSet<Triple>();
            while (iterator.hasNext()) {
                EntityPlayer player = (EntityPlayer)iterator.next();
                int chunkX = MathHelper.func_76128_c((double)player.field_70165_t) >> 4;
                int chunkZ = MathHelper.func_76128_c((double)player.field_70161_v) >> 4;
                int radius = 4;
                for (int x = -radius; x <= radius + 1; ++x) {
                    for (int z = -radius; z <= radius + 1; ++z) {
                        chunksToProcess.add(Triple.of((Object)player.field_70170_p, (Object)(chunkX + x), (Object)(chunkZ + z)));
                    }
                }
                iterator.remove();
            }
            for (Triple chunkPos : chunksToProcess) {
                ((World)chunkPos.getLeft()).func_72964_e(((Integer)chunkPos.getMiddle()).intValue(), ((Integer)chunkPos.getRight()).intValue());
            }
            return playersInDimension;
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        TRAVELING_PLAYERS.computeIfPresent(event.toDim, (k, v) -> {
            v.remove(event.player);
            return v;
        });
    }

    public static boolean shouldDelayDungeonGeneration(World world) {
        return world.field_72987_B;
    }

    public static void addDelayedChunk(World world, int chunkX, int chunkZ) {
        DELAYED_CHUNKS.computeIfAbsent(world, k -> new HashSet()).add(new ChunkPos(chunkX, chunkZ));
    }

    public static boolean shouldGenerateDungeonImmediately(World world) {
        if (isGeneratingDelayedChunks) {
            return true;
        }
        if (world.field_73010_i.isEmpty()) {
            return true;
        }
        Set<EntityPlayer> set = TRAVELING_PLAYERS.get(world.field_73011_w.getDimension());
        return set != null && !set.isEmpty();
    }

    private static void generateDelayedChunks(World world) {
        DELAYED_CHUNKS.computeIfPresent(world, (k, v) -> {
            for (ChunkPos chunkPos : v) {
                long worldSeed = world.func_72905_C();
                Random fmlRandom = new Random(worldSeed);
                long xSeed = fmlRandom.nextLong() >> 3;
                long zSeed = fmlRandom.nextLong() >> 3;
                long chunkSeed = xSeed * (long)chunkPos.field_77276_a + zSeed * (long)chunkPos.field_77275_b ^ worldSeed;
                fmlRandom.setSeed(chunkSeed);
                isGeneratingDelayedChunks = true;
                CQRMain.DUNGEON_GENERATOR.generate(fmlRandom, chunkPos.field_77276_a, chunkPos.field_77275_b, world, ((WorldServer)world).func_72863_F().field_186029_c, world.func_72863_F());
                CQRMain.WALL_GENERATOR.generate(fmlRandom, chunkPos.field_77276_a, chunkPos.field_77275_b, world, ((WorldServer)world).func_72863_F().field_186029_c, world.func_72863_F());
                isGeneratingDelayedChunks = false;
            }
            v.clear();
            return v;
        });
    }
}

