/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.item.staff;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.item.IRangedWeapon;

public class ItemStaffFire
extends Item
implements IRangedWeapon {
    public ItemStaffFire() {
        this.func_77625_d(1);
        this.func_77656_e(2048);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        boolean flag = super.func_77644_a(stack, target, attacker);
        if (flag && field_77697_d.nextInt(5) == 0 && target.func_184187_bx() != null) {
            target.func_184210_p();
        }
        return flag;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        playerIn.func_184609_a(handIn);
        this.shootFromEntity((EntityLivingBase)playerIn);
        this.changeTorch(worldIn, playerIn);
        stack.func_77972_a(1, (EntityLivingBase)playerIn);
        playerIn.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void changeTorch(World worldIn, EntityPlayer player) {
        BlockPos pos;
        IBlockState blockStateLookingAt;
        Vec3d end;
        Vec3d start = player.func_174824_e(1.0f);
        RayTraceResult result = worldIn.func_72933_a(start, end = start.func_178787_e(player.func_70040_Z().func_186678_a(10.0)));
        if (result != null && !worldIn.field_72995_K && (blockStateLookingAt = worldIn.func_180495_p(pos = new BlockPos(result.field_72307_f))).func_177230_c() == CQRBlocks.UNLIT_TORCH) {
            worldIn.func_175656_a(pos, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, blockStateLookingAt.func_177229_b((IProperty)BlockTorch.field_176596_a)));
        }
    }

    public void shootFromEntity(EntityLivingBase shooter) {
        World world = shooter.field_70170_p;
        if (!world.field_72995_K) {
            Random r = shooter.func_70681_au();
            for (int i = 0; i < 20; ++i) {
                Vec3d v = shooter.func_70040_Z();
                v = v.func_72441_c(((double)r.nextFloat() - 0.5) / 3.0, ((double)r.nextFloat() - 0.5) / 3.0, ((double)r.nextFloat() - 0.5) / 3.0);
                ((WorldServer)world).func_175739_a(EnumParticleTypes.FLAME, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, 0, v.field_72450_a, v.field_72448_b, v.field_72449_c, (double)r.nextFloat() + 0.2, new int[0]);
            }
            world.func_175647_a(EntityLivingBase.class, shooter.func_174813_aQ().func_186662_g(8.0), entity -> {
                Vec3d b;
                double z;
                double y;
                if (TargetUtil.isAllyCheckingLeaders(shooter, entity)) {
                    return false;
                }
                double x = MathHelper.func_151237_a((double)shooter.field_70165_t, (double)(entity.field_70165_t - (double)entity.field_70130_N * 0.5), (double)(entity.field_70165_t + (double)entity.field_70130_N * 0.5)) - shooter.field_70165_t;
                if (x * x + (y = MathHelper.func_151237_a((double)(shooter.field_70163_u + (double)shooter.func_70047_e()), (double)entity.field_70163_u, (double)(entity.field_70163_u + (double)entity.field_70131_O)) - (shooter.field_70163_u + (double)shooter.func_70047_e())) * y + (z = MathHelper.func_151237_a((double)shooter.field_70161_v, (double)(entity.field_70161_v - (double)entity.field_70130_N * 0.5), (double)(entity.field_70161_v + (double)entity.field_70130_N * 0.5)) - shooter.field_70161_v) * z > 64.0) {
                    return false;
                }
                Vec3d a = shooter.func_70040_Z();
                if (Math.toDegrees(Math.acos(a.func_72430_b(b = new Vec3d(x, y, z)) / (a.func_72433_c() * b.func_72433_c()))) > 40.0) {
                    return false;
                }
                return shooter.func_70685_l((Entity)entity);
            }).forEach(target -> {
                if (target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)shooter).func_76361_j(), 3.0f)) {
                    target.func_70015_d(5);
                }
            });
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.staff_fire.name", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.click_shift.name", (Object[])new Object[0]));
        }
    }

    @Override
    public void shoot(World worldIn, EntityLivingBase shooter, Entity target, EnumHand handIn) {
        this.shootFromEntity(shooter);
    }

    @Override
    public SoundEvent getShootSound() {
        return SoundEvents.field_187557_bK;
    }

    @Override
    public double getRange() {
        return 7.5;
    }

    @Override
    public int getCooldown() {
        return 60;
    }

    @Override
    public int getChargeTicks() {
        return 0;
    }
}

