/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.network.server.packet;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import team.cqr.cqrepoured.customtextures.TextureSet;

public class SPacketCustomTextures
implements IMessage {
    private Map<String, byte[]> entries = new HashMap<String, byte[]>();
    private Map<String, Map<ResourceLocation, Set<ResourceLocation>>> textureSets = new HashMap<String, Map<ResourceLocation, Set<ResourceLocation>>>();

    public void addPair(byte[] file, String path) {
        this.entries.put(path, file);
    }

    public void addTextureSet(TextureSet ts) {
        this.textureSets.put(ts.getName(), ts.getMappings());
    }

    public void fromBytes(ByteBuf buf) {
        int tscount = buf.readInt();
        for (int keys = buf.readInt(); keys > 0; --keys) {
            String k = ByteBufUtils.readUTF8String((ByteBuf)buf);
            byte[] v = new byte[buf.readInt()];
            buf.readBytes(v);
            this.entries.put(k, v);
        }
        while (tscount > 0) {
            String tsname = ByteBufUtils.readUTF8String((ByteBuf)buf);
            Map entityTextureMap = this.textureSets.getOrDefault(tsname, new HashMap());
            for (int tskeys = buf.readInt(); tskeys > 0; --tskeys) {
                String key = ByteBufUtils.readUTF8String((ByteBuf)buf);
                HashSet<ResourceLocation> values = new HashSet<ResourceLocation>();
                for (int vals = buf.readInt(); vals > 0; --vals) {
                    String val = ByteBufUtils.readUTF8String((ByteBuf)buf);
                    values.add(new ResourceLocation(val));
                }
                entityTextureMap.put(new ResourceLocation(key), values);
            }
            this.textureSets.put(tsname, entityTextureMap);
            --tscount;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entries.size());
        buf.writeInt(this.textureSets.size());
        for (Map.Entry<String, byte[]> entry : this.entries.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey());
            buf.writeInt(entry.getValue().length);
            buf.writeBytes(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.textureSets.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey());
            Map entityTextureMap = (Map)entry.getValue();
            buf.writeInt(entityTextureMap.size());
            entityTextureMap.forEach((k, v) -> {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)k.toString());
                buf.writeInt(v.size());
                for (ResourceLocation val : v) {
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)val.toString());
                }
            });
        }
    }

    public Map<String, byte[]> getTextureMap() {
        return this.entries;
    }

    public Map<String, Map<ResourceLocation, Set<ResourceLocation>>> getTextureSets() {
        return this.textureSets;
    }
}

