/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import team.cqr.cqrepoured.entity.EntityEquipmentExtraSlot;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.init.CQRItems;

public class GearedMobFactory {
    private static final List<ItemStack> DEBUFF_ARROW_LIST = new ArrayList<ItemStack>();
    private int floorCount = 1;
    private ResourceLocation entityID;
    private Random random;

    public GearedMobFactory(int floorCount, ResourceLocation entityID, Random rng) {
        this.floorCount = floorCount;
        this.entityID = entityID;
        this.random = rng;
    }

    public Entity getGearedEntityByFloor(int floor, World world) {
        Entity entity = EntityList.func_188429_b((ResourceLocation)this.entityID, (World)world);
        EArmorType armorType = this.getGearTier(floor);
        EWeaponType weaponType = this.getHandEquipment();
        boolean enchant = this.enchantGear(floor);
        ItemStack mainHand = ItemStack.field_190927_a;
        ItemStack offHand = ItemStack.field_190927_a;
        ItemStack head = ItemStack.field_190927_a;
        ItemStack chest = ItemStack.field_190927_a;
        ItemStack legs = ItemStack.field_190927_a;
        ItemStack feet = ItemStack.field_190927_a;
        switch (weaponType) {
            case BOW: {
                mainHand = new ItemStack((Item)Items.field_151031_f);
                if (!(entity instanceof AbstractEntityCQR) || !(this.random.nextDouble() < 0.1 + 0.2 * (double)floor / (double)this.floorCount)) break;
                ItemStack arrow = DEBUFF_ARROW_LIST.get(this.random.nextInt(DEBUFF_ARROW_LIST.size())).func_77946_l();
                ((AbstractEntityCQR)entity).setItemStackToExtraSlot(EntityEquipmentExtraSlot.ARROW, arrow);
                break;
            }
            case HEALING_STAFF: {
                mainHand = new ItemStack((Item)CQRItems.STAFF_HEALING);
                break;
            }
            case MAGIC_STAFF: {
                switch (this.random.nextInt(3)) {
                    case 0: {
                        mainHand = new ItemStack(CQRItems.STAFF_POISON);
                        break;
                    }
                    case 1: {
                        mainHand = new ItemStack(CQRItems.STAFF_FIRE);
                        break;
                    }
                    case 2: {
                        mainHand = new ItemStack(CQRItems.STAFF_VAMPIRIC);
                    }
                }
                break;
            }
            case MELEE: {
                block11 : switch (armorType) {
                    case LEATHER: {
                        mainHand = new ItemStack(Items.field_151041_m);
                        break;
                    }
                    case GOLD: {
                        mainHand = new ItemStack(Items.field_151010_B);
                        break;
                    }
                    case CHAIN: {
                        mainHand = new ItemStack(Items.field_151052_q);
                        break;
                    }
                    case IRON: {
                        if (this.random.nextDouble() < 0.6) {
                            mainHand = new ItemStack(Items.field_151040_l);
                            break;
                        }
                        switch (this.random.nextInt(3)) {
                            case 0: {
                                mainHand = new ItemStack(CQRItems.GREAT_SWORD_IRON);
                                break;
                            }
                            case 1: {
                                mainHand = new ItemStack(CQRItems.SPEAR_IRON);
                                break;
                            }
                            case 2: {
                                mainHand = new ItemStack(CQRItems.DAGGER_IRON);
                            }
                        }
                        break;
                    }
                    case DIAMOND: {
                        if (this.random.nextDouble() < 0.6) {
                            mainHand = new ItemStack(Items.field_151048_u);
                            break;
                        }
                        switch (this.random.nextInt(3)) {
                            case 0: {
                                mainHand = new ItemStack(CQRItems.GREAT_SWORD_DIAMOND);
                                break block11;
                            }
                            case 1: {
                                mainHand = new ItemStack(CQRItems.SPEAR_DIAMOND);
                                break block11;
                            }
                            case 2: {
                                mainHand = new ItemStack(CQRItems.DAGGER_DIAMOND);
                            }
                        }
                    }
                }
                if (mainHand.func_77973_b().getClass() != ItemSword.class || !(this.random.nextDouble() < 0.3)) break;
                offHand = new ItemStack(Items.field_185159_cQ);
            }
        }
        switch (armorType) {
            case LEATHER: {
                head = new ItemStack((Item)Items.field_151024_Q);
                chest = new ItemStack((Item)Items.field_151027_R);
                legs = new ItemStack((Item)Items.field_151026_S);
                feet = new ItemStack((Item)Items.field_151021_T);
                break;
            }
            case GOLD: {
                head = new ItemStack((Item)Items.field_151169_ag);
                chest = new ItemStack((Item)Items.field_151171_ah);
                legs = new ItemStack((Item)Items.field_151149_ai);
                feet = new ItemStack((Item)Items.field_151151_aj);
                break;
            }
            case CHAIN: {
                head = new ItemStack((Item)Items.field_151020_U);
                chest = new ItemStack((Item)Items.field_151023_V);
                legs = new ItemStack((Item)Items.field_151022_W);
                feet = new ItemStack((Item)Items.field_151029_X);
                break;
            }
            case IRON: {
                if (this.random.nextDouble() < 0.1) {
                    head = new ItemStack(CQRItems.HELMET_HEAVY_IRON);
                    chest = new ItemStack(CQRItems.CHESTPLATE_HEAVY_IRON);
                    legs = new ItemStack(CQRItems.LEGGINGS_HEAVY_IRON);
                    feet = new ItemStack(CQRItems.BOOTS_HEAVY_IRON);
                    break;
                }
                head = new ItemStack((Item)Items.field_151028_Y);
                chest = new ItemStack((Item)Items.field_151030_Z);
                legs = new ItemStack((Item)Items.field_151165_aa);
                feet = new ItemStack((Item)Items.field_151167_ab);
                break;
            }
            case DIAMOND: {
                if (this.random.nextDouble() < 0.1) {
                    head = new ItemStack(CQRItems.HELMET_HEAVY_DIAMOND);
                    chest = new ItemStack(CQRItems.CHESTPLATE_HEAVY_DIAMOND);
                    legs = new ItemStack(CQRItems.LEGGINGS_HEAVY_DIAMOND);
                    feet = new ItemStack(CQRItems.BOOTS_HEAVY_DIAMOND);
                    break;
                }
                head = new ItemStack((Item)Items.field_151161_ac);
                chest = new ItemStack((Item)Items.field_151163_ad);
                legs = new ItemStack((Item)Items.field_151173_ae);
                feet = new ItemStack((Item)Items.field_151175_af);
            }
        }
        if (enchant) {
            int level = 30 * (floor / this.floorCount);
            boolean allowTreasure = level > 20;
            EnchantmentHelper.func_77504_a((Random)this.random, (ItemStack)mainHand, (int)level, (boolean)allowTreasure);
            EnchantmentHelper.func_77504_a((Random)this.random, (ItemStack)head, (int)level, (boolean)allowTreasure);
            EnchantmentHelper.func_77504_a((Random)this.random, (ItemStack)chest, (int)level, (boolean)allowTreasure);
            EnchantmentHelper.func_77504_a((Random)this.random, (ItemStack)legs, (int)level, (boolean)allowTreasure);
            EnchantmentHelper.func_77504_a((Random)this.random, (ItemStack)feet, (int)level, (boolean)allowTreasure);
        }
        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, mainHand);
        entity.func_184201_a(EntityEquipmentSlot.OFFHAND, offHand);
        entity.func_184201_a(EntityEquipmentSlot.HEAD, head);
        entity.func_184201_a(EntityEquipmentSlot.CHEST, chest);
        entity.func_184201_a(EntityEquipmentSlot.LEGS, legs);
        entity.func_184201_a(EntityEquipmentSlot.FEET, feet);
        if (entity instanceof AbstractEntityCQR) {
            ((AbstractEntityCQR)entity).setHealingPotions(1);
        }
        return entity;
    }

    public Entity getGearedEntity(World world) {
        return this.getGearedEntityByFloor(this.random.nextInt(this.floorCount + 1), world);
    }

    private boolean enchantGear(int floor) {
        double chance = 0.1 + 0.2 * (double)floor / (double)this.floorCount;
        return this.random.nextDouble() <= chance;
    }

    private EArmorType getGearTier(int floor) {
        int index = MathHelper.func_76125_a((int)((int)((double)floor / (double)this.floorCount * 5.0)), (int)0, (int)(EArmorType.values().length - 1));
        return EArmorType.values()[index];
    }

    private EWeaponType getHandEquipment() {
        LinkedList<EWeaponType> weaponTypes = new LinkedList<EWeaponType>();
        int maxWeight = 0;
        for (EWeaponType weaponType : EWeaponType.values()) {
            if (weaponType.weight <= 0) continue;
            weaponTypes.add(weaponType);
            maxWeight += weaponType.weight;
        }
        int i = this.random.nextInt(maxWeight);
        for (EWeaponType weaponType : weaponTypes) {
            if ((i -= weaponType.weight) > 0) continue;
            return weaponType;
        }
        return EWeaponType.MELEE;
    }

    static {
        for (Potion potion : ForgeRegistries.POTIONS.getValuesCollection()) {
            if (!potion.func_76398_f()) continue;
            PotionEffect potionEffect = new PotionEffect(potion, potion.func_76403_b() ? 0 : 100);
            ArrayList<PotionEffect> effectList = new ArrayList<PotionEffect>(1);
            effectList.add(potionEffect);
            DEBUFF_ARROW_LIST.add(PotionUtils.func_185184_a((ItemStack)new ItemStack(Items.field_185167_i), effectList));
        }
    }

    public static enum EArmorType {
        LEATHER,
        GOLD,
        CHAIN,
        IRON,
        DIAMOND;

    }

    public static enum EWeaponType {
        MELEE(40),
        MAGIC_STAFF(10),
        HEALING_STAFF(10),
        BOW(10);

        private int weight;

        private EWeaponType(int weight) {
            this.weight = weight;
        }
    }
}

