/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generation.generatable;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.storage.MapData;
import team.cqr.cqrepoured.util.BlockPlacingHelper;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.world.structure.generation.generation.GeneratableDungeon;
import team.cqr.cqrepoured.world.structure.generation.generation.generatable.GeneratablePosInfo;

public class GeneratableMapInfo
extends GeneratablePosInfo {
    private final EntityItemFrame entity;
    private final int mapOriginX;
    private final int mapOriginZ;
    private final int mapX;
    private final int mapZ;
    private final byte scale;
    private final boolean fillMap;
    private final int fillRadius;

    public GeneratableMapInfo(int x, int y, int z, EntityItemFrame entity, int mapOriginX, int mapOriginZ, int mapX, int mapZ, byte scale, boolean fillMap, int fillRadius) {
        super(x, y, z);
        this.entity = entity;
        this.mapOriginX = mapOriginX;
        this.mapOriginZ = mapOriginZ;
        this.mapX = mapX;
        this.mapZ = mapZ;
        this.scale = scale;
        this.fillMap = fillMap;
        this.fillRadius = fillRadius;
    }

    public GeneratableMapInfo(BlockPos pos, EntityItemFrame entity, int mapOriginX, int mapOriginZ, int mapX, int mapZ, byte scale, boolean fillMap, int fillRadius) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), entity, mapOriginX, mapOriginZ, mapX, mapZ, scale, fillMap, fillRadius);
    }

    @Override
    public boolean place(World world, Chunk chunk, ExtendedBlockStorage blockStorage, BlockPos pos, GeneratableDungeon dungeon) {
        IBlockState state = blockStorage.func_177485_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF);
        int light = state.getLightValue((IBlockAccess)world, pos);
        if (light > 0) {
            dungeon.markRemovedLight(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), light);
        }
        boolean flag = BlockPlacingHelper.setBlockState(world, chunk, blockStorage, pos, Blocks.field_150350_a.func_176223_P(), null, 16);
        ItemStack stack = ItemMap.func_190906_a((World)world, (double)this.mapX, (double)this.mapZ, (byte)this.scale, (boolean)true, (boolean)true);
        if (this.fillMap) {
            GeneratableMapInfo.updateMapData(world, this.mapOriginX, this.mapOriginZ, this.fillRadius, ((ItemMap)stack.func_77973_b()).func_77873_a(stack, world));
        }
        this.entity.func_82334_a(stack);
        world.func_72838_d((Entity)this.entity);
        return flag;
    }

    private static void updateMapData(World worldIn, int x, int z, int radius, MapData data) {
        if (worldIn.field_73011_w.getDimension() != data.field_76200_c) {
            return;
        }
        for (int ix = 0; ix < 128; ++ix) {
            int worldX = data.field_76201_a + (ix - 64) * (1 << data.field_76197_d);
            for (int iz = 0; iz < 128; ++iz) {
                int worldZ = data.field_76199_b + (iz - 64) * (1 << data.field_76197_d);
                if (!DungeonGenUtils.isInsideCircle(worldX - x, worldZ - z, radius)) continue;
                GeneratableMapInfo.updateMapColorAt(worldIn, ix, iz, data);
            }
        }
    }

    private static void updateMapColorAt(World world, int mapX, int mapZ, MapData data) {
        byte b1;
        byte b0;
        MapColor mapcolor;
        int i = 1 << data.field_76197_d;
        double d0 = 0.0;
        int k2 = (data.field_76201_a / i + mapX - 64) * i;
        int l2 = (data.field_76199_b / i + mapZ - 64) * i;
        HashMultiset multiset = HashMultiset.create();
        Chunk chunk = world.func_72964_e(k2 >> 4, l2 >> 4);
        int i3 = k2 & 0xF;
        int j3 = l2 & 0xF;
        int k3 = 0;
        double d1 = 0.0;
        if (world.field_73011_w.func_177495_o()) {
            int l3 = k2 + l2 * 231871;
            if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                multiset.add((Object)Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT).func_185909_g((IBlockAccess)world, BlockPos.field_177992_a), 10);
            } else {
                multiset.add((Object)Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.STONE).func_185909_g((IBlockAccess)world, BlockPos.field_177992_a), 100);
            }
            d1 = 100.0;
        } else {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int i4 = 0; i4 < i; ++i4) {
                for (int j4 = 0; j4 < i; ++j4) {
                    int k4 = chunk.func_76611_b(i4 + i3, j4 + j3) + 1;
                    IBlockState state = Blocks.field_150350_a.func_176223_P();
                    if (k4 <= 1) {
                        state = Blocks.field_150357_h.func_176223_P();
                    } else {
                        do {
                            state = chunk.func_186032_a(i4 + i3, --k4, j4 + j3);
                            pos.func_181079_c((chunk.field_76635_g << 4) + i4 + i3, k4, (chunk.field_76647_h << 4) + j4 + j3);
                        } while (state.func_185909_g((IBlockAccess)world, (BlockPos)pos) == MapColor.field_151660_b && k4 > 0);
                        if (k4 > 0 && state.func_185904_a().func_76224_d()) {
                            IBlockState iblockstate1;
                            int l4 = k4 - 1;
                            do {
                                iblockstate1 = chunk.func_186032_a(i4 + i3, l4--, j4 + j3);
                                ++k3;
                            } while (l4 > 0 && iblockstate1.func_185904_a().func_76224_d());
                        }
                    }
                    d1 += (double)k4 / (double)(i * i);
                    multiset.add((Object)state.func_185909_g((IBlockAccess)world, (BlockPos)pos));
                }
            }
        }
        k3 /= i * i;
        double d2 = (d1 - d0) * 4.0 / (double)(i + 4) + ((double)(mapX + mapZ & 1) - 0.5) * 0.4;
        int i5 = 1;
        if (d2 > 0.6) {
            i5 = 2;
        }
        if (d2 < -0.6) {
            i5 = 0;
        }
        if ((mapcolor = (MapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MapColor.field_151660_b)) == MapColor.field_151662_n) {
            d2 = (double)k3 * 0.1 + (double)(mapX + mapZ & 1) * 0.2;
            i5 = 1;
            if (d2 < 0.5) {
                i5 = 2;
            }
            if (d2 > 0.9) {
                i5 = 0;
            }
        }
        if ((b0 = data.field_76198_e[mapX + mapZ * 128]) != (b1 = (byte)(mapcolor.field_76290_q * 4 + i5))) {
            data.field_76198_e[mapX + mapZ * 128] = b1;
            data.func_176053_a(mapX, mapZ);
        }
    }

    public EntityItemFrame getEntity() {
        return this.entity;
    }

    public int getMapX() {
        return this.mapX;
    }

    public int getMapZ() {
        return this.mapZ;
    }

    public byte getScale() {
        return this.scale;
    }

    public boolean isFillMap() {
        return this.fillMap;
    }

    public int getFillRadius() {
        return this.fillRadius;
    }
}

