/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generation.util;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntPriorityQueue;
import java.util.Arrays;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import team.cqr.cqrepoured.world.structure.generation.generation.ChunkInfo;

public class BlockLightUtil {
    private static final int MAX_LIGHT_LEVEL = 15;
    private static final IntPriorityQueue QUEUE = new IntArrayFIFOQueue();
    private static final boolean[] USED = new boolean[24389];
    private static final BlockPos.MutableBlockPos MUTABLE = new BlockPos.MutableBlockPos();
    private static final BlockPos.MutableBlockPos MUTABLE1 = new BlockPos.MutableBlockPos();

    public static void checkBlockLight(World world, ChunkInfo chunkInfo) {
        if (!world.func_175697_a((BlockPos)MUTABLE.func_181079_c(chunkInfo.getChunkX() << 4, 0, chunkInfo.getChunkZ() << 4), 16)) {
            return;
        }
        Chunk chunk = world.func_72964_e(chunkInfo.getChunkX(), chunkInfo.getChunkZ());
        chunkInfo.forEachReversed(chunkY -> {
            ExtendedBlockStorage blockStorage = chunk.func_76587_i()[chunkY];
            if (blockStorage == Chunk.field_186036_a || blockStorage.func_76663_a()) {
                return;
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 15; y >= 0; --y) {
                        MUTABLE.func_181079_c((chunk.field_76635_g << 4) + x, (chunkY << 4) + y, (chunk.field_76647_h << 4) + z);
                        IBlockState state = blockStorage.func_177485_a(x, y, z);
                        if (state.getLightValue((IBlockAccess)world, (BlockPos)MUTABLE) <= 0) continue;
                        BlockLightUtil.relightBlock(world, MUTABLE.func_185334_h());
                    }
                }
            }
        });
    }

    private static int encode(int light, int x, int y, int z) {
        light = MathHelper.func_76125_a((int)light, (int)0, (int)15);
        return light << 24 | (x += 14) << 16 | (y += 14) << 8 | (z += 14);
    }

    private static int decodeLight(int lxyz) {
        return MathHelper.func_76125_a((int)(lxyz >>> 24), (int)0, (int)15);
    }

    private static int decodeX(int lxyz) {
        return (lxyz >>> 16 & 0xFF) - 14;
    }

    private static int decodeY(int lxyz) {
        return (lxyz >>> 8 & 0xFF) - 14;
    }

    private static int decodeZ(int lxyz) {
        return (lxyz & 0xFF) - 14;
    }

    private static boolean getAndSetUsed(int x, int y, int z) {
        int i = ((x += 14) * 29 + (y += 14)) * 29 + (z += 14);
        if (USED[i]) {
            return true;
        }
        BlockLightUtil.USED[i] = true;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void relightBlock(World world, BlockPos pos) {
        int initialLight = world.func_180495_p(pos).getLightValue((IBlockAccess)world, pos);
        if (world.func_175642_b(EnumSkyBlock.BLOCK, pos) < initialLight) {
            world.func_175653_a(EnumSkyBlock.BLOCK, pos, initialLight);
        }
        QUEUE.enqueue(BlockLightUtil.encode(initialLight, 0, 0, 0));
        BlockLightUtil.getAndSetUsed(0, 0, 0);
        while (!QUEUE.isEmpty()) {
            int lxyz = QUEUE.dequeueInt();
            int light = BlockLightUtil.decodeLight(lxyz);
            int x = BlockLightUtil.decodeX(lxyz);
            int y = BlockLightUtil.decodeY(lxyz);
            int z = BlockLightUtil.decodeZ(lxyz);
            MUTABLE1.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                try {
                    MUTABLE1.func_189536_c(facing);
                    if (BlockLightUtil.getAndSetUsed(x + facing.func_82601_c(), y + facing.func_96559_d(), z + facing.func_82599_e()) || world.func_189509_E((BlockPos)MUTABLE1)) continue;
                    Chunk chunk = world.func_72964_e(MUTABLE1.func_177958_n() >> 4, MUTABLE1.func_177952_p() >> 4);
                    ExtendedBlockStorage blockStorage = chunk.func_76587_i()[MUTABLE1.func_177956_o() >> 4];
                    if (blockStorage == Chunk.field_186036_a) {
                        chunk.func_76587_i()[BlockLightUtil.MUTABLE1.func_177956_o() >> 4] = blockStorage = new ExtendedBlockStorage(MUTABLE1.func_177956_o() >> 4 << 4, world.field_73011_w.func_191066_m());
                        chunk.func_76603_b();
                    }
                    int opacity = Math.max(blockStorage.func_177485_a(MUTABLE1.func_177958_n() & 0xF, MUTABLE1.func_177956_o() & 0xF, MUTABLE1.func_177952_p() & 0xF).getLightOpacity((IBlockAccess)world, (BlockPos)MUTABLE1), 1);
                    int newLight = light - opacity;
                    if (blockStorage.func_76674_d(MUTABLE1.func_177958_n() & 0xF, MUTABLE1.func_177956_o() & 0xF, MUTABLE1.func_177952_p() & 0xF) >= newLight) continue;
                    blockStorage.func_76677_d(MUTABLE1.func_177958_n() & 0xF, MUTABLE1.func_177956_o() & 0xF, MUTABLE1.func_177952_p() & 0xF, newLight);
                    chunk.func_76630_e();
                    if (newLight <= 1) continue;
                    QUEUE.enqueue(BlockLightUtil.encode(newLight, x + facing.func_82601_c(), y + facing.func_96559_d(), z + facing.func_82599_e()));
                }
                finally {
                    MUTABLE1.func_189536_c(facing.func_176734_d());
                }
            }
        }
        Arrays.fill(USED, false);
    }
}

