/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.structurefile;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.apache.commons.io.FileUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.block.BlockExporterChest;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.NBTCollectors;
import team.cqr.cqrepoured.util.NBTHelper;
import team.cqr.cqrepoured.world.structure.generation.generation.DungeonPlacement;
import team.cqr.cqrepoured.world.structure.generation.generation.GeneratableDungeon;
import team.cqr.cqrepoured.world.structure.generation.generation.part.BlockDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generation.part.EntityDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generation.part.IDungeonPartBuilder;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableEntityInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparablePosInfo;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.world.structure.generation.structurefile.BlockStatePalette;
import team.cqr.cqrepoured.world.structure.generation.structurefile.Offset;

public class CQStructure {
    private static final Comparator<PreparablePosInfo> DEFAULT_COMPARATOR = Comparator.comparingInt(PreparablePosInfo::getX).thenComparingInt(PreparablePosInfo::getY).thenComparingInt(PreparablePosInfo::getZ);
    private static final Map<File, CQStructure> CACHED_STRUCTURES = new HashMap<File, CQStructure>();
    public static final String CQR_FILE_VERSION = "1.2.0";
    private static final Set<ResourceLocation> SPECIAL_ENTITIES = new HashSet<ResourceLocation>();
    private final List<PreparablePosInfo> blockInfoList = new ArrayList<PreparablePosInfo>();
    private final List<PreparableEntityInfo> entityInfoList = new ArrayList<PreparableEntityInfo>();
    private final List<BlockPos> unprotectedBlockList = new ArrayList<BlockPos>();
    private BlockPos size = BlockPos.field_177992_a;
    private String author = "";

    private CQStructure() {
    }

    public static void cacheFiles() {
        CACHED_STRUCTURES.clear();
        if (!CQRConfig.advanced.cacheStructureFiles) {
            return;
        }
        ArrayList fileList = new ArrayList(FileUtils.listFiles((File)CQRMain.CQ_STRUCTURE_FILES_FOLDER, (String[])new String[]{"nbt"}, (boolean)true));
        fileList.sort((file1, file2) -> {
            if (file1.length() > file2.length()) {
                return -1;
            }
            if (file1.length() < file2.length()) {
                return 1;
            }
            return 0;
        });
        long fileSizeSum = 0L;
        for (int i = 0; i < fileList.size() && i < CQRConfig.advanced.cachedStructureFilesMaxAmount; ++i) {
            File file = (File)fileList.get(i);
            long fileSize = file.length();
            if (fileSizeSum + fileSize >= (long)(CQRConfig.advanced.cachedStructureFilesMaxSize * 1000)) continue;
            CACHED_STRUCTURES.put(file, CQStructure.createFromFile(file));
            fileSizeSum += fileSize;
        }
    }

    public static void clearCache() {
        CACHED_STRUCTURES.clear();
    }

    public static CQStructure createFromFile(File file) {
        if (CACHED_STRUCTURES.containsKey(file)) {
            return CACHED_STRUCTURES.get(file);
        }
        CQStructure structure = new CQStructure();
        structure.readFromFile(file);
        return structure;
    }

    public static CQStructure createFromWorld(World world, BlockPos startPos, BlockPos endPos, boolean ignoreBasicEntities, Collection<BlockPos> unprotectedBlocks, String author) {
        CQStructure structure = new CQStructure();
        structure.author = author;
        structure.takeBlocksAndEntitiesFromWorld(world, startPos, endPos, ignoreBasicEntities, unprotectedBlocks);
        return structure;
    }

    public boolean isEmpty() {
        return this.blockInfoList.isEmpty() && this.entityInfoList.isEmpty();
    }

    public boolean writeToFile(File file) {
        try {
            if (file.isDirectory()) {
                throw new FileNotFoundException();
            }
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.writeToNBT(), (OutputStream)outputStream);
            }
            return true;
        }
        catch (Exception e) {
            CQRMain.logger.error(String.format("Failed to write structure to file %s", file.getName()), (Throwable)e);
            return false;
        }
    }

    private boolean readFromFile(File file) {
        try {
            try (FileInputStream inputStream = new FileInputStream(file);){
                this.readFromNBT(CompressedStreamTools.func_74796_a((InputStream)inputStream));
            }
            return true;
        }
        catch (Exception e) {
            CQRMain.logger.error(String.format("Failed to read structure from file %s", file.getName()), (Throwable)e);
            return false;
        }
    }

    private NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("cqr_file_version", CQR_FILE_VERSION);
        compound.func_74778_a("author", this.author);
        compound.func_74782_a("size", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.size));
        BlockStatePalette palette = new BlockStatePalette();
        NBTTagList compoundList = new NBTTagList();
        ByteBuf buf = Unpooled.buffer((int)(this.blockInfoList.size() * 2));
        this.blockInfoList.forEach(preparable -> PreparablePosInfo.Registry.write(preparable, buf, palette, compoundList));
        compound.func_74773_a("blockInfoList", Arrays.copyOf(buf.array(), buf.writerIndex()));
        compound.func_74782_a("entityInfoList", (NBTBase)this.entityInfoList.stream().map(PreparableEntityInfo::getEntityData).collect(NBTCollectors.toList()));
        compound.func_74782_a("palette", (NBTBase)palette.writeToNBT());
        compound.func_74782_a("compoundTagList", (NBTBase)compoundList);
        compound.func_74783_a("unprotectedBlockList", this.unprotectedBlockList.stream().flatMapToInt(pos -> IntStream.of(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).toArray());
        return compound;
    }

    private void readFromNBT(NBTTagCompound compound) {
        String cqrFileVersion = compound.func_74779_i("cqr_file_version");
        if (!cqrFileVersion.equals(CQR_FILE_VERSION)) {
            if (cqrFileVersion.equals("1.1.0")) {
                CQRMain.logger.warn("Structure nbt is deprecated! Expected {} but got {}.", (Object)CQR_FILE_VERSION, (Object)cqrFileVersion);
                this.readFromDeprecatedNBT(compound);
                return;
            }
            throw new IllegalArgumentException(String.format("Structure nbt is too old! Expected %s but got %s.", CQR_FILE_VERSION, cqrFileVersion));
        }
        this.author = compound.func_74779_i("author");
        this.size = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("size"));
        this.blockInfoList.clear();
        this.entityInfoList.clear();
        BlockStatePalette blockStatePalette = new BlockStatePalette();
        NBTTagList compoundTagList = compound.func_150295_c("compoundTagList", 10);
        int blockStateIndex = 0;
        for (NBTBase nbt : compound.func_150295_c("palette", 10)) {
            blockStatePalette.addMapping(NBTUtil.func_190008_d((NBTTagCompound)((NBTTagCompound)nbt)), blockStateIndex++);
        }
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])compound.func_74770_j("blockInfoList"));
        for (int x = 0; x < this.size.func_177958_n(); ++x) {
            for (int y = 0; y < this.size.func_177956_o(); ++y) {
                for (int z = 0; z < this.size.func_177952_p(); ++z) {
                    this.blockInfoList.add(PreparablePosInfo.Registry.read(x, y, z, buf, blockStatePalette, compoundTagList));
                }
            }
        }
        if (compound.func_150297_b("specialBlockInfoList", 7)) {
            buf = Unpooled.wrappedBuffer((byte[])compound.func_74770_j("specialBlockInfoList"));
            int specialBlockCount = buf.readInt();
            for (int i2 = 0; i2 < specialBlockCount; ++i2) {
                short x = buf.readShort();
                short y = buf.readShort();
                short z = buf.readShort();
                int index = (x * this.size.func_177956_o() + y) * this.size.func_177952_p() + z;
                this.blockInfoList.set(index, PreparablePosInfo.Registry.read((int)x, (int)y, (int)z, buf, blockStatePalette, compoundTagList));
            }
        }
        for (NBTBase nbt : compound.func_150295_c("entityInfoList", 10)) {
            this.entityInfoList.add(new PreparableEntityInfo((NBTTagCompound)nbt));
        }
        this.unprotectedBlockList.clear();
        int[] intArray = compound.func_74759_k("unprotectedBlockList");
        IntStream.range(0, intArray.length / 3).mapToObj(i -> new BlockPos(intArray[i * 3], intArray[i * 3 + 1], intArray[i * 3 + 2])).forEach(this.unprotectedBlockList::add);
    }

    private void takeBlocksAndEntitiesFromWorld(World world, BlockPos startPos, BlockPos endPos, boolean ignoreBasicEntities, Collection<BlockPos> unprotectedBlocks) {
        BlockPos pos1 = DungeonGenUtils.getValidMinPos(startPos, endPos);
        BlockPos pos2 = DungeonGenUtils.getValidMaxPos(startPos, endPos);
        this.size = pos2.func_177973_b((Vec3i)pos1).func_177982_a(1, 1, 1);
        this.takeBlocksFromWorld(world, pos1, pos2);
        this.takeEntitiesFromWorld(world, pos1, pos2, ignoreBasicEntities);
        this.unprotectedBlockList.clear();
        for (BlockPos pos : unprotectedBlocks) {
            if (pos.func_177958_n() < pos1.func_177958_n() && pos.func_177956_o() < pos1.func_177956_o() && pos.func_177952_p() < pos1.func_177952_p() || pos.func_177958_n() > pos2.func_177958_n() && pos.func_177956_o() > pos2.func_177956_o() && pos.func_177952_p() > pos2.func_177952_p()) continue;
            this.unprotectedBlockList.add(pos.func_177973_b((Vec3i)pos1));
        }
    }

    private void takeBlocksFromWorld(World world, BlockPos minPos, BlockPos maxPos) {
        this.blockInfoList.clear();
        for (BlockPos.MutableBlockPos pos : BlockPos.func_177975_b((BlockPos)minPos, (BlockPos)maxPos)) {
            IBlockState state = world.func_180495_p((BlockPos)pos);
            Block block = state.func_177230_c();
            if (block != CQRBlocks.NULL_BLOCK && block != Blocks.field_189881_dj && block != CQRBlocks.BOSS_BLOCK && !(block instanceof BlockExporterChest) && block != CQRBlocks.SPAWNER && block != CQRBlocks.MAP_PLACEHOLDER && state.func_185887_b(world, (BlockPos)pos) < 0.0f) {
                CQRMain.logger.warn("Exporting unbreakable block: {} from {}", (Object)state, (Object)pos);
            }
            int x = pos.func_177958_n() - minPos.func_177958_n();
            int y = pos.func_177956_o() - minPos.func_177956_o();
            int z = pos.func_177952_p() - minPos.func_177952_p();
            this.blockInfoList.add(PreparablePosInfo.Registry.create(world, (BlockPos)pos, x, y, z, state));
        }
        this.blockInfoList.sort(DEFAULT_COMPARATOR);
    }

    private void takeEntitiesFromWorld(World world, BlockPos minPos, BlockPos maxPos, boolean ignoreBasicEntities) {
        this.entityInfoList.clear();
        AxisAlignedBB aabb = new AxisAlignedBB(minPos, maxPos.func_177982_a(1, 1, 1));
        for (Entity entity : world.func_175647_a(Entity.class, aabb, input -> !(input instanceof EntityPlayer))) {
            if (ignoreBasicEntities && !SPECIAL_ENTITIES.contains(EntityList.func_191301_a((Entity)entity))) {
                CQRMain.logger.info("Skipping entity: {}", (Object)entity);
                continue;
            }
            this.entityInfoList.add(new PreparableEntityInfo(minPos, entity));
        }
    }

    public List<PreparablePosInfo> getBlockInfoList() {
        return Collections.unmodifiableList(this.blockInfoList);
    }

    public List<PreparableEntityInfo> getEntityInfoList() {
        return Collections.unmodifiableList(this.entityInfoList);
    }

    public List<BlockPos> getUnprotectedBlockList() {
        return Collections.unmodifiableList(this.unprotectedBlockList);
    }

    public BlockPos getSize() {
        return this.size;
    }

    public String getAuthor() {
        return this.author;
    }

    public void addAll(GeneratableDungeon.Builder builder, BlockPos pos, Offset offset) {
        this.addAll(builder, builder.getPlacement(offset.apply(pos, this, Mirror.NONE, Rotation.NONE)));
    }

    public void addAll(GeneratableDungeon.Builder builder, BlockPos pos, Offset offset, Mirror mirror, Rotation rotation) {
        this.addAll(builder, builder.getPlacement(offset.apply(pos, this, mirror, rotation), mirror, rotation));
    }

    public void addAll(GeneratableDungeon.Builder builder, BlockPos pos, Offset offset, DungeonInhabitant inhabitant) {
        this.addAll(builder, builder.getPlacement(offset.apply(pos, this, Mirror.NONE, Rotation.NONE), inhabitant));
    }

    public void addAll(GeneratableDungeon.Builder builder, BlockPos pos, Offset offset, Mirror mirror, Rotation rotation, DungeonInhabitant inhabitant) {
        this.addAll(builder, builder.getPlacement(offset.apply(pos, this, mirror, rotation), mirror, rotation, inhabitant));
    }

    public void addAll(GeneratableDungeon.Builder builder, DungeonPlacement placement) {
        builder.add((IDungeonPartBuilder)new BlockDungeonPart.Builder().addAll(this.blockInfoList), placement);
        builder.add((IDungeonPartBuilder)new EntityDungeonPart.Builder().addAll(this.entityInfoList), placement);
    }

    public static void updateSpecialEntities() {
        SPECIAL_ENTITIES.clear();
        for (String s : CQRConfig.advanced.specialEntities) {
            SPECIAL_ENTITIES.add(new ResourceLocation(s));
        }
    }

    @Deprecated
    public static void checkAndUpdateStructureFiles() {
        if (!CQRConfig.advanced.checkAndUpdateDeprecatedStructureFiles) {
            return;
        }
        Collection files = FileUtils.listFiles((File)CQRMain.CQ_STRUCTURE_FILES_FOLDER, (String[])new String[]{"nbt"}, (boolean)true);
        CQRMain.logger.info("Checking {} structure files", (Object)files.size());
        long lastTimeLogged = System.currentTimeMillis();
        long checkedFiles = 0L;
        int updatedFiles = 0;
        for (File file : files) {
            CQStructure structure;
            if (!NBTHelper.getVersionOfStructureFile(file).equals(CQR_FILE_VERSION) && !(structure = CQStructure.createFromFile(file)).isEmpty()) {
                structure.writeToFile(file);
                ++updatedFiles;
            }
            ++checkedFiles;
            if (System.currentTimeMillis() - lastTimeLogged <= 2000L) continue;
            lastTimeLogged = System.currentTimeMillis();
            CQRMain.logger.info("{}/{}", (Object)checkedFiles, (Object)files.size());
        }
        CQRMain.logger.info("Updated {} structure files", (Object)updatedFiles);
    }

    @Deprecated
    private void readFromDeprecatedNBT(NBTTagCompound compound) {
        String cqrFileVersion = compound.func_74779_i("cqr_file_version");
        if (!cqrFileVersion.equals("1.1.0")) {
            throw new IllegalArgumentException(String.format("Structure nbt is too old! Expected %s but got %s.", "1.1.0", cqrFileVersion));
        }
        this.author = compound.func_74779_i("author");
        this.size = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("size"));
        this.blockInfoList.clear();
        this.entityInfoList.clear();
        BlockStatePalette blockStatePalette = new BlockStatePalette();
        NBTTagList compoundTagList = compound.func_150295_c("compoundTagList", 10);
        int blockStateIndex = 0;
        for (NBTBase nbt : compound.func_150295_c("palette", 10)) {
            blockStatePalette.addMapping(NBTUtil.func_190008_d((NBTTagCompound)((NBTTagCompound)nbt)), blockStateIndex++);
        }
        int x = 0;
        int y = 0;
        int z = 0;
        for (NBTBase nbt : compound.func_150295_c("blockInfoList", 11)) {
            this.blockInfoList.add(PreparablePosInfo.Registry.read(x, y, z, (NBTTagIntArray)nbt, blockStatePalette, compoundTagList));
            if (x < this.size.func_177958_n() - 1) {
                ++x;
                continue;
            }
            if (y < this.size.func_177956_o() - 1) {
                x = 0;
                ++y;
                continue;
            }
            if (z >= this.size.func_177952_p() - 1) continue;
            x = 0;
            y = 0;
            ++z;
        }
        this.blockInfoList.sort(DEFAULT_COMPARATOR);
        for (NBTBase nbt : compound.func_150295_c("specialBlockInfoList", 10)) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            if (!tag.func_150297_b("blockInfo", 11)) continue;
            NBTTagList pos = tag.func_150295_c("pos", 3);
            this.blockInfoList.add(PreparablePosInfo.Registry.read(pos.func_186858_c(0), pos.func_186858_c(1), pos.func_186858_c(2), (NBTTagIntArray)tag.func_74781_a("blockInfo"), blockStatePalette, compoundTagList));
        }
        for (NBTBase nbt : compound.func_150295_c("entityInfoList", 10)) {
            this.entityInfoList.add(new PreparableEntityInfo((NBTTagCompound)nbt));
        }
    }
}

