/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.core.configuration.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import net.jan.moddirector.core.ModDirector;
import net.jan.moddirector.core.configuration.InstallationPolicy;
import net.jan.moddirector.core.configuration.ModDirectorRemoteMod;
import net.jan.moddirector.core.configuration.RemoteModInformation;
import net.jan.moddirector.core.configuration.RemoteModMetadata;
import net.jan.moddirector.core.exception.ModDirectorException;
import net.jan.moddirector.core.manage.ProgressCallback;
import net.jan.moddirector.core.manage.check.StopModReposts;
import net.jan.moddirector.core.util.IOOperation;
import net.jan.moddirector.core.util.WebClient;
import net.jan.moddirector.core.util.WebGetResponse;

public class UrlRemoteMod
extends ModDirectorRemoteMod {
    private final String fileName;
    private final URL url;
    private final String[] follows;

    @JsonCreator
    public UrlRemoteMod(@JsonProperty(value="fileName") String fileName, @JsonProperty(value="url", required=true) URL url, @JsonProperty(value="follows") String[] follows, @JsonProperty(value="metadata") RemoteModMetadata metadata, @JsonProperty(value="installationPolicy") InstallationPolicy installationPolicy, @JsonProperty(value="options") Map<String, Object> options, @JsonProperty(value="folder") String folder, @JsonProperty(value="inject") Boolean inject) {
        super(metadata, installationPolicy, options, folder, inject);
        this.fileName = fileName;
        this.url = url;
        this.follows = follows == null ? new String[]{} : follows;
    }

    @Override
    public String remoteType() {
        return this.url.toExternalForm();
    }

    @Override
    public String offlineName() {
        return this.url.getFile().isEmpty() ? "<no name>" : this.url.getFile();
    }

    @Override
    public void performInstall(Path targetFile, ProgressCallback progressCallback, ModDirector director, RemoteModInformation information) throws ModDirectorException {
        byte[] data = null;
        progressCallback.setSteps(this.follows.length + 1);
        URL urlToFollow = null;
        for (int i = -1; i < this.follows.length; ++i) {
            if (i < 0) {
                urlToFollow = this.url;
            } else {
                char hrefEnclose;
                int hrefEnd;
                String html = new String(data);
                int startIndex = html.indexOf(this.follows[i]);
                if (startIndex < 0) {
                    throw new ModDirectorException("Unable to find follow string " + this.follows[i] + " in html from " + urlToFollow.toString());
                }
                int href = html.substring(0, startIndex).lastIndexOf("href=") + 5;
                String newUrl = html.substring(href + 1, hrefEnd = html.indexOf(hrefEnclose = html.charAt(href), href + 2));
                if (newUrl.isEmpty()) {
                    throw new ModDirectorException("Result url was empty when matching " + this.follows[i] + " in html from " + urlToFollow.toString());
                }
                try {
                    if (!newUrl.startsWith("http://") && !newUrl.startsWith("https://")) {
                        if (!newUrl.startsWith("/")) {
                            newUrl = "/" + newUrl;
                        }
                        urlToFollow = new URL(urlToFollow.getProtocol(), urlToFollow.getHost(), newUrl);
                    } else {
                        urlToFollow = new URL(newUrl);
                    }
                }
                catch (MalformedURLException e) {
                    throw new ModDirectorException("Failed to create follow url when using follow " + this.follows[i], e);
                }
            }
            if (i + 1 == this.follows.length) {
                progressCallback.message("Downloading final file");
            } else {
                progressCallback.message("Following redirect " + (i + 2) + " out of " + this.follows.length);
            }
            StopModReposts.check(ModDirector.getInstance(), urlToFollow);
            try (WebGetResponse response = WebClient.get(urlToFollow);){
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                IOOperation.copy(response.getInputStream(), outputStream, progressCallback, response.getStreamSize());
                data = outputStream.toByteArray();
            }
            catch (IOException e) {
                throw new ModDirectorException("Failed to follow URL's to download file", e);
            }
            progressCallback.step();
        }
        try {
            Files.write(targetFile, data, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ModDirectorException("Failed to write file to disk", e);
        }
        progressCallback.done();
    }

    @Override
    public RemoteModInformation queryInformation() {
        if (this.fileName != null) {
            return new RemoteModInformation(this.fileName, this.fileName);
        }
        String name = Paths.get(this.url.getFile(), new String[0]).getFileName().toString();
        return new RemoteModInformation(name, name);
    }
}

