/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.launchwrapper;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import net.jan.moddirector.core.ModDirector;
import net.jan.moddirector.core.logging.ModDirectorLogger;
import net.jan.moddirector.core.platform.ModDirectorPlatform;
import net.jan.moddirector.core.platform.PlatformSide;
import net.jan.moddirector.launchwrapper.LaunchwrapperModDirectorLogger;
import net.jan.moddirector.launchwrapper.ModDirectorTweaker;
import net.jan.moddirector.launchwrapper.SideDetermination;

public class LaunchwrapperModDirectorPlatform
implements ModDirectorPlatform {
    private final ModDirectorTweaker tweaker;
    private final SideDetermination sideDetermination;

    public LaunchwrapperModDirectorPlatform(ModDirectorTweaker tweaker) {
        this.tweaker = tweaker;
        this.sideDetermination = new SideDetermination();
    }

    @Override
    public String name() {
        return "Launchwrapper";
    }

    @Override
    public Path configurationDirectory() {
        File configDir = new File(this.tweaker.getGameDir(), "config/mod-director");
        if (!configDir.exists() && !configDir.mkdirs()) {
            throw new UncheckedIOException(new IOException("Failed to create config directory " + configDir.getAbsolutePath()));
        }
        return configDir.toPath();
    }

    @Override
    public Path modFile(String modFileName) {
        return this.tweaker.getGameDir().toPath().resolve("mods").resolve(modFileName);
    }

    @Override
    public Path customFile(String modFileName, String modFolderName) {
        return this.tweaker.getGameDir().toPath().resolve(modFolderName).resolve(modFileName);
    }

    @Override
    public Path rootFile(String modFileName) {
        return this.tweaker.getGameDir().toPath().resolve(modFileName);
    }

    @Override
    public Path installationRoot() {
        return this.tweaker.getGameDir().toPath();
    }

    @Override
    public ModDirectorLogger logger() {
        return new LaunchwrapperModDirectorLogger();
    }

    @Override
    public PlatformSide side() {
        return this.sideDetermination.get();
    }

    @Override
    public void bootstrap() {
        this.sideDetermination.determine(ModDirector.getInstance());
    }

    @Override
    public boolean headless() {
        return GraphicsEnvironment.isHeadless();
    }
}

