/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import net.soggymustache.bookworm.common.entity.data.Gender;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.entity.flying.EntityAndeanCondor;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderAndeanCondor
extends RenderLivingZAWA<EntityAndeanCondor>
implements IBabyModel<EntityAndeanCondor> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderAndeanCondor(RenderManager m) {
        super(m, (ModelBase)RenderConstants.ANDEAN_CONDOR, 0.7f);
        RenderConstants.ANDEAN_CONDOR.setAnimator(CondorAnimator::new);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityAndeanCondor e) {
        return ModuleManager.GENDER.getGender(e).equals((Object)Gender.MALE) ? CONTAINER.get(AbstractZawaLand.getVariant(e)) : CONTAINER.get("female", AbstractZawaLand.getVariant(e));
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityAndeanCondor entity) {
        return entity.func_70631_g_() ? CONTAINER.get("baby_blink", 0) : CONTAINER.get("blink", AbstractZawaLand.getVariant(entity));
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    protected void preRenderCallback(EntityAndeanCondor e, float partialTickTime) {
        super.preRenderCallback(e, partialTickTime);
        GlStateManager.func_179114_b((float)e.getPitchRotation(), (float)1.0f, (float)0.0f, (float)0.0f);
    }

    @Override
    public ModelBase getBabyModel() {
        return RenderConstants.ANDEAN_CONDOR_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityAndeanCondor e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/andean_condor/condor_1m.png");
        CONTAINER.addResource("textures/entity/andean_condor/condor_2m.png");
        CONTAINER.addResource("textures/entity/andean_condor/condor_3m.png");
        CONTAINER.addResource("textures/entity/andean_condor/condor_4m.png");
        CONTAINER.addResource("female", "textures/entity/andean_condor/condor_1f.png");
        CONTAINER.addResource("female", "textures/entity/andean_condor/condor_2f.png");
        CONTAINER.addResource("female", "textures/entity/andean_condor/condor_3f.png");
        CONTAINER.addResource("female", "textures/entity/andean_condor/condor_4f.png");
        CONTAINER.addResource("baby", "textures/entity/andean_condor/condor_baby.png");
        CONTAINER.addResource("blink", "textures/entity/andean_condor/condor_blink_1.png");
        CONTAINER.addResource("blink", "textures/entity/andean_condor/condor_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/andean_condor/condor_blink_3.png");
        CONTAINER.addResource("blink", "textures/entity/andean_condor/condor_blink_4.png");
        CONTAINER.addResource("baby_blink", "textures/entity/andean_condor/condor_blink_baby.png");
    }

    public static class CondorAnimator
    extends ZAWAAnimator<EntityAndeanCondor> {
        protected final BookwormModelRenderer Jaw = this.getModel().getPartFromRig("Jaw");
        protected final BookwormModelRenderer Neck = this.getModel().getPartFromRig("Neck");
        protected final BookwormModelRenderer Body = this.getModel().getPartFromRig("Body");
        protected final BookwormModelRenderer LegLeft = this.getModel().getPartFromRig("LegLeft");
        protected final BookwormModelRenderer LegRight = this.getModel().getPartFromRig("LegRight");
        protected final BookwormModelRenderer Wing1Left = this.getModel().getPartFromRig("Wing1Left");
        protected final BookwormModelRenderer Wing2Left = this.getModel().getPartFromRig("Wing2Left");
        protected final BookwormModelRenderer Wing1Right = this.getModel().getPartFromRig("Wing1Right");
        protected final BookwormModelRenderer Wing2Right = this.getModel().getPartFromRig("Wing2Right");
        protected final BookwormModelRenderer Tail1 = this.getModel().getPartFromRig("Tail1");
        protected final BookwormModelRenderer Tail2 = this.getModel().getPartFromRig("Tail2");
        protected final BookwormModelRenderer FootLeft = this.getModel().getPartFromRig("FootLeft");
        protected final BookwormModelRenderer FootRight = this.getModel().getPartFromRig("FootRight");
        protected final BookwormModelRenderer Head = this.getModel().getPartFromRig("Head");
        protected final BookwormModelRenderer WingFoldedRight = this.getModel().getPartFromRig("WingFoldedRight");
        protected final BookwormModelRenderer WingFoldedLeft = this.getModel().getPartFromRig("WingFoldedLeft");
        protected final BookwormModelRenderer Chest = this.getModel().getPartFromRig("Chest");
        protected final BookwormModelRenderer Neck2 = this.getModel().getPartFromRig("Neck2");
        protected final BookwormModelRenderer TailBase = this.getModel().getPartFromRig("TailBase");
        protected final BookwormModelRenderer ThighLeft = this.getModel().getPartFromRig("ThighLeft");
        protected final BookwormModelRenderer ThighRight = this.getModel().getPartFromRig("ThighRight");
        protected final BookwormModelRenderer Neck1 = this.getModel().getPartFromRig("Neck1");

        public CondorAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityAndeanCondor entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.speed = 1.4f;
            this.degree = 1.9f;
            if (!entity.field_70122_E && !entity.func_184218_aH()) {
                this.Wing1Left.renderPartScale = 1.0f;
                this.Wing1Right.renderPartScale = 1.0f;
                this.WingFoldedRight.renderPartScale = 0.0f;
                this.WingFoldedLeft.renderPartScale = 0.0f;
                this.degree = 1.0f;
                this.getModel().loadPosedModel((BookwormModelBase)RenderConstants.ANDEAN_CONDOR_FLYING);
                f = entity.field_70173_aa;
                f1 = 0.2f;
                this.speed = 1.0f;
                this.Chest.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * 0.06f) * f1 * 0.5f + 1.3f;
                this.Neck2.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * -0.2f) * f1 * 0.5f + -1.7f;
                this.Body.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.07f + (float)Math.PI)) * (this.degree * -0.04f) * f1 * 0.5f + 1.55f;
                this.Wing1Left.field_78796_g = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.05f + (float)Math.PI)) * (this.degree * 0.25f) * f1 * 0.5f;
                this.Wing1Right.field_78796_g = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.05f + (float)Math.PI)) * (this.degree * -0.25f) * f1 * 0.5f;
                this.Wing2Left.field_78808_h = MathHelper.func_76134_b((float)(3.0f + f * this.speed * 0.05f + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f + -0.1f;
                this.Wing2Right.field_78808_h = MathHelper.func_76134_b((float)(3.0f + f * this.speed * 0.05f + (float)Math.PI)) * (this.degree * -0.2f) * f1 * 0.5f + 0.1f;
                this.TailBase.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f + -0.25f;
                this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f + -0.3f;
                this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f + -0.3f;
            } else {
                this.speed = 0.7f;
                this.Wing1Left.renderPartScale = 0.0f;
                this.Wing1Right.renderPartScale = 0.0f;
                this.WingFoldedRight.renderPartScale = 1.0f;
                this.WingFoldedLeft.renderPartScale = 1.0f;
                this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 2.0f) * f1 * 0.5f + -1.0f;
                this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 2.0f) * f1 * 0.5f + -0.25f;
                this.FootLeft.field_78795_f = MathHelper.func_76134_b((float)(5.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.5f) * f1 * 0.5f + 0.08f;
                this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -2.0f) * f1 * 0.5f + -1.0f;
                this.LegRight.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -2.0f) * f1 * 0.5f + -0.25f;
                this.FootRight.field_78795_f = MathHelper.func_76134_b((float)(5.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.5f) * f1 * 0.5f + 0.08f;
                this.Body.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * -0.05f) * f1 * 0.5f + 1.19f;
                this.Body.field_82908_p = MathHelper.func_76134_b((float)(f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * 0.01f) * f1 * 0.5f;
                this.Chest.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * 0.06f) * f1 * 0.5f + 0.9f;
                this.Neck1.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f + -0.3f;
            }
        }

        @Override
        protected void performIdleAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityAndeanCondor entity) {
            super.performIdleAnimation(f, f1, f2, f3, f4, f5, entity);
            this.Chest.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * 0.02f) * f1 * 0.5f + 0.85f;
            this.Neck1.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * -0.1f) * f1 * 0.5f + -0.3f;
        }
    }
}

