/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityBeaver;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderBeaver
extends RenderLivingZAWA<EntityBeaver>
implements IBabyModel<EntityBeaver> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderBeaver(RenderManager m) {
        super(m, (ModelBase)RenderConstants.BEAVER, 0.3f);
        RenderConstants.BEAVER.setAnimator(BeaverAnimator::new);
        this.func_177094_a(new LayerBeaverHeldItem(this));
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    protected void preRenderCallback(EntityBeaver b, float partialTickTime) {
        GlStateManager.func_179109_b((float)0.0f, (float)-0.05f, (float)0.1f);
        if (b.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.65f, (float)0.65f, (float)0.65f);
        } else {
            GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
        }
        super.preRenderCallback(b, partialTickTime);
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityBeaver entity) {
        return entity.func_70631_g_() ? CONTAINER.get("blink", 1) : CONTAINER.get("blink", 0);
    }

    protected ResourceLocation getEntityTexture(EntityBeaver entity) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(entity));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.BEAVER_BABY.setAnimator(BeaverAnimator::new);
        return RenderConstants.BEAVER_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityBeaver e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/beaver/beaver_1.png");
        CONTAINER.addResource("textures/entity/beaver/beaver_2.png");
        CONTAINER.addResource("textures/entity/beaver/beaver_3.png");
        CONTAINER.addResource("baby", "textures/entity/beaver/beaver_baby.png");
        CONTAINER.addResource("blink", "textures/entity/beaver/beaver_blink_123.png");
        CONTAINER.addResource("blink", "textures/entity/beaver/beaver_blink_baby.png");
    }

    public static class BeaverAnimator
    extends ZAWAAnimator<EntityBeaver> {
        private final BookwormModelRenderer Body = this.getModel().getPartByName("Body");
        private final BookwormModelRenderer Neck = this.getModel().getPartByName("Neck");
        private final BookwormModelRenderer Mouth = this.getModel().getPartByName("Mouth");
        private final BookwormModelRenderer ArmBaseLeft = this.getModel().getPartByName("ArmBaseLeft");
        private final BookwormModelRenderer ArmLeft = this.getModel().getPartByName("ArmLeft");
        private final BookwormModelRenderer HandLeft = this.getModel().getPartByName("HandLeft");
        private final BookwormModelRenderer ArmBaseRight = this.getModel().getPartByName("ArmBaseRight");
        private final BookwormModelRenderer ArmRight = this.getModel().getPartByName("ArmRight");
        private final BookwormModelRenderer HandRight = this.getModel().getPartByName("HandRight");
        private final BookwormModelRenderer ThighLeft = this.getModel().getPartByName("ThighLeft");
        private final BookwormModelRenderer LegLeft = this.getModel().getPartByName("LegLeft");
        private final BookwormModelRenderer FootLeft = this.getModel().getPartByName("FootLeft");
        private final BookwormModelRenderer ThighRight = this.getModel().getPartByName("ThighRight");
        private final BookwormModelRenderer LegRight = this.getModel().getPartByName("LegRight");
        private final BookwormModelRenderer FootRight = this.getModel().getPartByName("FootRight");
        private final BookwormModelRenderer Tail = this.getModel().getPartByName("Tail");

        public BeaverAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityBeaver entity) {
            this.neck_part = this.Neck;
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.speed = entity.func_70631_g_() ? 2.0f : 4.4f;
            this.degree = 0.4f;
            this.Neck.field_78795_f = f4 / 57.295776f + (entity.func_70631_g_() ? 0.0f : 1.6f);
            this.Neck.field_78796_g = f3 / 57.295776f;
            this.Body.field_82908_p = MathHelper.func_76134_b((float)(f * (0.3162f * this.speed) + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f - 0.06f;
            this.Tail.field_78808_h = MathHelper.func_76134_b((float)(10.0f + f * (0.1162f * this.speed) + (float)Math.PI)) * (this.degree * 0.4f) * f1 * 0.5f;
            this.Neck.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.2962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f + (entity.func_70631_g_() ? 0.0f : 1.6f);
            this.Mouth.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f - 0.2f;
            this.ArmBaseRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + 0.05f;
            this.ArmBaseRight.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.1f) * f1 * 0.5f - 0.1f;
            this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.0f;
            this.HandRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            this.ArmBaseLeft.field_82908_p = -MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + 0.05f;
            this.ArmBaseLeft.field_78795_f = -MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.1f) * f1 * 0.5f - 0.1f;
            this.ArmLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.0f;
            this.HandLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            this.ThighRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + 0.02f;
            this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (-this.degree * 1.3f) * f1 * 0.5f + 0.0f;
            this.LegRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (-this.degree * 1.3f) * f1 * 0.5f + 0.0f;
            this.FootRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (-this.degree * 0.4f) * f1 * 0.5f - 0.0f;
            this.ThighLeft.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + 0.02f;
            this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (this.degree * 1.3f) * f1 * 0.5f + 0.0f;
            this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (this.degree * 1.3f) * f1 * 0.5f + 0.0f;
            this.FootLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (this.degree * 0.4f) * f1 * 0.5f - 0.0f;
        }
    }

    public static class LayerBeaverHeldItem
    implements LayerRenderer<EntityBeaver> {
        private final RenderBeaver RENDER;

        public LayerBeaverHeldItem(RenderBeaver render) {
            this.RENDER = render;
        }

        public void doRenderLayer(EntityBeaver beaver, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (beaver.func_184586_b(EnumHand.MAIN_HAND) != ItemStack.field_190927_a) {
                ItemStack stack = beaver.func_184586_b(EnumHand.MAIN_HAND);
                stack.func_190920_e(1);
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)120.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)-40.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
                if (stack.func_77973_b() != Items.field_151055_y) {
                    GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.0f, (float)-2.5f);
                }
                GlStateManager.func_179109_b((float)0.0f, (float)-0.0f, (float)-1.1f);
                Minecraft.func_71410_x().func_175597_ag().func_178099_a((EntityLivingBase)beaver, stack, ItemCameraTransforms.TransformType.NONE);
                GlStateManager.func_179121_F();
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

