/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.CMFRig;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.RenderPolarBear;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.configuration.ZAWAConfig;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityAfricanLion;
import org.zawamod.entity.land.EntityAmericanBison;
import org.zawamod.entity.land.EntityBengalTiger;
import org.zawamod.entity.land.EntityNileHippo;
import org.zawamod.util.RenderConstants;
import org.zawamod.util.RenderInfo;
import org.zawamod.util.ZAWAUtils;

@SideOnly(value=Side.CLIENT)
public class RenderBengalTiger
extends RenderLivingZAWA<EntityBengalTiger>
implements IBabyModel<EntityBengalTiger> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");
    public static final RenderInfo INFO = new RenderInfo(EntityBengalTiger.class, CONTAINER, "bengal_tiger", RenderConstants.BENGAL_TIGER, RenderConstants.TIGER_SLEEPING, RenderConstants.BENGAL_TIGER_BABY, RenderConstants.TIGER_BABY_SLEEPING);

    public RenderBengalTiger(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.BENGAL_TIGER, 0.6f);
        RenderConstants.BENGAL_TIGER.setRig(new CMFRig(RenderConstants.BENGAL_TIGER, new ResourceLocation("zawa", "models/entity/bengal_tiger/tiger.rig")));
        RenderConstants.BENGAL_TIGER.setAnimator(TigerAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    protected void preRenderCallback(EntityBengalTiger tiger, float partialTickTime) {
        super.preRenderCallback(tiger, partialTickTime);
        GlStateManager.func_179109_b((float)0.0f, (float)0.05f, (float)-0.2f);
        if (tiger.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.1f, (float)0.16f);
            if (tiger.isAsleep()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.0f, (float)0.0f);
            }
        }
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityBengalTiger entity) {
        if (entity.func_70631_g_()) {
            if (AbstractZawaLand.getVariant(entity) == 1) {
                return CONTAINER.get("blink", 2);
            }
            return CONTAINER.get("blink", 3);
        }
        if (AbstractZawaLand.getVariant(entity) == 1) {
            return CONTAINER.get("blink", 0);
        }
        return CONTAINER.get("blink", 1);
    }

    protected ResourceLocation getEntityTexture(EntityBengalTiger animal) {
        return this.getTextureOfVar(animal);
    }

    @Override
    public ResourceLocation getTextureOfVar(EntityBengalTiger e) {
        return CONTAINER.get(AbstractZawaLand.getVariant(e));
    }

    @Override
    public ModelBase getBabyModel() {
        return RenderConstants.BENGAL_TIGER_BABY.setAnimator(BabyTigerAnimator::new);
    }

    @Override
    public ResourceLocation getBabyTexture(EntityBengalTiger e) {
        return CONTAINER.get("baby", AbstractZawaLand.getVariant(e));
    }

    static {
        CONTAINER.addResource("baby", "textures/entity/bengal_tiger/bengal_tiger_baby_1.png");
        CONTAINER.addResource("baby", "textures/entity/bengal_tiger/bengal_tiger_baby_2.png");
        CONTAINER.addResource("baby", "textures/entity/bengal_tiger/bengal_tiger_baby_3.png");
        CONTAINER.addResource("baby", "textures/entity/bengal_tiger/bengal_tiger_baby_4.png");
        CONTAINER.addResource("baby", "textures/entity/bengal_tiger/bengal_tiger_baby_5.png");
        CONTAINER.addResource("baby", "textures/entity/bengal_tiger/bengal_tiger_baby_6.png");
        CONTAINER.addResource("blink", "textures/entity/bengal_tiger/bengal_tiger_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/bengal_tiger/bengal_tiger_blink_1_36.png");
        CONTAINER.addResource("blink", "textures/entity/bengal_tiger/bengal_tiger_baby_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/bengal_tiger/bengal_tiger_baby_blink_1_36.png");
    }

    public static class BabyTigerAnimator
    extends ZAWAAnimator<AbstractZawaLand> {
        private final BookwormModelRenderer tight1 = this.getModel().getPartByName("tight1");
        private final BookwormModelRenderer tight2 = this.getModel().getPartByName("tight2");
        private final BookwormModelRenderer tight4 = this.getModel().getPartByName("tight4");
        private final BookwormModelRenderer tight3 = this.getModel().getPartByName("tight3");
        private final BookwormModelRenderer neck = this.getModel().getPartByName("neck");

        public BabyTigerAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, AbstractZawaLand entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.tight1.field_78795_f = MathHelper.func_76134_b((float)(f * 0.333f + (float)Math.PI)) * 1.4f * f1;
            this.tight2.field_78795_f = MathHelper.func_76134_b((float)(f * 0.333f)) * 1.4f * f1;
            this.tight4.field_78795_f = MathHelper.func_76134_b((float)(f * 0.333f + (float)Math.PI)) * 1.4f * f1;
            this.tight3.field_78795_f = MathHelper.func_76134_b((float)(f * 0.333f)) * 1.4f * f1;
            this.neck.field_78795_f = f4 / 57.295776f - 0.1f;
            this.neck.field_78796_g = f3 / 57.295776f;
        }
    }

    public static class TigerAnimator
    extends ZAWAAnimator<AbstractZawaLand> {
        protected final BookwormModelRenderer Body = this.getModel().getPartFromRig("Body");
        protected final BookwormModelRenderer neck = this.getModel().getPartFromRig("Neck");
        protected final BookwormModelRenderer tail2 = this.getModel().getPartFromRig("Tail2");
        protected final BookwormModelRenderer tail1 = this.getModel().getPartFromRig("Tail1");
        protected final BookwormModelRenderer mouth = this.getModel().getPartFromRig("Mouth");
        protected final BookwormModelRenderer ArmBaseRight = this.getModel().getPartFromRig("ArmBaseRight");
        protected final BookwormModelRenderer ArmRight = this.getModel().getPartFromRig("ArmRight");
        protected final BookwormModelRenderer HandRight = this.getModel().getPartFromRig("HandRight");
        protected final BookwormModelRenderer ArmBaseLeft = this.getModel().getPartFromRig("ArmBaseLeft");
        protected final BookwormModelRenderer ArmLeft = this.getModel().getPartFromRig("ArmLeft");
        protected final BookwormModelRenderer HandLeft = this.getModel().getPartFromRig("HandLeft");
        protected final BookwormModelRenderer ThighRight = this.getModel().getPartFromRig("ThighRight");
        protected final BookwormModelRenderer UpperLegRight = this.getModel().getPartFromRig("UpperLegRight");
        protected final BookwormModelRenderer LegRight = this.getModel().getPartFromRig("LegRight");
        protected final BookwormModelRenderer FootRight = this.getModel().getPartFromRig("FootRight");
        protected final BookwormModelRenderer ThighLeft = this.getModel().getPartFromRig("ThighLeft");
        protected final BookwormModelRenderer UpperLegLeft = this.getModel().getPartFromRig("UpperLegLeft");
        protected final BookwormModelRenderer LegLeft = this.getModel().getPartFromRig("LegLeft");
        protected final BookwormModelRenderer FootLeft = this.getModel().getPartFromRig("FootLeft");
        protected final BookwormModelRenderer ForearmLeft = this.getModel().getPartFromRig("ForearmLeft");
        protected final BookwormModelRenderer ForearmRight = this.getModel().getPartFromRig("ForearmRight");
        protected final BookwormModelRenderer head = this.getModel().getPartFromRig("head");
        protected final BookwormModelRenderer Abdomen = this.getModel().getPartFromRig("Abdomen");
        protected final BookwormModelRenderer Hips = this.getModel().getPartFromRig("Hips");
        protected final BookwormModelRenderer Chest = this.getModel().getPartFromRig("Chest");
        protected float extraWeight = 0.0f;
        protected float pressure = 0.0f;
        protected float weightA;
        public float neckWeight = 0.2f;
        public boolean setSpeed = true;

        public TigerAnimator(ModelCMF model, float extraWeight, float pressure) {
            this(model);
            this.extraWeight = extraWeight;
            this.pressure = pressure;
        }

        public TigerAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, AbstractZawaLand entity) {
            this.jaw_part = this.mouth;
            this.neck_part = this.neck;
            this.tail_part = this.tail1;
            if (this.setSpeed) {
                this.degree = 0.6f;
                this.speed = 3.4f;
                if (entity instanceof EntityAmericanBison) {
                    this.speed = 3.9f;
                    if (entity.func_184207_aI()) {
                        this.degree = 1.0f;
                        this.speed = 1.3f;
                    }
                }
                if (entity instanceof EntityNileHippo) {
                    this.speed = 4.0f;
                    this.degree = -0.7f;
                }
                if (entity.func_70631_g_()) {
                    this.speed = 2.0f;
                }
            }
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.Body.field_82908_p = MathHelper.func_76134_b((float)(f * (0.3162f * this.speed) + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f;
            this.tail1.field_78808_h = MathHelper.func_76134_b((float)(10.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.8f) * f1 * 0.5f;
            this.tail2.field_78808_h = MathHelper.func_76134_b((float)(21.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.9f) * f1 * 0.5f;
            this.neck.field_78795_f = entity instanceof EntityAfricanLion ? MathHelper.func_76134_b((float)(20.0f - f * (0.2962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f - 0.0f : MathHelper.func_76134_b((float)(20.0f - f * (0.2962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f - this.neckWeight;
            this.mouth.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f - 0.0f;
            this.ArmBaseRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f - 0.05f;
            this.ArmBaseRight.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 1.8f) * f1 * 0.5f + 0.1f - this.extraWeight;
            this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.0f;
            this.HandRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            this.ArmBaseLeft.field_82908_p = -MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f - 0.05f;
            this.ArmBaseLeft.field_78795_f = -MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 1.8f) * f1 * 0.5f + 0.1f - this.extraWeight;
            this.ArmLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.0f;
            this.HandLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            this.ThighRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + this.pressure;
            this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.1f) * f1 * 0.5f - 0.1f + this.extraWeight;
            this.UpperLegRight.field_78795_f = MathHelper.func_76134_b((float)(90.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.9f + this.weightA;
            this.LegRight.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f - 0.9f;
            this.FootRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            this.ThighLeft.field_82908_p = -MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + this.pressure;
            this.ThighLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.1f) * f1 * 0.5f - 0.1f + this.extraWeight;
            this.UpperLegLeft.field_78795_f = -MathHelper.func_76134_b((float)(90.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.9f + this.weightA;
            this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f - 0.9f;
            this.FootLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            if (entity.func_70090_H() && !(this.getModel().getAnimator() instanceof RenderPolarBear.PolarBearAnimator)) {
                f = entity.field_70173_aa;
                f1 = 0.24f;
                this.speed = 2.0f;
                this.degree = 1.0f;
                this.tail1.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.0f + (float)Math.PI)) * (this.degree * 0.0f) * f1 * 0.5f + 1.0f;
                this.tail1.field_78796_g = MathHelper.func_76134_b((float)(f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * 2.0f) * f1 * 0.5f;
                this.tail2.field_78796_g = MathHelper.func_76134_b((float)(5.0f + f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * 2.0f) * f1 * 0.5f;
                this.ArmBaseLeft.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * 2.5f) * f1 * 0.5f + 0.1f;
                if (!(entity instanceof EntityNileHippo)) {
                    this.ArmLeft.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * 2.0f) * f1 * 0.5f + -0.4f;
                    this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * -2.0f) * f1 * 0.5f + -0.4f;
                }
                this.ForearmLeft.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * 1.0f) * f1 * 0.5f + 0.05f;
                this.HandLeft.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * 2.0f) * f1 * 0.5f + 0.4f;
                this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * -2.0f) * f1 * 0.5f;
                this.UpperLegLeft.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * 1.0f) * f1 * 0.5f + 0.55f;
                this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * 0.5f) * f1 * 0.5f + -0.5f;
                this.FootLeft.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * 2.0f) * f1 * 0.5f + 0.2f;
                this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * 2.0f) * f1 * 0.5f;
                this.UpperLegRight.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * -1.0f) * f1 * 0.5f + 0.55f;
                this.LegRight.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * -0.5f) * f1 * 0.5f + -0.5f;
                this.FootRight.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * -2.0f) * f1 * 0.5f + 0.2f;
                this.ArmBaseRight.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * -2.5f) * f1 * 0.5f + 0.1f;
                this.ForearmRight.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * -1.0f) * f1 * 0.5f + 0.05f;
                this.HandRight.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * -2.0f) * f1 * 0.5f + 0.4f;
                this.neck.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f - this.neckWeight;
                this.head.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f + 0.4f;
            } else if (entity.isRunning()) {
                this.speed = 4.0f;
                this.degree = 0.3f;
                this.ArmBaseLeft.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 4.6f) * f1 * 0.5f + 0.1f;
                this.ArmLeft.field_78795_f = MathHelper.func_76134_b((float)(5.5f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -3.9f) * f1 * 0.5f + -0.3f;
                this.ForearmLeft.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 3.0f) * f1 * 0.5f + 0.2f;
                this.HandLeft.field_78795_f = MathHelper.func_76134_b((float)(11.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 3.0f) * f1 * 0.5f + 0.3f;
                this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(5.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -3.7f) * f1 * 0.5f + -0.1f;
                this.UpperLegLeft.field_78795_f = MathHelper.func_76134_b((float)(4.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -2.3f) * f1 * 0.5f + 0.6f;
                this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(6.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -4.0f) * f1 * 0.5f + -0.6f;
                this.ArmBaseRight.field_78795_f = MathHelper.func_76134_b((float)(-1.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 4.6f) * f1 * 0.5f + 0.1f;
                this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(10.5f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -3.9f) * f1 * 0.5f + -0.3f;
                this.ForearmRight.field_78795_f = MathHelper.func_76134_b((float)(5.5f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 3.0f) * f1 * 0.5f + 0.2f;
                this.HandRight.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 3.0f) * f1 * 0.5f + 0.3f;
                this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(4.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -3.7f) * f1 * 0.5f + -0.1f;
                this.UpperLegRight.field_78795_f = MathHelper.func_76134_b((float)(9.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -2.3f) * f1 * 0.5f + 0.6f;
                this.LegRight.field_78795_f = MathHelper.func_76134_b((float)(4.5f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -4.0f) * f1 * 0.5f + -0.6f;
                this.Abdomen.field_78795_f = MathHelper.func_76134_b((float)(8.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -0.1f) * f1 * 0.5f + 0.04f;
                this.Hips.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.4f) * f1 * 0.5f + -0.3f;
                this.tail1.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.0f) * f1 * 0.5f + 0.8f;
                this.tail2.field_78795_f = MathHelper.func_76134_b((float)(5.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.7f) * f1 * 0.5f + 0.4f;
                this.neck.field_78795_f = MathHelper.func_76134_b((float)(9.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.5f) * f1 * 0.5f - this.neckWeight;
                this.head.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.6f) * f1 * 0.5f + 0.1f;
                this.Body.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f + -0.02f;
                this.mouth.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f + 0.1f;
            }
            if (entity instanceof EntityAfricanLion) {
                this.neck.field_78795_f = f4 / 57.295776f + 0.2f;
                this.neck.field_78796_g = f3 / 57.295776f;
            } else {
                this.neck.field_78795_f = f4 / 57.295776f - this.neckWeight;
                this.neck.field_78796_g = f3 / 57.295776f;
                if (this.neck.field_78796_g > 0.5f) {
                    this.neck.field_78796_g = 0.5f;
                } else if (this.neck.field_78796_g < -0.5f) {
                    this.neck.field_78796_g = -0.5f;
                }
            }
            if (!ZAWAUtils.isEntityMoving((Entity)entity) && ZAWAConfig.clientOptions.livingAnimations) {
                f = entity.field_70173_aa;
                f1 = 0.1f;
                this.degree = 1.0f;
                this.speed = 0.3f;
                this.neck.field_78795_f = entity instanceof EntityAfricanLion ? MathHelper.func_76134_b((float)(20.0f - f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f - 0.0f : MathHelper.func_76134_b((float)(20.0f - f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f - this.neckWeight;
            }
        }
    }
}

