/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityBlackSpiderMonkey;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderBlackSpiderMonkey
extends RenderLivingZAWA<EntityBlackSpiderMonkey>
implements IBabyModel<EntityBlackSpiderMonkey> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderBlackSpiderMonkey(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.SPIDER_MONKEY, 0.4f);
        RenderConstants.SPIDER_MONKEY.setAnimator(MonkeyAnimator::new);
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityBlackSpiderMonkey entity) {
        if (entity.func_70631_g_()) {
            return CONTAINER.get("blink", 2);
        }
        if (AbstractZawaLand.getVariant(entity) == 1) {
            return CONTAINER.get("blink", 1);
        }
        return CONTAINER.get("blink", 0);
    }

    protected ResourceLocation getEntityTexture(EntityBlackSpiderMonkey animal) {
        return this.getTextureOfVar(animal);
    }

    @Override
    protected void preRenderCallback(EntityBlackSpiderMonkey entitylivingbaseIn, float partialTickTime) {
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
        GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
        GlStateManager.func_179109_b((float)0.0f, (float)-0.15f, (float)0.0f);
        if (entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179139_a((double)0.7, (double)0.7, (double)0.7);
        }
        if (entitylivingbaseIn.isAsleep()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.1f, (float)0.0f);
        }
    }

    @Override
    public ResourceLocation getTextureOfVar(EntityBlackSpiderMonkey e) {
        return CONTAINER.get(AbstractZawaLand.getVariant(e));
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.SPIDER_MONKEY_BABY.setAnimator(MonkeyAnimator::new);
        return RenderConstants.SPIDER_MONKEY_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityBlackSpiderMonkey e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/black_spider_monkey/black_spider_monkey.png");
        CONTAINER.addResource("textures/entity/black_spider_monkey/black_spider_monkey_2.png");
        CONTAINER.addResource("textures/entity/black_spider_monkey/black_spider_monkey_3.png");
        CONTAINER.addResource("textures/entity/black_spider_monkey/black_spider_monkey_4.png");
        CONTAINER.addResource("baby", "textures/entity/black_spider_monkey/black_spider_monkey_baby.png");
        CONTAINER.addResource("blink", "textures/entity/black_spider_monkey/black_spider_monkey_blink_1_3_4.png");
        CONTAINER.addResource("blink", "textures/entity/black_spider_monkey/black_spider_monkey_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/black_spider_monkey/black_spider_monkey_baby_blink.png");
    }

    private static class MonkeyAnimator
    extends ZAWAAnimator<EntityBlackSpiderMonkey> {
        private final BookwormModelRenderer ThighLeft = this.getModel().getPartByName("Thigh Left");
        private final BookwormModelRenderer ThighRight = this.getModel().getPartByName("Thigh Right");
        private final BookwormModelRenderer ArmBaseRight = this.getModel().getPartByName("Arm Base Right");
        private final BookwormModelRenderer ArmLeftBase = this.getModel().getPartByName("Arm Left Base");
        private final BookwormModelRenderer Neck = this.getModel().getPartByName("Neck");
        private final BookwormModelRenderer Tail = this.getModel().getPartByName("Tail");

        public MonkeyAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityBlackSpiderMonkey entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.speed = 2.3f;
            this.degree = 1.1f;
            this.Neck.field_78795_f = f4 / 57.295776f - 0.1f;
            this.Neck.field_78808_h = f3 / 57.295776f;
            this.Neck.field_78795_f = MathHelper.func_76134_b((float)(23.0f + f * (0.1462f * this.speed) + (float)Math.PI)) * (this.degree * -0.2f) * f1 * 0.5f - 0.5f;
            this.Tail.field_78795_f = MathHelper.func_76134_b((float)(12.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.05f) * f1 * 0.5f;
            this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.6f) * f1 * 0.5f - 1.4f;
            this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * -0.6f) * f1 * 0.5f - 1.4f;
            this.ArmBaseRight.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.6f) * f1 * 0.5f - 1.4f;
            this.ArmLeftBase.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * -0.6f) * f1 * 0.5f - 1.4f;
        }

        @Override
        protected void performIdleAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityBlackSpiderMonkey entity) {
            super.performIdleAnimation(f, f1, f2, f3, f4, f5, entity);
            this.Neck.field_78795_f = MathHelper.func_76134_b((float)(23.0f + f * (0.0462f * this.speed) + (float)Math.PI)) * (this.degree * -0.2f) * f1 * 0.5f - 0.5f;
            this.Tail.field_78795_f = MathHelper.func_76134_b((float)(12.0f + f * (0.0662f * this.speed) + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f;
        }
    }
}

