/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.water.EntityCichlid;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderCichlid
extends RenderLivingZAWA<EntityCichlid> {
    public static final ResourceLocation CICHLID1 = new ResourceLocation("zawa", "textures/entity/cichlid/cichlid_1.png");
    public static final ResourceLocation CICHLID2 = new ResourceLocation("zawa", "textures/entity/cichlid/cichlid_2.png");
    public static final ResourceLocation CICHLID3 = new ResourceLocation("zawa", "textures/entity/cichlid/cichlid_3.png");
    public static final ResourceLocation CICHLID4 = new ResourceLocation("zawa", "textures/entity/cichlid/cichlid_4.png");
    public static final ResourceLocation CICHLID5 = new ResourceLocation("zawa", "textures/entity/cichlid/cichlid_5.png");

    public RenderCichlid(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.CICHLID, 0.1f);
        RenderConstants.CICHLID.setAnimator(CichlidAnimator::new);
    }

    @Override
    public boolean canBlink() {
        return false;
    }

    @Override
    protected void preRenderCallback(EntityCichlid entitylivingbaseIn, float partialTickTime) {
        GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
        if (!entitylivingbaseIn.func_70090_H()) {
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)-0.2f, (float)0.3f, (float)0.1f);
        }
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityCichlid animal) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(animal));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        switch (varient) {
            default: {
                return CICHLID1;
            }
            case 1: {
                return CICHLID2;
            }
            case 2: {
                return CICHLID3;
            }
            case 3: {
                return CICHLID4;
            }
            case 4: 
        }
        return CICHLID5;
    }

    public static class CichlidAnimator
    extends ZAWAAnimator<EntityCichlid> {
        private final BookwormModelRenderer Body = this.getModel().getPartByName("body");
        private final BookwormModelRenderer Head = this.getModel().getPartByName("head");
        private final BookwormModelRenderer TailBase = this.getModel().getPartByName("tail1");
        private final BookwormModelRenderer Tail = this.getModel().getPartByName("tailFin");
        private final BookwormModelRenderer Jaw = this.getModel().getPartByName("jaw");
        private final BookwormModelRenderer FinLeft = this.getModel().getPartByName("finpecLeft");
        private final BookwormModelRenderer FinRight = this.getModel().getPartByName("finpecRight");

        public CichlidAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityCichlid entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            f = entity.field_70173_aa;
            f1 = 0.3f;
            float speed = 3.4f;
            float degree = 2.1f;
            this.Body.field_78795_f = MathHelper.func_76134_b((float)(23.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.04f) * f1 * 0.5f;
            this.Head.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.1f) * f1 * 0.5f - 0.9f;
            this.TailBase.field_78795_f = MathHelper.func_76134_b((float)(-3.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.1f) * f1 * 0.5f;
            this.Tail.field_78796_g = MathHelper.func_76134_b((float)(f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.4f) * f1 * 0.5f;
            this.Jaw.field_78795_f = MathHelper.func_76134_b((float)(23.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.3f) * f1 * 0.5f - 0.0f;
            this.FinLeft.field_78796_g = MathHelper.func_76134_b((float)(23.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.3f) * f1 * 0.5f + 0.2f;
            this.FinRight.field_78796_g = MathHelper.func_76134_b((float)(23.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * -0.3f) * f1 * 0.5f - 0.2f;
        }
    }
}

