/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.render.entity.RenderTasmanianDevil;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityEchidna;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderEchidna
extends RenderLivingZAWA<EntityEchidna>
implements IBabyModel<EntityEchidna> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderEchidna(RenderManager m) {
        super(m, (ModelBase)RenderConstants.ECHIDNA.setAnimator(RenderTasmanianDevil.TasmanianAnimator::new), 0.3f);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityEchidna entity) {
        if (entity.func_70631_g_()) {
            return CONTAINER.get("blink", 3);
        }
        return CONTAINER.get("blink", AbstractZawaLand.getVariant(entity));
    }

    @Override
    protected void preRenderCallback(EntityEchidna e, float partialTickTime) {
        GlStateManager.func_179109_b((float)0.0f, (float)-0.12f, (float)0.0f);
        if (e.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.1f, (float)-0.1f);
        } else {
            GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
        }
        super.preRenderCallback(e, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityEchidna entity) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(entity));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.ECHIDNA_BABY.setAnimator(RenderTasmanianDevil.TasmanianAnimator::new);
        return RenderConstants.ECHIDNA_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityEchidna e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/echidna/long_beaked_echidna_1.png");
        CONTAINER.addResource("textures/entity/echidna/long_beaked_echidna_2.png");
        CONTAINER.addResource("textures/entity/echidna/long_beaked_echidna_3.png");
        CONTAINER.addResource("baby", "textures/entity/echidna/long_beaked_echidna_baby.png");
        CONTAINER.addResource("blink", "textures/entity/echidna/echidna_blink_1.png");
        CONTAINER.addResource("blink", "textures/entity/echidna/echidna_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/echidna/echidna_blink_3.png");
        CONTAINER.addResource("blink", "textures/entity/echidna/echidna_blink_baby.png");
    }
}

