/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import net.soggymustache.bookworm.common.entity.data.Gender;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.entity.flying.EntityFrigate;
import org.zawamod.util.RenderConstants;
import org.zawamod.util.ZAWAUtils;

@SideOnly(value=Side.CLIENT)
public class RenderFrigate
extends RenderLivingZAWA<EntityFrigate>
implements IBabyModel<EntityFrigate> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderFrigate(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.FRIGATE, 0.4f);
        RenderConstants.FRIGATE.setAnimator(FrigateAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityFrigate entity) {
        if (entity.func_70631_g_()) {
            return CONTAINER.get("blink", 4);
        }
        if (ModuleManager.GENDER.getGender(entity).equals((Object)Gender.MALE)) {
            return CONTAINER.get("blink", 3);
        }
        return CONTAINER.get("blink", AbstractZawaLand.getVariant(entity));
    }

    @Override
    protected void preRenderCallback(EntityFrigate e, float partialTickTime) {
        if (e.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        }
        if (!e.func_70090_H()) {
            GlStateManager.func_179114_b((float)e.getPitchRotation(), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        super.preRenderCallback(e, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityFrigate animal) {
        return this.getTextureOfVar(animal);
    }

    @Override
    public ResourceLocation getTextureOfVar(EntityFrigate e) {
        return ModuleManager.GENDER.getGender(e).equals((Object)Gender.MALE) ? CONTAINER.get("male", 0) : CONTAINER.get(AbstractZawaLand.getVariant(e));
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.FRIGATE_BABY.setAnimator(FrigateAnimator::new);
        return RenderConstants.FRIGATE_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityFrigate e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/frigate/frigatebirdfemale.png");
        CONTAINER.addResource("textures/entity/frigate/frigatebirdfemale2.png");
        CONTAINER.addResource("textures/entity/frigate/frigatebirdfemale3.png");
        CONTAINER.addResource("male", "textures/entity/frigate/frigatebirdmale.png");
        CONTAINER.addResource("baby", "textures/entity/frigate/frigatebird_baby.png");
        CONTAINER.addResource("blink", "textures/entity/frigate/frigatebird_blink_f1.png");
        CONTAINER.addResource("blink", "textures/entity/frigate/frigatebird_blink_f2.png");
        CONTAINER.addResource("blink", "textures/entity/frigate/frigatebird_blink_f3.png");
        CONTAINER.addResource("blink", "textures/entity/frigate/frigatebird_blink_m.png");
        CONTAINER.addResource("blink", "textures/entity/frigate/frigatebird_blink_baby.png");
    }

    public static class FrigateAnimator
    extends ZAWAAnimator<EntityFrigate> {
        private final BookwormModelRenderer Neck = this.getModel().getPartFromRig("Neck");
        private final BookwormModelRenderer BagTop = this.getModel().getPartFromRig("Bagtop");
        private final BookwormModelRenderer WingBaseRight = this.getModel().getPartByName("Wing Base Right");
        private final BookwormModelRenderer WingBaseLeft = this.getModel().getPartByName("Wing Base Left");

        public FrigateAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityFrigate entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.speed = 3.2f;
            this.degree = 0.8f;
            this.BagTop.renderPartScale = 0.0f;
            this.Neck.field_78795_f = f4 / 57.295776f - 0.4f;
            this.Neck.field_78808_h = f3 / 57.295776f;
            this.Neck.field_78795_f = MathHelper.func_76134_b((float)(12.0f + f * (0.1562f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.3f - 1.5f;
            if (!(entity.func_70631_g_() || entity.field_70122_E || entity.func_70090_H())) {
                this.getModel().loadPosedModel((BookwormModelBase)RenderConstants.FRIGATE_FLYING);
                f = entity.field_70173_aa;
                f1 = 0.2f;
                this.speed = 1.0f;
                this.speed = ZAWAUtils.movingUp((Entity)entity) ? 2.0f : (ZAWAUtils.movingDown((Entity)entity) ? 0.4f : 0.1f);
                this.WingBaseLeft.field_78796_g = MathHelper.func_76134_b((float)(f * (0.3662f * this.speed) + (float)Math.PI)) * (-this.degree * 0.6f) * f1 * 1.5f + 1.6f;
                this.WingBaseRight.field_78796_g = MathHelper.func_76134_b((float)(f * (0.3662f * this.speed) + (float)Math.PI)) * (this.degree * 0.6f) * f1 * 1.5f + 1.6f;
            }
        }

        @Override
        protected void performIdleAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityFrigate e) {
            super.performIdleAnimation(f, f1, f2, f3, f4, f5, e);
            this.speed = 0.2f;
            this.degree = 1.1f;
            this.Neck.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1862f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f) * f1 * 0.3f - 1.5f;
        }
    }
}

