/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityGilaMonster;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderGilaMonster
extends RenderLivingZAWA<EntityGilaMonster>
implements IBabyModel<EntityGilaMonster> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderGilaMonster(RenderManager m) {
        super(m, (ModelBase)RenderConstants.GILA_MONSTER, 0.5f);
        RenderConstants.GILA_MONSTER.setAnimator(GilaMonsterAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityGilaMonster entity) {
        return CONTAINER.get("blink", 0);
    }

    protected ResourceLocation getEntityTexture(EntityGilaMonster animal) {
        return this.getTextureOfVar(animal);
    }

    @Override
    protected void preRenderCallback(EntityGilaMonster entitylivingbaseIn, float partialTickTime) {
        if (entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.11f, (float)0.0f);
        } else {
            GlStateManager.func_179109_b((float)0.0f, (float)0.045f, (float)0.0f);
        }
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
    }

    @Override
    public ResourceLocation getTextureOfVar(EntityGilaMonster e) {
        return CONTAINER.get(AbstractZawaLand.getVariant(e));
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.GILA_MONSTER_BABY.setAnimator(GilaMonsterAnimator::new);
        return RenderConstants.GILA_MONSTER_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityGilaMonster e) {
        return this.getEntityTexture(e);
    }

    static {
        CONTAINER.addResource("textures/entity/gila_monster/gila_monster.png");
        CONTAINER.addResource("textures/entity/gila_monster/gila_monster2.png");
        CONTAINER.addResource("textures/entity/gila_monster/gila_monster3.png");
        CONTAINER.addResource("textures/entity/gila_monster/gila_monster4.png");
        CONTAINER.addResource("blink", "textures/entity/gila_monster/gila_blink.png");
    }

    public static class GilaMonsterAnimator
    extends ZAWAAnimator<EntityGilaMonster> {
        private final BookwormModelRenderer ThighRight1 = this.getModel().getPartByName("Thigh Right 1");
        private final BookwormModelRenderer ThighLeft1 = this.getModel().getPartByName("Thigh Left 1");
        private final BookwormModelRenderer ThighRigth2 = this.getModel().getPartByName("Thigh Rigth 2");
        private final BookwormModelRenderer ThighLeft2 = this.getModel().getPartByName("Thigh Left 2");
        private final BookwormModelRenderer Neck = this.getModel().getPartByName("Neck");
        private final BookwormModelRenderer Tail = this.getModel().getPartByName("Tail");

        public GilaMonsterAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityGilaMonster entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.speed = 2.3f;
            this.degree = 1.8f;
            this.Neck.field_78795_f = f4 / 57.295776f + 0.0f;
            this.Neck.field_78796_g = f3 / 57.295776f;
            this.ThighRight1.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * 0.9f) * f1 * 0.5f - 0.2f;
            this.ThighLeft1.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * -0.9f) * f1 * 0.5f - 0.2f;
            this.ThighRigth2.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * -0.9f) * f1 * 0.5f + 0.2f;
            this.ThighLeft2.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * 0.9f) * f1 * 0.5f + 0.2f;
            this.Tail.field_78796_g = MathHelper.func_76134_b((float)(23.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.4f) * f1 * 0.5f;
        }
    }
}

