/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.flying.EntityGreatHornedOwl;
import org.zawamod.util.RenderConstants;
import org.zawamod.util.ZAWAUtils;

@SideOnly(value=Side.CLIENT)
public class RenderGreatHornedOwl
extends RenderLivingZAWA<EntityGreatHornedOwl>
implements IBabyModel<EntityGreatHornedOwl> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderGreatHornedOwl(RenderManager m) {
        super(m, (ModelBase)RenderConstants.OWL, 0.3f);
        RenderConstants.OWL.setAnimator(OwlAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityGreatHornedOwl entity) {
        if (entity.func_70631_g_()) {
            return CONTAINER.get("blink", 3);
        }
        return CONTAINER.get("blink", AbstractZawaLand.getVariant(entity));
    }

    @Override
    protected void preRenderCallback(EntityGreatHornedOwl e, float partialTickTime) {
        if (e.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.21f, (float)0.0f);
        } else {
            GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.23f, (float)0.0f);
        }
        GlStateManager.func_179114_b((float)e.getPitchRotation(), (float)1.0f, (float)0.0f, (float)0.0f);
        super.preRenderCallback(e, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityGreatHornedOwl entity) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(entity));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.OWL_BABY.setAnimator(OwlAnimator::new);
        return RenderConstants.OWL_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityGreatHornedOwl e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/great_horned_owl/great_horned_owl.png");
        CONTAINER.addResource("textures/entity/great_horned_owl/great_horned_owl_3.png");
        CONTAINER.addResource("textures/entity/great_horned_owl/great_horned_owl_4.png");
        CONTAINER.addResource("baby", "textures/entity/great_horned_owl/great_horned_owl_baby.png");
        CONTAINER.addResource("blink", "textures/entity/great_horned_owl/owl_blink_1.png");
        CONTAINER.addResource("blink", "textures/entity/great_horned_owl/owl_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/great_horned_owl/owl_blink_4.png");
        CONTAINER.addResource("blink", "textures/entity/great_horned_owl/owl_blink_baby.png");
    }

    public static class OwlAnimator
    extends ZAWAAnimator<EntityGreatHornedOwl> {
        private final BookwormModelRenderer WingBaseRight = this.getModel().getPartByName("Wing Base Right");
        private final BookwormModelRenderer WingBaseLeft = this.getModel().getPartByName("Wing Base Left");
        private final BookwormModelRenderer neck = this.getModel().getPartByName("Neck");

        public OwlAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityGreatHornedOwl entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.neck.field_78795_f = f4 / 57.295776f - 0.1f;
            this.neck.field_78808_h = f3 / 57.295776f;
            if (!entity.field_70122_E && !entity.func_70631_g_()) {
                this.neck.field_78795_f = f4 / 57.295776f - 0.1f;
                this.getModel().loadPosedModel((BookwormModelBase)RenderConstants.OWL_FLYING);
                f = entity.field_70173_aa;
                f1 = 0.2f;
                this.speed = 1.0f;
                this.speed = ZAWAUtils.movingUp((Entity)entity) ? 2.0f : (ZAWAUtils.movingDown((Entity)entity) ? 0.4f : 0.1f);
                this.WingBaseLeft.field_78808_h = MathHelper.func_76134_b((float)(f * (0.3662f * this.speed) + (float)Math.PI)) * (-this.degree * 0.6f) * f1 * 1.5f - 1.6f;
                this.WingBaseRight.field_78808_h = MathHelper.func_76134_b((float)(f * (0.3662f * this.speed) + (float)Math.PI)) * (this.degree * 0.6f) * f1 * 1.5f + 1.6f;
            }
        }
    }
}

