/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.model.ModelHarpyEagleBaby;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.flying.EntityHarpyEagle;
import org.zawamod.util.RenderConstants;
import org.zawamod.util.ZAWAUtils;

@SideOnly(value=Side.CLIENT)
public class RenderHarpyEagle
extends RenderLivingZAWA<EntityHarpyEagle>
implements IBabyModel<EntityHarpyEagle> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderHarpyEagle(RenderManager m) {
        super(m, (ModelBase)RenderConstants.HARPY_EAGLE, 0.4f);
        RenderConstants.HARPY_EAGLE.setAnimator(HarpyEagleAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityHarpyEagle entity) {
        if (entity.func_70631_g_()) {
            return CONTAINER.get("blink", 2);
        }
        return CONTAINER.get("blink", AbstractZawaLand.getVariant(entity));
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    protected void preRenderCallback(EntityHarpyEagle e, float partialTickTime) {
        GlStateManager.func_179152_a((float)1.3f, (float)1.3f, (float)1.3f);
        GlStateManager.func_179114_b((float)e.getPitchRotation(), (float)1.0f, (float)0.0f, (float)0.0f);
        super.preRenderCallback(e, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityHarpyEagle entity) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(entity));
    }

    @Override
    public ResourceLocation getTextureOfVar(int variant) {
        return CONTAINER.get(variant);
    }

    @Override
    public ModelBase getBabyModel() {
        return new ModelHarpyEagleBaby();
    }

    @Override
    public ResourceLocation getBabyTexture(EntityHarpyEagle e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/harpy_eagle/eagle_1.png");
        CONTAINER.addResource("textures/entity/harpy_eagle/eagle_3.png");
        CONTAINER.addResource("baby", "textures/entity/harpy_eagle/eagle_baby.png");
        CONTAINER.addResource("blink", "textures/entity/harpy_eagle/harpy_blink_1.png");
        CONTAINER.addResource("blink", "textures/entity/harpy_eagle/harpy_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/harpy_eagle/harpy_blink_baby.png");
    }

    public static class HarpyEagleAnimator
    extends ZAWAAnimator<EntityHarpyEagle> {
        private final BookwormModelRenderer WingBaseRight = this.getModel().getPartByName("Wing Base Right");
        private final BookwormModelRenderer WingBaseLeft = this.getModel().getPartByName("Wing Base Left");
        private final BookwormModelRenderer neck = this.getModel().getPartByName("Neck");

        public HarpyEagleAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityHarpyEagle entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.neck.field_78795_f = f4 / 57.295776f - 0.4f;
            this.neck.field_78808_h = f3 / 57.295776f;
            if (!entity.field_70122_E && !(entity.func_184187_bx() instanceof EntityPlayer)) {
                this.neck.field_78795_f = f4 / 57.295776f - 0.4f;
                this.getModel().loadPosedModel((BookwormModelBase)RenderConstants.HARPY_EAGLE_FLYING);
                f = entity.field_70173_aa;
                f1 = 0.2f;
                this.speed = 1.0f;
                this.speed = ZAWAUtils.movingUp((Entity)entity) ? 2.0f : (ZAWAUtils.movingDown((Entity)entity) ? 0.4f : 0.1f);
                this.WingBaseLeft.field_78796_g = MathHelper.func_76134_b((float)(f * (0.3662f * this.speed) + (float)Math.PI)) * (-this.degree * 0.6f) * f1 * 1.5f - 1.6f;
                this.WingBaseRight.field_78796_g = MathHelper.func_76134_b((float)(f * (0.3662f * this.speed) + (float)Math.PI)) * (this.degree * 0.6f) * f1 * 1.5f - 1.6f;
            }
        }
    }
}

