/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.water.EntityHumpbackWhale;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderHumpbackWhale
extends RenderLivingZAWA<EntityHumpbackWhale>
implements IBabyModel<EntityHumpbackWhale> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderHumpbackWhale(RenderManager m) {
        super(m, (ModelBase)RenderConstants.HUMPBACK_WHALE, 0.0f);
        RenderConstants.HUMPBACK_WHALE.setAnimator(WhaleAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    protected void preRenderCallback(EntityHumpbackWhale whale, float partialTickTime) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.7f);
        if (whale.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        } else {
            GlStateManager.func_179152_a((float)1.2f, (float)1.2f, (float)1.2f);
        }
        GlStateManager.func_179114_b((float)whale.getPitchRotation(), (float)1.0f, (float)0.0f, (float)0.0f);
        super.preRenderCallback(whale, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityHumpbackWhale entity) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(entity));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.HUMPBACK_WHALE_BABY.setAnimator(WhaleAnimator::new);
        return RenderConstants.HUMPBACK_WHALE_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityHumpbackWhale e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/humpback_whale/humpback_whale.png");
        CONTAINER.addResource("textures/entity/humpback_whale/humpback_whale_2.png");
        CONTAINER.addResource("textures/entity/humpback_whale/humpback_whale_3.png");
        CONTAINER.addResource("textures/entity/humpback_whale/humpback_whale_4.png");
        CONTAINER.addResource("baby", "textures/entity/humpback_whale/humpback_whale_baby.png");
    }

    public static class WhaleAnimator
    extends ZAWAAnimator<EntityHumpbackWhale> {
        private final BookwormModelRenderer Body = this.getModel().getPartByName("Body");
        private final BookwormModelRenderer Neck = this.getModel().getPartByName("Neck");
        private final BookwormModelRenderer Tail = this.getModel().getPartByName("Tail");
        private final BookwormModelRenderer TailBase = this.getModel().getPartByName("Tail Base");
        private final BookwormModelRenderer Hips = this.getModel().getPartByName("Hips");
        private final BookwormModelRenderer Head = this.getModel().getPartByName("Head");
        private final BookwormModelRenderer FinBaseLeft = this.getModel().getPartByName("Fin Base Left");
        private final BookwormModelRenderer FinBaseRight = this.getModel().getPartByName("Fin Base Right");

        public WhaleAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityHumpbackWhale entity) {
            this.neck_part = this.Neck;
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            EntityHumpbackWhale whale = entity;
            float speed = 1.8f;
            float degree = 2.1f;
            f = entity.field_70173_aa;
            f1 = 0.1f;
            this.Body.field_78795_f = (float)((double)this.Body.field_78795_f + (whale.field_70167_r - whale.field_70163_u));
            if (entity.func_70090_H()) {
                this.Body.field_78795_f = MathHelper.func_76134_b((float)(f * (0.0662f * speed) + (float)Math.PI)) * (degree * 0.2f) * f1 * 0.5f;
                this.Tail.field_78795_f = MathHelper.func_76134_b((float)(f * (0.0662f * speed) + (float)Math.PI)) * (degree * -0.6f) * f1 * 0.5f;
                this.TailBase.field_78795_f = MathHelper.func_76134_b((float)(f * (0.0662f * speed) + (float)Math.PI)) * (degree * -0.4f) * f1 * 0.5f - 0.1f;
                this.Hips.field_78795_f = MathHelper.func_76134_b((float)(f * (0.0662f * speed) + (float)Math.PI)) * (degree * -0.8f) * f1 * 0.5f;
                this.Head.field_78795_f = MathHelper.func_76134_b((float)(23.0f + f * (0.0662f * speed) + (float)Math.PI)) * (degree * 0.6f) * f1 * 0.5f;
                this.FinBaseLeft.field_78796_g = MathHelper.func_76134_b((float)(33.0f + f * (0.0662f * speed) + (float)Math.PI)) * (degree * 0.6f) * f1 * 0.5f - 0.3f;
                this.FinBaseLeft.field_78808_h = MathHelper.func_76134_b((float)(33.0f + f * (0.0662f * speed) + (float)Math.PI)) * (degree * 0.6f) * f1 * 0.5f + 0.4f;
                this.FinBaseRight.field_78796_g = MathHelper.func_76134_b((float)(34.0f + f * (0.0662f * speed) + (float)Math.PI)) * (degree * -0.6f) * f1 * 0.5f + 0.3f;
                this.FinBaseRight.field_78808_h = MathHelper.func_76134_b((float)(34.0f + f * (0.0662f * speed) + (float)Math.PI)) * (degree * -0.6f) * f1 * 0.5f - 0.4f;
            } else {
                this.Head.field_78795_f = MathHelper.func_76134_b((float)(23.0f + f * (0.0262f * speed) + (float)Math.PI)) * (degree * 0.3f) * f1 * 0.5f;
                this.FinBaseLeft.field_78796_g = MathHelper.func_76134_b((float)(33.0f + f * (0.0362f * speed) + (float)Math.PI)) * (degree * 0.3f) * f1 * 0.5f - 0.3f;
                this.FinBaseLeft.field_78808_h = MathHelper.func_76134_b((float)(33.0f + f * (0.0362f * speed) + (float)Math.PI)) * (degree * 0.3f) * f1 * 0.5f + 0.4f;
                this.FinBaseRight.field_78796_g = MathHelper.func_76134_b((float)(34.0f + f * (0.0362f * speed) + (float)Math.PI)) * (degree * -0.3f) * f1 * 0.5f + 0.3f;
                this.FinBaseRight.field_78808_h = MathHelper.func_76134_b((float)(34.0f + f * (0.0362f * speed) + (float)Math.PI)) * (degree * -0.3f) * f1 * 0.5f - 0.4f;
            }
        }
    }
}

