/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.RenderMarineIguana;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityKomodoDragon;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderKomodoDragon
extends RenderLivingZAWA<EntityKomodoDragon>
implements IBabyModel<EntityKomodoDragon> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderKomodoDragon(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.KOMODO_DRAGON, 0.5f);
        RenderConstants.KOMODO_DRAGON.setAnimator(RenderMarineIguana.IguanaAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityKomodoDragon entity) {
        return entity.func_70631_g_() ? CONTAINER.get("blink", 4) : CONTAINER.get("blink", AbstractZawaLand.getVariant(entity));
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    protected void preRenderCallback(EntityKomodoDragon e, float partialTickTime) {
        if (e.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)0.0f);
        } else {
            GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.1f, (float)0.0f);
        }
        super.preRenderCallback(e, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityKomodoDragon animal) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(animal));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.KOMODO_DRAGON_BABY.setAnimator(RenderMarineIguana.IguanaAnimator::new);
        return RenderConstants.KOMODO_DRAGON_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityKomodoDragon e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/komodo_dragon/komodo_dragon.png");
        CONTAINER.addResource("textures/entity/komodo_dragon/komodo_dragon_2.png");
        CONTAINER.addResource("textures/entity/komodo_dragon/komodo_dragon_3.png");
        CONTAINER.addResource("textures/entity/komodo_dragon/komodo_dragon_4.png");
        CONTAINER.addResource("baby", "textures/entity/komodo_dragon/komodo_dragon_baby.png");
        CONTAINER.addResource("blink", "textures/entity/komodo_dragon/komodo_blink_1.png");
        CONTAINER.addResource("blink", "textures/entity/komodo_dragon/komodo_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/komodo_dragon/komodo_blink_3.png");
        CONTAINER.addResource("blink", "textures/entity/komodo_dragon/komodo_blink_4.png");
        CONTAINER.addResource("blink", "textures/entity/komodo_dragon/komodo_blink_baby.png");
    }

    public static class KomodoDragonAnimator
    extends ZAWAAnimator<EntityKomodoDragon> {
        private final BookwormModelRenderer Body = this.getModel().getPartByName("body");
        private final BookwormModelRenderer Head = this.getModel().getPartByName("head");
        private final BookwormModelRenderer TailBase = this.getModel().getPartByName("tail1");
        private final BookwormModelRenderer Tail = this.getModel().getPartByName("tailFin");
        private final BookwormModelRenderer Jaw = this.getModel().getPartByName("jaw");
        private final BookwormModelRenderer FinLeft = this.getModel().getPartByName("finpecLeft");
        private final BookwormModelRenderer FinRight = this.getModel().getPartByName("finpecRight");

        public KomodoDragonAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityKomodoDragon entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            f = entity.field_70173_aa;
            f1 = 0.3f;
            float speed = 3.4f;
            float degree = 2.1f;
            this.Body.field_78795_f = MathHelper.func_76134_b((float)(23.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.1f) * f1 * 0.5f;
            this.Head.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.1f) * f1 * 0.5f - 0.9f;
            this.TailBase.field_78795_f = MathHelper.func_76134_b((float)(-3.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.1f) * f1 * 0.5f;
            this.Tail.field_78796_g = MathHelper.func_76134_b((float)(f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.4f) * f1 * 0.5f;
            this.Jaw.field_78795_f = MathHelper.func_76134_b((float)(23.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.3f) * f1 * 0.5f - 0.0f;
            this.FinLeft.field_78796_g = MathHelper.func_76134_b((float)(23.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.3f) * f1 * 0.5f + 0.2f;
            this.FinRight.field_78796_g = MathHelper.func_76134_b((float)(23.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * -0.3f) * f1 * 0.5f - 0.2f;
        }
    }
}

