/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import net.soggymustache.bookworm.common.entity.data.Gender;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.entity.land.EntityMoose;
import org.zawamod.util.RenderConstants;
import org.zawamod.util.ZAWAUtils;

@SideOnly(value=Side.CLIENT)
public class RenderMoose
extends RenderLivingZAWA<EntityMoose>
implements IBabyModel<EntityMoose> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderMoose(RenderManager m) {
        super(m, (ModelBase)RenderConstants.MOOSE, 0.8f);
        RenderConstants.MOOSE.setAnimator(MooseAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    protected ResourceLocation getEntityTexture(EntityMoose animal) {
        return this.getTextureOfVar(animal);
    }

    @Override
    protected void preRenderCallback(EntityMoose e, float partialTickTime) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.05f, (float)(e.func_70631_g_() ? -0.15f : -0.45f));
        super.preRenderCallback(e, partialTickTime);
    }

    @Override
    public ResourceLocation getTextureOfVar(EntityMoose e) {
        if (ModuleManager.GENDER.getGender(e).equals((Object)Gender.MALE)) {
            return CONTAINER.get(AbstractZawaLand.getVariant(e));
        }
        return CONTAINER.get("female", AbstractZawaLand.getVariant(e));
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.MOOSE_BABY.setAnimator(MooseAnimator::new);
        return RenderConstants.MOOSE_BABY;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityMoose e) {
        if (e.func_70631_g_()) {
            return CONTAINER.get("blink", 5);
        }
        if (ModuleManager.GENDER.getGender(e).equals((Object)Gender.MALE)) {
            switch (AbstractZawaLand.getVariant(e)) {
                default: {
                    return CONTAINER.get("blink", 0);
                }
                case 1: {
                    return CONTAINER.get("blink", 3);
                }
                case 2: {
                    return CONTAINER.get("blink", 4);
                }
                case 3: {
                    return CONTAINER.get("blink", 1);
                }
                case 4: 
            }
            return CONTAINER.get("blink", 2);
        }
        switch (AbstractZawaLand.getVariant(e)) {
            default: {
                return CONTAINER.get("blink", 2);
            }
            case 1: {
                return CONTAINER.get("blink", 3);
            }
            case 2: {
                return CONTAINER.get("blink", 4);
            }
            case 3: {
                return CONTAINER.get("blink", 1);
            }
            case 4: 
        }
        return CONTAINER.get("blink", 2);
    }

    @Override
    public ResourceLocation getBabyTexture(EntityMoose e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/moose/moose.png");
        CONTAINER.addResource("textures/entity/moose/moose_2.png");
        CONTAINER.addResource("textures/entity/moose/moose_3.png");
        CONTAINER.addResource("textures/entity/moose/moose_4.png");
        CONTAINER.addResource("textures/entity/moose/moose_5.png");
        CONTAINER.addResource("female", "textures/entity/moose/moose_female.png");
        CONTAINER.addResource("female", "textures/entity/moose/moose_female_2.png");
        CONTAINER.addResource("female", "textures/entity/moose/moose_female_3.png");
        CONTAINER.addResource("female", "textures/entity/moose/moose_female_4.png");
        CONTAINER.addResource("female", "textures/entity/moose/moose_female_5.png");
        CONTAINER.addResource("baby", "textures/entity/moose/moose_baby_1.png");
        CONTAINER.addResource("blink", "textures/entity/moose/moose_blink_1.png");
        CONTAINER.addResource("blink", "textures/entity/moose/moose_blink_4.png");
        CONTAINER.addResource("blink", "textures/entity/moose/moose_blink_m5f15.png");
        CONTAINER.addResource("blink", "textures/entity/moose/moose_blink_mf2.png");
        CONTAINER.addResource("blink", "textures/entity/moose/moose_blink_mf3.png");
        CONTAINER.addResource("blink", "textures/entity/moose/moose_blink_baby.png");
    }

    public static class MooseAnimator
    extends ZAWAAnimator<EntityMoose> {
        private final BookwormModelRenderer Body = this.getModel().getPartFromRig("Body");
        private final BookwormModelRenderer neck = this.getModel().getPartFromRig("Neck");
        private final BookwormModelRenderer tail2 = this.getModel().getPartFromRig("Tail2");
        private final BookwormModelRenderer tail1 = this.getModel().getPartFromRig("Tail1");
        private final BookwormModelRenderer mouth = this.getModel().getPartFromRig("Jaw");
        private final BookwormModelRenderer ArmBaseRight = this.getModel().getPartFromRig("ArmBaseRight");
        private final BookwormModelRenderer ArmRight = this.getModel().getPartFromRig("ArmRight");
        private final BookwormModelRenderer HandRight = this.getModel().getPartFromRig("HandRight");
        private final BookwormModelRenderer ArmBaseLeft = this.getModel().getPartFromRig("ArmBaseLeft");
        private final BookwormModelRenderer UpperArmLeft = this.getModel().getPartFromRig("UpperArmLeft");
        private final BookwormModelRenderer UpperArmRight = this.getModel().getPartFromRig("UpperArmRight");
        private final BookwormModelRenderer ArmLeft = this.getModel().getPartFromRig("ArmLeft");
        private final BookwormModelRenderer HandLeft = this.getModel().getPartFromRig("HandLeft");
        private final BookwormModelRenderer ThighRight = this.getModel().getPartFromRig("ThighRight");
        private final BookwormModelRenderer UpperLegRight = this.getModel().getPartFromRig("UpperLegRight");
        private final BookwormModelRenderer LegRight = this.getModel().getPartFromRig("LegRight");
        private final BookwormModelRenderer FootRight = this.getModel().getPartFromRig("FootRight");
        private final BookwormModelRenderer ThighLeft = this.getModel().getPartFromRig("ThighLeft");
        private final BookwormModelRenderer UpperLegLeft = this.getModel().getPartFromRig("UpperLegLeft");
        private final BookwormModelRenderer LegLeft = this.getModel().getPartFromRig("LegLeft");
        private final BookwormModelRenderer FootLeft = this.getModel().getPartFromRig("FootLeft");
        private final BookwormModelRenderer Jaw = this.getModel().getPartFromRig("Jaw");
        private final BookwormModelRenderer ForearmLeft = this.getModel().getPartFromRig("ForearmLeft");
        private final BookwormModelRenderer ForearmRight = this.getModel().getPartFromRig("ForearmRight");
        private final BookwormModelRenderer LowerLegRight = this.getModel().getPartFromRig("LowerLegRight");
        private final BookwormModelRenderer LowerLegLeft = this.getModel().getPartFromRig("LowerLegLeft");
        private final BookwormModelRenderer Chest = this.getModel().getPartFromRig("Chest");
        private final BookwormModelRenderer Hips = this.getModel().getPartFromRig("Hips");
        private final BookwormModelRenderer Head = this.getModel().getPartFromRig("Head");

        public MooseAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityMoose entity) {
            this.jaw_part = this.Jaw;
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.neck.field_78796_g = f3 / 57.295776f;
            if (this.neck.field_78796_g > 0.5f) {
                this.neck.field_78796_g = 0.5f;
            } else if (this.neck.field_78796_g < -0.5f) {
                this.neck.field_78796_g = -0.5f;
            }
            this.degree = 0.6f;
            this.speed = 4.8f;
            if (entity.func_184207_aI()) {
                this.degree = 1.0f;
                this.speed = 1.3f;
            }
            if (entity.func_70631_g_()) {
                this.speed = 2.3f;
                this.ForearmRight.field_78795_f = MathHelper.func_76134_b((float)(0.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * -2.0f) * f1 * 0.5f + 0.2f;
                this.ForearmLeft.field_78795_f = MathHelper.func_76134_b((float)(0.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 2.0f) * f1 * 0.5f + 0.2f;
            }
            this.Body.field_82908_p = MathHelper.func_76134_b((float)(f * (0.3162f * this.speed) + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f;
            this.tail1.field_78808_h = MathHelper.func_76134_b((float)(10.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.8f) * f1 * 0.5f;
            this.tail2.field_78808_h = MathHelper.func_76134_b((float)(21.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.9f) * f1 * 0.5f;
            this.mouth.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.0962f * this.speed) + (float)Math.PI)) * (this.degree * 0.5f) * f1 * 0.5f - 0.2f;
            this.ArmBaseRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f - 0.05f;
            this.ArmBaseRight.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.0f) * f1 * 0.5f - 0.0f;
            this.UpperArmRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f - 0.05f;
            this.UpperArmRight.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.0f) * f1 * 0.5f + 0.1f;
            this.ForearmRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.0f) * f1 * 0.5f + f1 * 0.6f;
            this.HandRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            this.ArmBaseLeft.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f - 0.05f;
            this.ArmBaseLeft.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 2.0f) * f1 * 0.5f - 0.0f;
            this.UpperArmLeft.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f - 0.05f;
            this.UpperArmLeft.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 2.0f) * f1 * 0.5f + 0.1f;
            this.ForearmLeft.field_78795_f = MathHelper.func_76134_b((float)(0.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 2.0f) * f1 * 0.5f + f1 * 0.6f;
            this.HandLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * -0.3f) * f1 * 0.5f - 0.0f;
            this.neck.field_78795_f = f4 / 57.295776f - (entity.func_70631_g_() ? 0.7f : 0.2f);
            this.neck.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.2962f * this.speed) + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f - (entity.func_70631_g_() ? 0.7f : 0.2f);
            this.ThighRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + (entity.func_70631_g_() ? 0.0f : 0.1f);
            this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.1f) * f1 * 0.5f + (entity.func_70631_g_() ? -0.0f : -0.3f);
            this.UpperLegRight.field_78795_f = MathHelper.func_76134_b((float)(90.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.5f) * f1 * 0.5f + (entity.func_70631_g_() ? 0.7f : 0.9f);
            this.LegRight.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.0f) * f1 * 0.5f - 0.8f;
            this.FootRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            this.ThighLeft.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + (entity.func_70631_g_() ? 0.0f : 0.1f);
            this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 2.1f) * f1 * 0.5f + (entity.func_70631_g_() ? -0.0f : -0.3f);
            this.UpperLegLeft.field_78795_f = MathHelper.func_76134_b((float)(90.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 1.5f) * f1 * 0.5f + (entity.func_70631_g_() ? 0.7f : 0.9f);
            this.LegLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 1.0f) * f1 * 0.5f - 0.8f;
            this.FootLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            if (entity.isRunning() && !entity.func_70631_g_() && ZAWAUtils.isEntityMoving((Entity)entity)) {
                this.degree = 0.3f;
                this.speed = 3.4f;
                this.UpperArmLeft.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 4.6f) * f1 * 0.5f + 0.1f;
                this.ArmLeft.field_78795_f = MathHelper.func_76134_b((float)(5.5f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -3.9f) * f1 * 0.5f + -0.5f;
                this.ForearmLeft.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 3.0f) * f1 * 0.5f + 0.2f;
                this.HandLeft.field_78795_f = MathHelper.func_76134_b((float)(11.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 3.0f) * f1 * 0.5f + 0.3f;
                this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(5.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -3.1f) * f1 * 0.5f + 0.3f;
                this.UpperLegLeft.field_78795_f = MathHelper.func_76134_b((float)(4.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.0f) * f1 * 0.5f + 0.6f;
                this.LowerLegLeft.field_78795_f = MathHelper.func_76134_b((float)(6.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -2.0f) * f1 * 0.5f + -0.6f;
                this.UpperArmRight.field_78795_f = MathHelper.func_76134_b((float)(-1.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 4.6f) * f1 * 0.5f + 0.1f;
                this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(10.5f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -3.9f) * f1 * 0.5f + -0.5f;
                this.ForearmRight.field_78795_f = MathHelper.func_76134_b((float)(5.5f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 3.0f) * f1 * 0.5f + 0.2f;
                this.HandRight.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 3.0f) * f1 * 0.5f + 0.3f;
                this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(4.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -3.1f) * f1 * 0.5f + 0.3f;
                this.UpperLegRight.field_78795_f = MathHelper.func_76134_b((float)(9.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.0f) * f1 * 0.5f + 0.6f;
                this.LowerLegRight.field_78795_f = MathHelper.func_76134_b((float)(4.5f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -4.0f) * f1 * 0.5f + -0.6f;
                this.Chest.field_78795_f = MathHelper.func_76134_b((float)(8.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -0.1f) * f1 * 0.5f + 0.04f;
                this.Hips.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.4f) * f1 * 0.5f + 0.1f;
                this.neck.field_78795_f = MathHelper.func_76134_b((float)(9.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.5f) * f1 * 0.5f + 0.05f;
                this.Head.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.6f) * f1 * 0.5f + 0.1f;
                this.Body.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f + -0.02f;
                this.Jaw.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f + 0.1f;
                this.Body.field_82908_p = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f;
            }
        }

        @Override
        protected void performIdleAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityMoose entity) {
            super.performIdleAnimation(f, f1, f2, f3, f4, f5, entity);
            this.degree = 1.0f;
            this.speed = 1.0f;
            this.tail1.field_78808_h = MathHelper.func_76134_b((float)(10.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f;
            this.neck.field_78795_f = entity.func_70631_g_() ? MathHelper.func_76134_b((float)(20.0f - f * (0.1062f * this.speed) + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f - 0.7f : MathHelper.func_76134_b((float)(20.0f - f * (0.1062f * this.speed) + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f - 0.2f;
        }
    }
}

