/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import net.soggymustache.bookworm.util.BookwormRenderUtils;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.render.entity.RenderBengalTiger;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.entity.land.EntityGrizzlyBear;
import org.zawamod.entity.land.EntityPolarBear;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderPolarBear
extends RenderLivingZAWA<EntityPolarBear>
implements IBabyModel<EntityPolarBear> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderPolarBear(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.POLAR_BEAR.setAnimator(PolarBearAnimator::new), 0.6f);
        this.func_177094_a(new LayerSalmon(this));
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    protected void preRenderCallback(EntityPolarBear entitylivingbaseIn, float partialTickTime) {
        if (!entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179152_a((float)1.2f, (float)1.2f, (float)1.2f);
        }
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityPolarBear entity) {
        return entity.func_70631_g_() ? CONTAINER.get("blink", 1) : CONTAINER.get("blink", 0);
    }

    protected ResourceLocation getEntityTexture(EntityPolarBear animal) {
        if (animal.func_70631_g_()) {
            return BookwormRenderUtils.NONE;
        }
        return this.getTextureOfVar(AbstractZawaLand.getVariant(animal));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.POLAR_BEAR_CUB.setAnimator(PolarBearAnimator::new);
        return RenderConstants.POLAR_BEAR_CUB;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityPolarBear e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/polar_bear/polar_bear_1.png");
        CONTAINER.addResource("textures/entity/polar_bear/polar_bear_2.png");
        CONTAINER.addResource("textures/entity/polar_bear/polar_bear_3.png");
        CONTAINER.addResource("baby", "textures/entity/polar_bear/polar_bear_baby.png");
        CONTAINER.addResource("blink", "textures/entity/polar_bear/polar_bear_blink_123.png");
        CONTAINER.addResource("blink", "textures/entity/polar_bear/polar_bear_blink_baby.png");
    }

    public static class PolarBearAnimator
    extends RenderBengalTiger.TigerAnimator {
        public PolarBearAnimator(ModelCMF model) {
            super(model);
            this.neckWeight = -0.1f;
            this.weightA = -0.6f;
            this.pressure = -0.1f;
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, AbstractZawaLand entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.4f) * f1 * 0.5f - f1 * 0.4f;
            this.ArmLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.4f) * f1 * 0.5f - f1 * 0.4f;
            this.neck.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.2962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f;
            if (entity.func_70090_H()) {
                f = entity.field_70173_aa;
                f1 = 0.24f;
                this.speed = 1.3f;
                this.degree = 1.4f;
                this.ArmBaseLeft.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 2.3f) * f1 * 0.5f + 0.2f;
                this.ArmLeft.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 2.0f) * f1 * 0.5f + -0.4f;
                this.HandLeft.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.5f) * f1 * 0.5f + 0.6f;
                this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -2.2f) * f1 * 0.5f;
                this.UpperLegLeft.field_78795_f = MathHelper.func_76134_b((float)(6.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.0f) * f1 * 0.5f + 0.3f;
                this.FootLeft.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.0f) * f1 * 0.5f + 0.1f;
                this.Body.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.0f) * f1 * 0.5f + -0.1f;
                this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 2.2f) * f1 * 0.5f;
                this.UpperLegRight.field_78795_f = MathHelper.func_76134_b((float)(6.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.0f) * f1 * 0.5f + 0.3f;
                this.FootRight.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.0f) * f1 * 0.5f + 0.1f;
                this.ArmBaseRight.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -2.3f) * f1 * 0.5f + 0.2f;
                this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -2.0f) * f1 * 0.5f + -0.4f;
                this.HandRight.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.5f) * f1 * 0.5f + 0.6f;
                this.Chest.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * 0.01f) * f1 * 0.5f + -0.2f;
                this.neck.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f;
                this.head.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * 0.05f) * f1 * 0.5f + 0.2f;
            } else if (entity.isRunning()) {
                this.speed = 4.0f;
                this.degree = 0.3f;
                this.ArmLeft.field_78795_f = MathHelper.func_76134_b((float)(5.5f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -2.9f) * f1 * 0.5f + -0.3f;
                this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(10.5f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -2.9f) * f1 * 0.5f + -0.3f;
            }
            if (entity instanceof EntityPolarBear) {
                EntityPolarBear bear = (EntityPolarBear)entity;
                if (!bear.func_70631_g_()) {
                    if (bear.getSalmon()) {
                        this.mouth.field_78795_f = 20.0f;
                    }
                    if (ModuleManager.STANDING.processStandingAnimation(entity)) {
                        this.getModel().interpolateToPose((BookwormModelBase)RenderConstants.POLAR_BEAR_STANDING, entity.getAnimalFloat().get("standingFloat").floatValue());
                    }
                }
            } else if (entity instanceof EntityGrizzlyBear && ModuleManager.STANDING.processStandingAnimation(entity)) {
                this.getModel().interpolateToPose((BookwormModelBase)RenderConstants.BEAR_STANDING, entity.getAnimalFloat().get("standingFloat").floatValue());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerSalmon
    implements LayerRenderer<EntityPolarBear> {
        private final RenderPolarBear render;

        public LayerSalmon(RenderPolarBear re) {
            this.render = re;
        }

        public void doRenderLayer(EntityPolarBear bear, float f, float f1, float f2, float f3, float f4, float f5, float f6) {
            if (bear.getSalmon() && !bear.func_82150_aj() && !bear.func_70631_g_()) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)43.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)1.2f, (float)-1.1f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

