/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.model.ModelReticulatedGiraffeBaby;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.entity.land.EntityReticulatedGiraffe;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderReticulatedGiraffe
extends RenderLivingZAWA<EntityReticulatedGiraffe>
implements IBabyModel<EntityReticulatedGiraffe> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderReticulatedGiraffe(RenderManager m) {
        super(m, (ModelBase)RenderConstants.GIRAFFE.setAnimator(GiraffeAnimator::new), 0.7f);
        this.func_177094_a(new LayerGiraffeSaddle(this));
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    protected void preRenderCallback(EntityReticulatedGiraffe giraffe, float partialTickTime) {
        if (!giraffe.func_70631_g_()) {
            GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.1f, (float)-0.6f);
            if (giraffe.isAsleep()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.1f, (float)0.0f);
            } else {
                GlStateManager.func_179109_b((float)0.0f, (float)0.7f, (float)0.0f);
            }
        } else {
            GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)-0.4f);
            if (giraffe.isAsleep()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
            }
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.3f);
        super.preRenderCallback(giraffe, partialTickTime);
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityReticulatedGiraffe entity) {
        return entity.func_70631_g_() ? CONTAINER.get("blink", 1) : CONTAINER.get("blink", 0);
    }

    protected ResourceLocation getEntityTexture(EntityReticulatedGiraffe entity) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(entity));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        return new ModelReticulatedGiraffeBaby();
    }

    @Override
    public ResourceLocation getBabyTexture(EntityReticulatedGiraffe e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/reticulated_giraffe/reticulated_giraffe1.png");
        CONTAINER.addResource("textures/entity/reticulated_giraffe/reticulated_giraffe2.png");
        CONTAINER.addResource("textures/entity/reticulated_giraffe/reticulated_giraffe3.png");
        CONTAINER.addResource("baby", "textures/entity/reticulated_giraffe/baby.png");
        CONTAINER.addResource("blink", "textures/entity/reticulated_giraffe/reticulated_giraffe_blink.png");
        CONTAINER.addResource("blink", "textures/entity/reticulated_giraffe/reticulated_giraffe_baby_blink.png");
    }

    public static class GiraffeAnimator
    extends ZAWAAnimator<EntityReticulatedGiraffe> {
        private final BookwormModelRenderer tight1 = this.getModel().getPartByName("tight1");
        private final BookwormModelRenderer tight2 = this.getModel().getPartByName("tight2");
        private final BookwormModelRenderer tight4 = this.getModel().getPartByName("tight4");
        private final BookwormModelRenderer tight3 = this.getModel().getPartByName("tight3");
        private final BookwormModelRenderer upperleg1 = this.getModel().getPartByName("upperleg1");
        private final BookwormModelRenderer lowerleg1 = this.getModel().getPartByName("lowerleg1");
        private final BookwormModelRenderer lowerleg3 = this.getModel().getPartByName("lowerleg3");
        private final BookwormModelRenderer upperleg3 = this.getModel().getPartByName("upperleg3");
        private final BookwormModelRenderer foot3 = this.getModel().getPartByName("foot3");
        private final BookwormModelRenderer lowerleg2 = this.getModel().getPartByName("lowerleg2");
        private final BookwormModelRenderer upperleg2 = this.getModel().getPartByName("upperleg2");
        private final BookwormModelRenderer lowerleg4 = this.getModel().getPartByName("lowerleg4");
        private final BookwormModelRenderer upperleg4 = this.getModel().getPartByName("upperleg4");
        private final BookwormModelRenderer neck1 = this.getModel().getPartByName("neck1");
        private final BookwormModelRenderer foot4 = this.getModel().getPartByName("foot4");
        private final BookwormModelRenderer bodyback = this.getModel().getPartByName("bodyback");
        private final BookwormModelRenderer tail = this.getModel().getPartByName("tail");
        private final BookwormModelRenderer neck2 = this.getModel().getPartByName("neck2");

        public GiraffeAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityReticulatedGiraffe entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.degree = 0.8f;
            this.speed = 3.0f;
            this.tight1.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.3f) * f1 * 0.5f + 0.07f;
            this.upperleg1.field_78795_f = MathHelper.func_76134_b((float)(8.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.4f) * f1 * 0.5f + -0.09f;
            this.lowerleg1.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.4f) * f1 * 0.5f + 0.15f;
            this.tight3.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.2f) * f1 * 0.5f;
            this.upperleg3.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.2f) * f1 * 0.5f + 0.3f;
            this.lowerleg3.field_78795_f = MathHelper.func_76134_b((float)(6.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.5f) * f1 * 0.5f + -0.24f;
            this.foot3.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.5f) * f1 * 0.5f;
            this.tight2.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.3f) * f1 * 0.5f + 0.07f;
            this.upperleg2.field_78795_f = MathHelper.func_76134_b((float)(8.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.4f) * f1 * 0.5f + -0.09f;
            this.lowerleg2.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.4f) * f1 * 0.5f + 0.15f;
            this.tight4.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.2f) * f1 * 0.5f;
            this.upperleg4.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.2f) * f1 * 0.5f + 0.3f;
            this.lowerleg4.field_78795_f = MathHelper.func_76134_b((float)(6.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.5f) * f1 * 0.5f + -0.24f;
            this.foot4.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.5f) * f1 * 0.5f;
            this.bodyback.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * 0.03f) * f1 * 0.5f;
            this.tail.field_78808_h = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.0f) * f1 * 0.5f;
            this.neck1.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * 0.02f) * f1 * 0.5f + 1.1f;
            this.neck2.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * -0.02f) * f1 * 0.5f + -0.15f;
            this.neck1.field_78795_f = f4 / 57.295776f + 1.1f;
            this.neck1.field_78796_g = f3 / 57.295776f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerGiraffeSaddle
    implements LayerRenderer<EntityReticulatedGiraffe> {
        private final ResourceLocation TEXTURE = new ResourceLocation("zawa:textures/entity/reticulated_giraffe/saddle.png");
        private final RenderReticulatedGiraffe render;

        public LayerGiraffeSaddle(RenderReticulatedGiraffe re) {
            this.render = re;
        }

        public void doRenderLayer(EntityReticulatedGiraffe e, float f, float f1, float f2, float f3, float f4, float f5, float f6) {
            if (ModuleManager.SADDLE.isSaddled(e) && !e.func_82150_aj()) {
                this.render.func_110776_a(this.TEXTURE);
                RenderConstants.GIRAFFE.func_178686_a(this.render.func_177087_b());
                RenderConstants.GIRAFFE.func_78087_a(f, f1, f3, f4, f5, f6, (Entity)e);
                RenderConstants.GIRAFFE.func_78088_a((Entity)e, f, f1, f2, f3, f4, f6);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

