/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityThreeToedSloth;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderSloth
extends RenderLivingZAWA<EntityThreeToedSloth>
implements IBabyModel<EntityThreeToedSloth> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderSloth(RenderManager m) {
        super(m, (ModelBase)RenderConstants.SLOTH, 0.3f);
        RenderConstants.SLOTH.setAnimator(SlothAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityThreeToedSloth entity) {
        if (TextFormatting.func_110646_a((String)entity.func_70005_c_()).toLowerCase().equals("flash")) {
            return CONTAINER.get("blinkf", 0);
        }
        if (entity.func_70631_g_()) {
            return CONTAINER.get("blinkb", 0);
        }
        return CONTAINER.get("blink", AbstractZawaLand.getVariant(entity));
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    protected void preRenderCallback(EntityThreeToedSloth entitylivingbaseIn, float partialTickTime) {
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
        GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
        if (!entitylivingbaseIn.isAsleep()) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.26f, (float)0.0f);
            if (entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.13f, (float)0.0f);
            }
        }
        if (entitylivingbaseIn.field_70170_p.func_180495_p(new BlockPos(entitylivingbaseIn.field_70165_t, entitylivingbaseIn.field_70163_u + 1.0, entitylivingbaseIn.field_70161_v)).func_177230_c() != Blocks.field_150350_a && entitylivingbaseIn.field_70170_p.func_180495_p(new BlockPos(entitylivingbaseIn.field_70165_t, entitylivingbaseIn.field_70163_u - 1.0, entitylivingbaseIn.field_70161_v)).func_177230_c() == Blocks.field_150350_a) {
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.3f, (float)0.0f);
        }
    }

    protected ResourceLocation getEntityTexture(EntityThreeToedSloth entity) {
        return TextFormatting.func_110646_a((String)entity.func_70005_c_()).toLowerCase().equals("flash") ? CONTAINER.get("special", 0) : this.getTextureOfVar(AbstractZawaLand.getVariant(entity));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.SLOTH_BABY.setAnimator(SlothAnimator::new);
        return RenderConstants.SLOTH_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityThreeToedSloth e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/sloth/sloth_1.png");
        CONTAINER.addResource("textures/entity/sloth/sloth_2.png");
        CONTAINER.addResource("textures/entity/sloth/sloth_3.png");
        CONTAINER.addResource("textures/entity/sloth/sloth_4.png");
        CONTAINER.addResource("textures/entity/sloth/sloth_5.png");
        CONTAINER.addResource("textures/entity/sloth/sloth_6.png");
        CONTAINER.addResource("baby", "textures/entity/sloth/sloth_baby.png");
        CONTAINER.addResource("special", "textures/entity/sloth/sloth_flash.png");
        CONTAINER.addResource("blink", "textures/entity/sloth/sloth_blink_1.png");
        CONTAINER.addResource("blink", "textures/entity/sloth/sloth_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/sloth/sloth_blink_3.png");
        CONTAINER.addResource("blink", "textures/entity/sloth/sloth_blink_4.png");
        CONTAINER.addResource("blink", "textures/entity/sloth/sloth_blink_5.png");
        CONTAINER.addResource("blink", "textures/entity/sloth/sloth_blink_6.png");
        CONTAINER.addResource("blinkb", "textures/entity/sloth/sloth_blink_baby.png");
        CONTAINER.addResource("blinkf", "textures/entity/sloth/sloth_blink_flash.png");
    }

    public static class SlothAnimator
    extends ZAWAAnimator<EntityThreeToedSloth> {
        private final BookwormModelRenderer Body = this.getModel().getPartByName("Body");
        private final BookwormModelRenderer Neck = this.getModel().getPartByName("Neck");
        private final BookwormModelRenderer LegLeft = this.getModel().getPartByName("Leg Left");
        private final BookwormModelRenderer FootLeft = this.getModel().getPartByName("Foot Left");
        private final BookwormModelRenderer ClawsLeft = this.getModel().getPartByName("Claws Left");
        private final BookwormModelRenderer LegRight = this.getModel().getPartByName("Leg Right");
        private final BookwormModelRenderer FootRight = this.getModel().getPartByName("Foot Right");
        private final BookwormModelRenderer ClawsRight = this.getModel().getPartByName("Claws Right");
        private final BookwormModelRenderer ArmLeft = this.getModel().getPartByName("Arm Left");
        private final BookwormModelRenderer ForearmLeft = this.getModel().getPartByName("Forearm Left");
        private final BookwormModelRenderer ClawLeft1 = this.getModel().getPartByName("Claw Left 1");
        private final BookwormModelRenderer ClawLeft2 = this.getModel().getPartByName("Claw Left 2");
        private final BookwormModelRenderer ClawLeft3 = this.getModel().getPartByName("Claw Left 3");
        private final BookwormModelRenderer ArmRight = this.getModel().getPartByName("Arm Right");
        private final BookwormModelRenderer ForearmRight = this.getModel().getPartByName("Forearm Right");
        private final BookwormModelRenderer ClawRight1 = this.getModel().getPartByName("Claw Right 1");
        private final BookwormModelRenderer ClawRight2 = this.getModel().getPartByName("Claw Right 2");
        private final BookwormModelRenderer ClawRight3 = this.getModel().getPartByName("Claw Right 3");

        public SlothAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityThreeToedSloth entity) {
            this.neck_part = this.Neck;
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.speed = 8.6f;
            this.degree = 1.0f;
            if (entity.func_70631_g_()) {
                this.speed = 2.5f;
            }
            this.Neck.field_78795_f = f4 / 57.295776f;
            this.Neck.field_78796_g = f3 / 57.295776f;
            this.Body.field_82908_p = MathHelper.func_76134_b((float)(f * (0.2462f * this.speed) + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f + 0.1f;
            this.Body.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.2462f * this.speed) + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f - 0.12f;
            this.Neck.field_78795_f = MathHelper.func_76134_b((float)(50.0f + f * (0.3062f * this.speed) + (float)Math.PI)) * (this.degree * -0.2f) * f1 * 0.5f;
            this.ArmLeft.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f - 0.05f;
            this.ArmLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.4f) * f1 * 0.5f + 0.0f;
            this.ForearmLeft.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f - 1.35f;
            this.ArmRight.field_82908_p = -MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f - 0.05f;
            this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 2.4f) * f1 * 0.5f + 0.0f;
            this.ForearmRight.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 1.8f) * f1 * 0.5f - 1.35f;
            this.LegLeft.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + 0.0f;
            this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 2.9f) * f1 * 0.5f - 0.1f + 0.0f;
            this.FootLeft.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 2.1f) * f1 * 0.5f + 1.3f;
            this.ClawsLeft.field_78795_f = MathHelper.func_76134_b((float)(50.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.1f) * f1 * 0.5f - 1.0f;
            this.LegRight.field_82908_p = -MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + 0.0f;
            this.LegRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.9f) * f1 * 0.5f - 0.1f + 0.0f;
            this.FootRight.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.1f) * f1 * 0.5f + 1.3f;
            this.ClawsRight.field_78795_f = MathHelper.func_76134_b((float)(50.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 2.1f) * f1 * 0.5f - 1.0f;
        }
    }
}

