/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.flying.EntityToucan;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderToucan
extends RenderLivingZAWA<EntityToucan>
implements IBabyModel<EntityToucan> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderToucan(RenderManager m) {
        super(m, (ModelBase)RenderConstants.TOUCAN, 0.5f);
        RenderConstants.TOUCAN.setAnimator(ToucanAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    protected void preRenderCallback(EntityToucan e, float partialTickTime) {
        super.preRenderCallback(e, partialTickTime);
        if (e.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.4f, (float)0.4f, (float)0.4f);
        }
        if (AbstractZawaLand.getVariant(e) == 3) {
            GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
        }
        GlStateManager.func_179114_b((float)e.getPitchRotation(), (float)1.0f, (float)0.0f, (float)0.0f);
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityToucan entity) {
        if (!entity.field_70122_E) {
            return null;
        }
        if (entity.func_70631_g_()) {
            return CONTAINER.get("blink", 4);
        }
        switch (AbstractZawaLand.getVariant(entity)) {
            default: {
                return CONTAINER.get("blink", AbstractZawaLand.getVariant(entity));
            }
            case 4: {
                return CONTAINER.get("blink", 3);
            }
            case 3: 
            case 5: {
                return CONTAINER.get("blink", 2);
            }
            case 1: 
            case 2: 
            case 6: 
        }
        return CONTAINER.get("blink", 1);
    }

    protected ResourceLocation getEntityTexture(EntityToucan entity) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(entity));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        return RenderConstants.TOUCAN_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityToucan e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/toucan/toucan_1.png");
        CONTAINER.addResource("textures/entity/toucan/toucan_2.png");
        CONTAINER.addResource("textures/entity/toucan/toucan_3.png");
        CONTAINER.addResource("textures/entity/toucan/toucan_4.png");
        CONTAINER.addResource("textures/entity/toucan/toucan_5.png");
        CONTAINER.addResource("textures/entity/toucan/toucan_6.png");
        CONTAINER.addResource("textures/entity/toucan/toucan_7.png");
        CONTAINER.addResource("baby", "textures/entity/toucan/toucan_baby.png");
        CONTAINER.addResource("blink", "textures/entity/toucan/toucan_blink_1.png");
        CONTAINER.addResource("blink", "textures/entity/toucan/toucan_blink_237.png");
        CONTAINER.addResource("blink", "textures/entity/toucan/toucan_blink_46.png");
        CONTAINER.addResource("blink", "textures/entity/toucan/toucan_blink_5.png");
        CONTAINER.addResource("blink", "textures/entity/toucan/toucan_blink_baby.png");
    }

    public static class ToucanAnimator
    extends ZAWAAnimator<EntityToucan> {
        protected final BookwormModelRenderer Jaw = this.getModel().getPartFromRig("Jaw");
        protected final BookwormModelRenderer Neck = this.getModel().getPartFromRig("Neck");
        protected final BookwormModelRenderer Body = this.getModel().getPartFromRig("Body");
        protected final BookwormModelRenderer LegLeft = this.getModel().getPartFromRig("LegLeft");
        protected final BookwormModelRenderer LegRight = this.getModel().getPartFromRig("LegRight");
        protected final BookwormModelRenderer Wing1Left = this.getModel().getPartFromRig("Wing1Left");
        protected final BookwormModelRenderer Wing2Left = this.getModel().getPartFromRig("Wing2Left");
        protected final BookwormModelRenderer Wing1Right = this.getModel().getPartFromRig("Wing1Right");
        protected final BookwormModelRenderer Wing2Right = this.getModel().getPartFromRig("Wing2Right");
        protected final BookwormModelRenderer Tail1 = this.getModel().getPartFromRig("Tail1");
        protected final BookwormModelRenderer Tail2 = this.getModel().getPartFromRig("Tail2");
        protected final BookwormModelRenderer FootLeft = this.getModel().getPartFromRig("FootLeft");
        protected final BookwormModelRenderer FootRight = this.getModel().getPartFromRig("FootRight");
        protected final BookwormModelRenderer Head = this.getModel().getPartFromRig("Head");
        protected final BookwormModelRenderer WingFoldedRight = this.getModel().getPartFromRig("WingFoldedRight");
        protected final BookwormModelRenderer WingFoldedLeft = this.getModel().getPartFromRig("WingFoldedLeft");

        public ToucanAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityToucan entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.speed = 1.4f;
            this.degree = 1.9f;
            if (!entity.field_70122_E && !entity.func_184218_aH()) {
                this.Wing1Left.renderPartScale = 1.0f;
                this.Wing1Right.renderPartScale = 1.0f;
                this.WingFoldedRight.renderPartScale = 0.0f;
                this.WingFoldedLeft.renderPartScale = 0.0f;
                this.degree = 1.0f;
                this.getModel().loadPosedModel((BookwormModelBase)RenderConstants.TOUCAN_FLYING);
                f = entity.field_70173_aa;
                f1 = 0.2f;
                this.speed = 1.0f;
                this.Wing1Left.field_78808_h = MathHelper.func_76134_b((float)(f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * 5.0f) * f1 * 0.5f;
                this.Wing2Left.field_78808_h = MathHelper.func_76134_b((float)(5.0f + f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * 1.0f) * f1 * 0.5f + -0.2f;
                this.Wing1Right.field_78808_h = MathHelper.func_76134_b((float)(f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * -5.0f) * f1 * 0.5f;
                this.Wing2Right.field_78808_h = MathHelper.func_76134_b((float)(5.0f + f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * -1.0f) * f1 * 0.5f + 0.2f;
                this.Body.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * -0.1f) * f1 * 0.5f;
                this.Neck.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f + 1.3f;
                this.Tail1.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f + 1.3f;
                this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * 0.4f) * f1 * 0.5f + 1.1f;
                this.LegRight.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * 0.4f) * f1 * 0.5f + 1.1f;
            } else {
                this.speed = 1.6f;
                this.degree = 1.2f;
                this.Wing1Left.renderPartScale = 0.0f;
                this.Wing1Right.renderPartScale = 0.0f;
                this.WingFoldedRight.renderPartScale = 1.0f;
                this.WingFoldedLeft.renderPartScale = 1.0f;
                this.Body.field_78795_f = MathHelper.func_76134_b((float)(5.0f + f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * 0.05f) * f1 * 0.5f + -0.33f;
                this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 3.0f) * f1 * 0.5f + 0.3f;
                this.FootLeft.field_78795_f = MathHelper.func_76134_b((float)(1.5f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.5f) * f1 * 0.5f + 0.1f;
                this.LegRight.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -3.0f) * f1 * 0.5f + 0.3f;
                this.Tail1.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * 0.07f) * f1 * 0.5f + 1.3f;
                this.Neck.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * 0.15f) * f1 * 0.5f + 0.6f;
                this.FootRight.field_78795_f = MathHelper.func_76134_b((float)(1.5f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.5f) * f1 * 0.5f + 0.1f;
                this.Body.field_82908_p = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * 0.01f) * f1 * 0.5f;
                this.Head.field_78795_f = MathHelper.func_76134_b((float)(6.0f + f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f + -0.25f;
            }
        }

        @Override
        protected void performIdleAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityToucan entity) {
            super.performIdleAnimation(f, f1, f2, f3, f4, f5, entity);
            this.Neck.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f + 0.67f;
            this.Head.field_78795_f = MathHelper.func_76134_b((float)(4.0f + f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f + -0.25f;
            this.Tail1.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f + 1.35f;
        }
    }
}

