/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.ai;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.network.ZAWAPacketHandler;
import org.zawamod.network.packets.MessagePlayAnimation;

public class EntityAIRapidEatGrass
extends EntityAIBase {
    private static final Predicate<IBlockState> IS_TALL_GRASS = BlockStateMatcher.func_177638_a((Block)Blocks.field_150329_H).func_177637_a((IProperty)BlockTallGrass.field_176497_a, Predicates.equalTo((Object)BlockTallGrass.EnumType.GRASS));
    private final AbstractZawaLand grassEaterEntity;
    private final World entityWorld;
    int eatingGrassTimer;
    private int animation = -1;

    public EntityAIRapidEatGrass(AbstractZawaLand grassEaterEntityIn) {
        this.grassEaterEntity = grassEaterEntityIn;
        this.entityWorld = grassEaterEntityIn.field_70170_p;
        this.func_75248_a(7);
    }

    public EntityAIRapidEatGrass(AbstractZawaLand grassEaterEntity, int animation) {
        this(grassEaterEntity);
        this.animation = animation;
    }

    public boolean func_75250_a() {
        if (this.grassEaterEntity.isAsleep()) {
            return false;
        }
        if (this.grassEaterEntity.func_70681_au().nextInt(this.grassEaterEntity.func_70631_g_() ? 40 : 80) != 0) {
            return false;
        }
        BlockPos blockpos = new BlockPos(this.grassEaterEntity.field_70165_t, this.grassEaterEntity.field_70163_u, this.grassEaterEntity.field_70161_v);
        if (IS_TALL_GRASS.apply((Object)this.entityWorld.func_180495_p(blockpos))) {
            return true;
        }
        return this.entityWorld.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_150349_c;
    }

    public void func_75249_e() {
        this.eatingGrassTimer = 60;
        this.entityWorld.func_72960_a((Entity)this.grassEaterEntity, (byte)10);
        this.grassEaterEntity.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.eatingGrassTimer = 0;
    }

    public boolean func_75253_b() {
        return this.eatingGrassTimer > 0;
    }

    public int getEatingGrassTimer() {
        return this.eatingGrassTimer;
    }

    public void func_75246_d() {
        this.eatingGrassTimer = Math.max(0, this.eatingGrassTimer - 1);
        if (this.eatingGrassTimer == 4) {
            BlockPos blockpos = new BlockPos(this.grassEaterEntity.field_70165_t, this.grassEaterEntity.field_70163_u, this.grassEaterEntity.field_70161_v);
            if (IS_TALL_GRASS.apply((Object)this.entityWorld.func_180495_p(blockpos))) {
                if (this.entityWorld.func_82736_K().func_82766_b("mobGriefing")) {
                    this.entityWorld.func_175655_b(blockpos, false);
                }
                this.grassEaterEntity.func_70615_aA();
            } else {
                BlockPos blockpos1 = blockpos.func_177977_b();
                if (this.entityWorld.func_180495_p(blockpos1).func_177230_c() == Blocks.field_150349_c) {
                    if (this.entityWorld.func_82736_K().func_82766_b("mobGriefing")) {
                        if (this.grassEaterEntity.func_70909_n() && ModuleManager.HUNGER.getHunger(this.grassEaterEntity) < ModuleManager.HUNGER.getMaxFood() - 0.5f) {
                            ModuleManager.HUNGER.setHunger(this.grassEaterEntity, ModuleManager.HUNGER.getHunger(this.grassEaterEntity) + 0.5f);
                        }
                        this.entityWorld.func_175718_b(2001, blockpos1, Block.func_149682_b((Block)Blocks.field_150349_c));
                        this.entityWorld.func_180501_a(blockpos1, Blocks.field_150346_d.func_176223_P(), 2);
                    }
                    this.grassEaterEntity.func_70615_aA();
                }
            }
            if (this.animation != -1 && !this.grassEaterEntity.func_70631_g_()) {
                MessagePlayAnimation anim = new MessagePlayAnimation((Entity)this.grassEaterEntity, this.animation);
                ZAWAPacketHandler.net.sendToAllTracking((IMessage)anim, (Entity)this.grassEaterEntity);
            }
        }
    }
}

