/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.core;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.modules.ModuleManager;

public class UsableObject<T> {
    public final Style STYLE;
    public final Type TYPE;
    public final T OBJECT;
    public int blockUseDistance = 7;
    public Function<AbstractZawaLand, Boolean> shouldUse;
    public BiFunction<AbstractZawaLand, BlockPos, Boolean> canUsePos = (entity, pos) -> true;
    public BiFunction<AbstractZawaLand, Entity, Boolean> canUseEntity = (entity, enrichment) -> true;
    public BiFunction<AbstractZawaLand, EntityPlayer, Boolean> canUseStack = (entity, stack) -> true;
    public BiConsumer<AbstractZawaLand, BlockPos> onUsePos = (entity, pos) -> {};
    public BiConsumer<AbstractZawaLand, EntityPlayer> onUseStack = (entity, player) -> {};
    public BiConsumer<AbstractZawaLand, Entity> onUseEntity = (entity, enrichment) -> {};
    public List<Class<? extends Entity>> validityList = new ArrayList<Class<? extends Entity>>();
    public List<Class<? extends Entity>> invalidityList = new ArrayList<Class<? extends Entity>>();
    public boolean displayInBook = true;
    public Function<Class<? extends Entity>, Boolean> isEntityValid = entity -> {
        if (this.validityList.isEmpty() && !this.invalidityList.isEmpty()) {
            return !this.invalidityList.contains(entity);
        }
        return this.validityList.isEmpty() || this.validityList.contains(entity) && !this.invalidityList.contains(entity);
    };
    public float enrichmentAmount;
    public boolean directInteraction = false;
    public float detectionDistanceBlock;
    public float useDistanceBlock = this.detectionDistanceBlock = 10.0f;
    public float thirstAmount;
    public float saturation;

    public UsableObject(Style style, Type type, T object) {
        this.STYLE = style;
        this.OBJECT = object;
        this.TYPE = type;
        this.shouldUse = o -> {
            switch (this.TYPE) {
                case WATER: {
                    return this.isEntityValid.apply(o.getClass()) != false && ModuleManager.THIRST.isThirsty((AbstractZawaLand)o);
                }
                case ENRICHMENT: {
                    return this.isEntityValid.apply(o.getClass()) != false && ModuleManager.ENRICHMENT.lowEnrichment((AbstractZawaLand)o);
                }
                case OTHER: {
                    return this.isEntityValid.apply(o.getClass()) != false && ModuleManager.HUNGER.isHungry((AbstractZawaLand)o);
                }
            }
            return false;
        };
        this.onUsePos = (e, p) -> {
            switch (this.TYPE) {
                case WATER: {
                    ModuleManager.THIRST.onDrink((AbstractZawaLand)e, this);
                    break;
                }
                case ENRICHMENT: {
                    ModuleManager.ENRICHMENT.onEnrich((AbstractZawaLand)e, this);
                }
            }
        };
        this.onUseEntity = (e, p) -> {
            switch (this.TYPE) {
                case WATER: {
                    ModuleManager.THIRST.onDrink((AbstractZawaLand)e, this);
                    break;
                }
                case ENRICHMENT: {
                    ModuleManager.ENRICHMENT.onEnrich((AbstractZawaLand)e, this);
                }
            }
        };
    }

    public static enum Type {
        WATER,
        ENRICHMENT,
        OTHER;

    }

    public static enum Style {
        BLOCK,
        ITEM,
        ENTITY;

    }
}

