/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.lerp.Animation;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.AnimalPack;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.entity.water.EntitySockeyeSalmon;
import org.zawamod.util.AnimalPackManager;
import org.zawamod.util.RenderConstants;
import org.zawamod.util.ZAWASounds;

public class EntityPolarBear
extends AbstractZawaLand {
    private boolean carryingSalmon = false;
    private int salmonTicks = 0;
    private int breathingTime = 0;
    private boolean wantsAir = false;

    public EntityPolarBear(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.3f, 1.5f);
        this.setEnableFindNavLand(true);
    }

    @Override
    public AnimalPack getPack() {
        return AnimalPackManager.POLAR_BEAR;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Animation getSleepAnimation() {
        return new Animation(new BookwormModelBase[]{RenderConstants.POLAR_BEAR, RenderConstants.POLAR_BEAR_SLEEPING});
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Animation getChildSleepAnimation() {
        return new Animation(new BookwormModelBase[]{RenderConstants.POLAR_BEAR_CUB, RenderConstants.POLAR_BEAR_CUB_SLEEPING});
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.85f - 0.2f;
    }

    protected SoundEvent func_184639_G() {
        return ZAWASounds.POLARBEAR_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ZAWASounds.POLARBEAR_HURT;
    }

    @SideOnly(value=Side.CLIENT)
    public void playEatEffect() {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.CLOUD;
        for (int i = 0; i < 3; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - (double)MathHelper.func_76126_a((float)(-this.field_70761_aq * ((float)Math.PI / 180))) + (double)(MathHelper.func_76126_a((float)(-this.field_70761_aq * ((float)Math.PI / 180))) * 0.7f), this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N + (double)MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) + (double)(MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) * 0.7f), d0, d1, d2, new int[0]);
        }
    }

    @Override
    public void func_70636_d() {
        if (this.field_70171_ac) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.06);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.24);
        }
        double distance2 = 4.0;
        Entity entityFound2 = null;
        double d4 = -1.0;
        for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
            Entity currE = (Entity)this.field_70170_p.field_72996_f.get(i);
            if (!(currE instanceof EntitySockeyeSalmon) || currE == this) continue;
            double d5 = currE.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (!(distance2 < 0.0) && !(d5 < distance2 * distance2) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entityFound2 = currE;
        }
        if (entityFound2 != null && !entityFound2.field_70128_L && !this.carryingSalmon) {
            entityFound2.func_70106_y();
            this.carryingSalmon = true;
        }
        if (this.carryingSalmon) {
            ++this.salmonTicks;
            if (this.salmonTicks >= 40) {
                this.carryingSalmon = false;
                if (this.field_70170_p.field_72995_K) {
                    this.playEatEffect();
                }
                this.salmonTicks = 0;
                if (this.func_70909_n()) {
                    ModuleManager.HUNGER.setHunger(this, ModuleManager.HUNGER.getHunger(this) + 3.0f);
                }
            }
        }
        super.func_70636_d();
    }

    public boolean getSalmon() {
        return this.carryingSalmon;
    }

    @Override
    public void func_70071_h_() {
        if (this.func_70613_aW()) {
            this.updateMotion();
        }
        super.func_70071_h_();
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        if (!this.field_70171_ac) {
            super.func_70653_a(entityIn, strength, xRatio, zRatio);
        }
    }

    private void updateMotion() {
        if (this.field_70171_ac) {
            if (this.func_70086_ai() >= 299 && !this.wantsAir) {
                this.wantsAir = true;
                this.breathingTime = 140;
            }
            if (this.breathingTime > -6) {
                --this.breathingTime;
            }
            if (this.breathingTime <= -6) {
                this.wantsAir = false;
            }
            if (this.func_70661_as().func_75500_f() && this.func_70086_ai() > 200 && this.breathingTime <= 0) {
                this.field_70181_x -= 0.001;
                this.breathingTime = 0;
            } else {
                this.field_70159_w *= 1.2;
                this.field_70179_y *= 1.2;
                double d1 = this.func_189652_ae() ? 0.0 : (double)-0.04f;
                double waterLevel = this.func_174813_aQ().field_72337_e;
                double d2 = (waterLevel - this.func_174813_aQ().field_72338_b) / (double)this.field_70131_O - 0.0;
                this.field_70181_x += d1;
                if (this.func_70055_a(Material.field_151586_h)) {
                    this.field_70181_x = 0.03f;
                }
                if (d2 > 0.0) {
                    this.field_70181_x += d2 * 0.06153846016296973;
                    this.field_70181_x *= 0.75;
                }
            }
        }
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityPolarBear(this.field_70170_p);
    }
}

