/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.soggymustache.bookworm.client.animation.lerp.Animation;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.util.BookwormUtils;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.AnimalPack;
import org.zawamod.entity.core.IMultiSpeciesEntity;
import org.zawamod.entity.general.EntityZAWAEgg;
import org.zawamod.network.ZAWAPacketHandler;
import org.zawamod.network.packets.MessageSyncTreeFrogCling;
import org.zawamod.util.AnimalPackManager;
import org.zawamod.util.DataItem;
import org.zawamod.util.RenderConstants;
import org.zawamod.util.StringedItem;
import org.zawamod.util.ZAWASounds;
import org.zawamod.util.status.StatusJumping;

public class EntityTreeFrog
extends AbstractZawaLand
implements IMultiSpeciesEntity {
    private BlockPos posClingPosition;
    public EnumFacing collision;
    private int cool;
    private boolean canGo;
    public int groundTime;

    public EntityTreeFrog(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.4f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
    }

    @Override
    public AnimalPack getPack() {
        return AnimalPackManager.FROG;
    }

    @Override
    @Nullable
    public Animation getSleepAnimation() {
        return new Animation(new BookwormModelBase[]{RenderConstants.TREE_FROG, RenderConstants.TREE_FROG_SLEEP});
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.85f;
    }

    public BlockPos getClingPos() {
        return this.posClingPosition;
    }

    public void setClingPos(BlockPos p) {
        this.posClingPosition = p;
    }

    @Override
    public void func_70071_h_() {
        if (!this.isAsleep()) {
            if (this.field_70123_F && this.canGo) {
                block15: {
                    for (EnumFacing facing : EnumFacing.field_176754_o) {
                        BlockPos pos = this.func_180425_c().func_177972_a(facing);
                        Block block = this.field_70170_p.func_180495_p(pos).func_177230_c();
                        if (block == Blocks.field_150350_a) continue;
                        this.posClingPosition = pos;
                        this.func_70671_ap().func_75650_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 10.0f, 10.0f);
                        this.collision = facing;
                        break block15;
                    }
                    this.posClingPosition = null;
                }
                if (!this.field_70170_p.field_72995_K && this.getClingPos() != null) {
                    MessageSyncTreeFrogCling msg = new MessageSyncTreeFrogCling(this.func_145782_y(), this.getClingPos());
                    ZAWAPacketHandler.net.sendToAllTracking((IMessage)msg, (Entity)this);
                }
            }
            if (this.cool == 0) {
                this.canGo = false;
            }
            if (this.cool < 50) {
                ++this.cool;
            } else {
                this.canGo = true;
            }
            if (this.posClingPosition != null) {
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                this.func_189654_d(true);
                Vec3d vec3 = this.func_174824_e(1.0f);
                Vec3d vec3a = this.func_70676_i(1.0f);
                float distance = 1.1f;
                Vec3d vec3b = vec3.func_72441_c(vec3a.field_72450_a * (double)distance, vec3a.field_72448_b * (double)distance, vec3a.field_72449_c * (double)distance);
                RayTraceResult mop = this.field_70170_p.func_72933_a(vec3, vec3b);
                if (mop != null) {
                    if (mop.func_178782_a() != null) {
                        if (this.field_70170_p.func_180495_p(mop.func_178782_a()).func_177230_c() == Blocks.field_150350_a) {
                            this.func_189654_d(false);
                            this.canGo = false;
                            this.cool = 0;
                            this.posClingPosition = null;
                        }
                    } else {
                        this.func_189654_d(false);
                        this.cool = 0;
                        this.canGo = false;
                        this.posClingPosition = null;
                    }
                } else {
                    this.func_189654_d(false);
                    this.cool = 0;
                    this.canGo = false;
                    this.posClingPosition = null;
                }
            } else {
                this.func_189654_d(false);
            }
        }
        if (BookwormUtils.isEntityMoving((Entity)this) && this.field_70122_E && this.field_70173_aa % 8 == 0) {
            this.field_70181_x = 0.3f;
            float f = this.field_70177_z * ((float)Math.PI / 180);
            this.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.2f) * (double)1.1f;
            this.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.2f) * (double)1.1f;
        }
        super.func_70071_h_();
    }

    @Override
    public boolean isSleepEnabled() {
        return this.getClingPos() == null && super.isSleepEnabled();
    }

    @Override
    public DataItem getIconList() {
        ArrayList<StringedItem> s = new ArrayList<StringedItem>();
        s.add(new StatusJumping());
        return new DataItem(s);
    }

    protected SoundEvent func_184639_G() {
        return ZAWASounds.FROG_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource s) {
        return ZAWASounds.FROG_HURT;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityZAWAEgg((Entity)this);
    }

    @Override
    public Map<Integer, String> speciesData() {
        HashMap<Integer, String> data = new HashMap<Integer, String>();
        data.put(0, "African Foam-nest");
        data.put(1, "Amazon Milk");
        data.put(2, "Clown");
        data.put(3, "Copes Gray");
        data.put(4, "Cuban");
        data.put(5, "Glass");
        data.put(6, "Lemur");
        data.put(7, "Mossy");
        data.put(8, "Panamanian Gold");
        data.put(9, "Red-Eyed");
        data.put(10, "Vietnamese Blue");
        data.put(11, "White's");
        return data;
    }
}

