/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.water;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseWater;
import org.zawamod.entity.core.AnimalPack;
import org.zawamod.util.AnimalPackManager;
import org.zawamod.util.ZAWAUtils;

public class EntityHumpbackWhale
extends ZAWABaseWater {
    private int lastJump = 600;
    private boolean justJumped = false;
    private boolean breaching;
    public int breachTime;
    private int waterTime;

    public EntityHumpbackWhale(World worldIn) {
        super(worldIn);
        this.func_70105_a(4.0f, 3.5f);
        this.isBubble = false;
        this.setMaxTime(30);
        this.setTimeMultiplier(0.001f);
    }

    @Override
    public AnimalPack getPack() {
        return AnimalPackManager.WHALE;
    }

    public boolean isBreaching() {
        return this.breaching;
    }

    @Override
    public void func_70636_d() {
        block11: {
            if (this.justJumped) {
                this.breaching = true;
            }
            if (this.breaching) {
                ++this.breachTime;
            }
            if (this.breaching && this.func_70090_H()) {
                ++this.waterTime;
                if (this.breachTime >= 3 && this.waterTime >= 20) {
                    this.breachTime = 0;
                    this.waterTime = 0;
                    this.breaching = false;
                }
            }
            if (this.justJumped) {
                this.lastJump = 0;
                this.justJumped = false;
            } else {
                ++this.lastJump;
            }
            if (this.lastJump < 500) {
                this.field_70181_x -= (double)0.02f;
            }
            if (ZAWAUtils.blockAtPos(this.field_70170_p, Blocks.field_150350_a, (int)this.field_70165_t, (int)this.field_70163_u + 1, (int)this.field_70161_v) && this.field_70171_ac && this.lastJump >= 500) {
                float f = this.field_70177_z * ((float)Math.PI / 180);
                for (int i = -1; i < 2; ++i) {
                    for (int j = -2; j < 1; ++j) {
                        IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t - (double)(MathHelper.func_76126_a((float)f) * 5.0f) + (double)i, this.field_70163_u, this.field_70161_v + (double)(MathHelper.func_76134_b((float)f) * 5.0f) + (double)j));
                        if (this.field_70177_z == this.field_70126_B && state.func_185904_a() == Material.field_151586_h) {
                            continue;
                        }
                        break block11;
                    }
                }
                this.func_70671_ap().func_75650_a(this.field_70165_t - (double)(MathHelper.func_76126_a((float)f) * 5.0f), this.field_70163_u, this.field_70161_v + (double)(MathHelper.func_76134_b((float)f) * 5.0f), 8.0f, 10.0f);
                this.field_70181_x *= 3.299999976158142;
                this.field_70181_x = this.func_175134_bD();
                this.justJumped = true;
                this.field_70159_w = -((double)(MathHelper.func_76126_a((float)f) * 0.5f));
                this.field_70179_y = MathHelper.func_76134_b((float)f) * 0.5f;
            }
        }
        super.func_70636_d();
    }

    @Override
    public void func_191986_a(float p_191986_1_, float p_191986_2_, float p_191986_3_) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_191958_b(p_191986_1_, p_191986_2_, p_191986_3_, 0.1f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
            if (!this.isMoving() && this.func_70638_az() == null) {
                this.field_70181_x -= 0.008;
            }
        } else {
            super.func_191986_a(p_191986_1_, p_191986_2_, p_191986_3_);
        }
    }

    @Override
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityHumpbackWhale(this.field_70170_p);
    }
}

