/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.water;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.base.ZAWABaseWater;
import org.zawamod.entity.core.AnimalPack;
import org.zawamod.network.ZAWAPacketHandler;
import org.zawamod.network.packets.MessagePlayAnimation;
import org.zawamod.util.AnimalPackManager;
import org.zawamod.util.AnimationConstants;

public class EntityOctopus
extends ZAWABaseWater {
    public boolean hidden;
    private int hideTicks;
    private int lastHide;
    public static final int SWIM_ANIMATION = 0;

    public EntityOctopus(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 0.5f);
        this.func_70659_e(5.00012f);
        this.field_70765_h = new OctopusMoveHelper(this);
        if (this.field_70170_p.field_72995_K) {
            this.getAnimator().addAnimation(0, AbstractZawaLand.getVariant(this) == 0 ? AnimationConstants.OCTOPUS_SWIMMING : AnimationConstants.CMNOCTOPUS_SWIMMING);
        }
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 16.0f, 0.8, 1.33));
    }

    @Override
    public AnimalPack getPack() {
        return AnimalPackManager.OCTOPUS;
    }

    @Override
    public boolean func_70652_k(Entity e) {
        if (e instanceof EntityLiving) {
            ((EntityLiving)e).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 30, 1));
        }
        return super.func_70652_k(e);
    }

    @Override
    public void func_70071_h_() {
        this.hidden = false;
        super.func_70071_h_();
    }

    @Override
    public int func_70646_bf() {
        return 1;
    }

    @Override
    public void func_191986_a(float p_191986_1_, float p_191986_2_, float p_191986_3_) {
        if (this.func_70613_aW() && this.func_70090_H() && !this.hidden) {
            this.func_191958_b(p_191986_1_, p_191986_2_, p_191986_3_, 0.1f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
            if (!this.isMoving() && this.func_70638_az() == null) {
                this.field_70181_x -= 0.003;
            }
            if (this.isMoving() && this.field_70122_E) {
                this.field_70181_x += 0.001;
            }
        } else {
            super.func_191986_a(p_191986_1_, p_191986_2_, p_191986_3_);
        }
    }

    @Override
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityOctopus(this.field_70170_p);
    }

    static class OctopusMoveHelper
    extends EntityMoveHelper {
        private final EntityOctopus entityGuardian;

        public OctopusMoveHelper(EntityOctopus Swimmer) {
            super((EntityLiving)Swimmer);
            this.entityGuardian = Swimmer;
        }

        public void func_75641_c() {
            this.field_75645_e = 0.9f;
            if (!this.entityGuardian.func_70661_as().func_75500_f() && !this.entityGuardian.hidden) {
                if (this.entityGuardian.field_70173_aa % 20 == 0) {
                    if (this.entityGuardian.field_70170_p.field_72995_K) {
                        this.entityGuardian.getAnimator().play(0);
                    } else {
                        MessagePlayAnimation a = new MessagePlayAnimation((Entity)this.field_75648_a, 0);
                        ZAWAPacketHandler.net.sendToAllTracking((IMessage)a, (Entity)this.field_75648_a);
                    }
                }
                double d0 = this.field_75646_b - this.entityGuardian.field_70165_t;
                double d1 = this.field_75647_c - this.entityGuardian.field_70163_u;
                double d2 = this.field_75644_d - this.entityGuardian.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                this.entityGuardian.field_70761_aq = this.entityGuardian.field_70177_z = this.func_75639_a(this.entityGuardian.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.entityGuardian.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.entityGuardian.func_70659_e(this.entityGuardian.func_70689_ay() + (f1 - this.entityGuardian.func_70689_ay()) * 0.125f);
                double d4 = Math.sin((double)(this.entityGuardian.field_70173_aa + this.entityGuardian.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.entityGuardian.field_70177_z * (float)Math.PI / 180.0f);
                double d6 = Math.sin(this.entityGuardian.field_70177_z * (float)Math.PI / 180.0f);
                this.entityGuardian.field_70159_w += d4 * d5;
                this.entityGuardian.field_70179_y += d4 * d6;
                d4 = Math.sin((double)(this.entityGuardian.field_70173_aa + this.entityGuardian.func_145782_y()) * 0.75) * 0.05;
                this.entityGuardian.field_70181_x += d4 * (d6 + d5) * 0.25;
                this.entityGuardian.field_70181_x += (double)this.entityGuardian.func_70689_ay() * d1 * 0.1;
                EntityLookHelper entitylookhelper = this.entityGuardian.func_70671_ap();
                double d7 = this.entityGuardian.field_70165_t + d0 / d3 * 2.0;
                double d8 = (double)this.entityGuardian.func_70047_e() + this.entityGuardian.field_70163_u + d1 / d3;
                double d9 = this.entityGuardian.field_70161_v + d2 / d3 * 2.0;
                double d10 = entitylookhelper.func_180423_e();
                double d11 = entitylookhelper.func_180422_f();
                double d12 = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                }
                this.entityGuardian.func_70671_ap().func_75650_a(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
                this.entityGuardian.setMoving(true);
            } else {
                this.entityGuardian.func_70659_e(0.0f);
                this.entityGuardian.setMoving(false);
            }
        }
    }
}

