/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.init.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zawamod.ZAWAMain;
import org.zawamod.init.ZAWABlocks;
import org.zawamod.init.blocks.ZAWABlockFlower;

public class BlockBamboo
extends ZAWABlockFlower
implements IPlantable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)15);
    private boolean type;

    public BlockBamboo(String unlocalizedName, boolean type) {
        super(unlocalizedName);
        this.type = type;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149647_a(ZAWAMain.zawaTabPlants);
        this.func_149672_a(SoundType.field_185849_b);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (((!this.type ? worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == ZAWABlocks.DRIED_BAMBOO : worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == ZAWABlocks.BAMBOO) || this.checkForDrop(worldIn, pos, state)) && worldIn.func_175623_d(pos.func_177984_a())) {
            int i = 1;
            while (worldIn.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                ++i;
            }
            if (i < 4) {
                int j = (Integer)state.func_177229_b((IProperty)AGE);
                if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)true)) {
                    if (j == 15) {
                        worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)), 4);
                    } else {
                        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
                }
            }
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        Block block = state.func_177230_c();
        if (block.canSustainPlant(state, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this)) {
            return true;
        }
        if (block == this) {
            return true;
        }
        if (block != Blocks.field_150349_c && block != Blocks.field_150346_d && block != Blocks.field_150354_m) {
            return false;
        }
        BlockPos blockpos = pos.func_177977_b();
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177972_a(enumfacing));
            if (iblockstate.func_185904_a() != Material.field_151586_h && iblockstate.func_177230_c() != Blocks.field_185778_de) continue;
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkForDrop(worldIn, pos, state);
    }

    protected final boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (this.canBlockStay(worldIn, pos)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
        return false;
    }

    public boolean canBlockStay(World worldIn, BlockPos pos) {
        return this.func_176196_c(worldIn, pos);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.type ? Item.func_150898_a((Block)ZAWABlocks.BAMBOO) : Item.func_150898_a((Block)ZAWABlocks.DRIED_BAMBOO);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.type ? ZAWABlocks.BAMBOO : ZAWABlocks.DRIED_BAMBOO);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }
}

