/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.proxy;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.zawamod.client.model.armor.ScubaGearChest;
import org.zawamod.client.model.armor.ScubaGearChestAlex;
import org.zawamod.client.model.armor.ScubaGearFlippers;
import org.zawamod.client.model.armor.ScubaGearGoggles;
import org.zawamod.client.model.armor.ScubaGearLegs;
import org.zawamod.configuration.ZAWAConfig;
import org.zawamod.configuration.ZAWASpawnConfiguration;
import org.zawamod.init.items.ArmorWetsuit;
import org.zawamod.proxy.CommonProxy;
import org.zawamod.util.EggData;

public class ClientProxy
extends CommonProxy {
    private static final ScubaGearChestAlex ARMOR_MODEL_TANK_ALEX = new ScubaGearChestAlex();
    private static final ScubaGearChest ARMOR_MODEL_TANK = new ScubaGearChest();
    private static final ScubaGearFlippers ARMOR_MODEL_FLIPPERS = new ScubaGearFlippers();
    private static final ScubaGearGoggles ARMOR_MODEL_GOGGLES = new ScubaGearGoggles();
    private static final ScubaGearLegs ARMOR_MODEL_WETSUIT = new ScubaGearLegs();
    private static final Map<String, EggData> EGG_DATA = new HashMap<String, EggData>();
    public static final ResourceLocation RAPTOR = new ResourceLocation("zawa", "textures/entity/egg/egg_raptor.png");
    public static final ResourceLocation CASSOWARY = new ResourceLocation("zawa", "textures/entity/egg/egg_cassowary.png");

    @Override
    public Map<String, EggData> getEggData() {
        return EGG_DATA;
    }

    @Override
    public EntityPlayer getPlayer(MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            return ctx.getServerHandler().field_147369_b;
        }
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public ModelBiped getArmorModel(ItemStack armorItem, int id, boolean isAlex) {
        if (armorItem.func_77973_b() instanceof ArmorWetsuit) {
            switch (id) {
                default: {
                    return ARMOR_MODEL_GOGGLES;
                }
                case 1: {
                    return isAlex ? ARMOR_MODEL_TANK_ALEX : ARMOR_MODEL_TANK;
                }
                case 2: {
                    return ARMOR_MODEL_WETSUIT;
                }
                case 3: 
            }
            return ARMOR_MODEL_FLIPPERS;
        }
        return null;
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        if (ZAWAConfig.serverOptions.canSpawn) {
            ZAWASpawnConfiguration.getData().forEach(spawn -> {
                if (spawn.enabled && spawn.chance > 0) {
                    spawn.getBiomes().forEach(b -> {
                        Biome.SpawnListEntry e = new Biome.SpawnListEntry(spawn.entity, spawn.chance, spawn.min, spawn.max);
                        b.func_76747_a(spawn.type).add(e);
                    });
                }
            });
        }
    }

    static {
        EGG_DATA.put("zawa:cassowary", new EggData(CASSOWARY, 2.0f, 2.0f, 2.0f));
        EGG_DATA.put("zawa:baldeagle", new EggData(RAPTOR, 1.5f, 1.5f, 1.5f));
        EGG_DATA.put("zawa:greathornedowl", new EggData(RAPTOR, 1.5f, 1.5f, 1.5f));
        EGG_DATA.put("zawa:harpyeagle", new EggData(RAPTOR, 1.5f, 1.5f, 1.5f));
        EGG_DATA.put("zawa:andeancondor", new EggData(RAPTOR, 1.5f, 1.5f, 1.5f));
        EGG_DATA.put("zawa:fijibandediguana", new EggData(0.5f, 0.5f, 0.5f));
        EGG_DATA.put("zawa:marineiguana", new EggData(0.5f, 0.5f, 0.5f));
        EGG_DATA.put("zawa:treefrog", new EggData(0.5f, 0.5f, 0.5f));
        EGG_DATA.put("zawa:japanesegiantsalamander", new EggData(0.5f, 0.5f, 0.5f));
        EGG_DATA.put("zawa:gilamonster", new EggData(0.5f, 0.5f, 0.5f));
        EGG_DATA.put("zawa:rattlesnake", new EggData(0.5f, 0.5f, 0.5f));
        EGG_DATA.put("zawa:komododragon", new EggData());
        EGG_DATA.put("zawa:galapagostortoise", new EggData());
        EGG_DATA.put("zawa:indiangharial", new EggData());
        EGG_DATA.put("zawa:macaw", new EggData());
        EGG_DATA.put("zawa:cockatoo", new EggData());
        EGG_DATA.put("zawa:toucan", new EggData());
        EGG_DATA.put("zawa:platypus", new EggData());
        EGG_DATA.put("zawa:echidna", new EggData());
        EGG_DATA.put("zawa:frigate", new EggData());
    }
}

