/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SpawnUtils {
    public static Biome[] removeBiomes(Biome[] biomes, Biome ... remove) {
        for (Biome b : biomes) {
            for (Biome bR : remove) {
                if (b != bR) continue;
                b = null;
            }
        }
        ArrayList valid = Lists.newArrayList();
        for (Biome b : biomes) {
            if (b == null) continue;
            valid.add(b);
        }
        return valid.toArray(new Biome[0]);
    }

    public static Biome[] mergeBiomes(Biome[] ... biomes) {
        ArrayList valid = Lists.newArrayList();
        for (Biome[] biome : biomes) {
            Collections.addAll(valid, biome);
        }
        return valid.toArray(new Biome[0]);
    }

    public static String[] getBiomeIDS(Biome[] biomes) {
        ArrayList b = Lists.newArrayList();
        Stream.of(biomes).forEach(a -> {
            String q = Objects.requireNonNull(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)a)).toString();
            if (!b.contains(q)) {
                b.add(q);
            }
        });
        return b.toArray(new String[0]);
    }

    public static Biome[] getBiomesOfType(BiomeDictionary.Type type) {
        ArrayList valid = Lists.newArrayList();
        for (Biome b : Biome.field_185377_q) {
            Set bom = BiomeDictionary.getTypes((Biome)b);
            if (!bom.contains(type)) continue;
            valid.add(b);
        }
        return valid.toArray(new Biome[0]);
    }
}

